/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.network;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OCoordinateMessagesFactory;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OCoordinatedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ODistributedExecutable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OOperationResponse
implements OBinaryRequest,
ODistributedExecutable {
    private OLogId id;
    private ONodeResponse response;
    private String senderNode;
    private String database;
    private OCoordinateMessagesFactory factory;

    public OOperationResponse(String senderNode, String database, OLogId id, ONodeResponse response) {
        this.id = id;
        this.senderNode = senderNode;
        this.response = response;
        this.database = database;
    }

    public OOperationResponse(OCoordinateMessagesFactory coordinateMessagesFactory) {
        this.factory = coordinateMessagesFactory;
    }

    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        DataOutputStream output = new DataOutputStream(network.getDataOutput());
        output.writeUTF(this.senderNode);
        output.writeUTF(this.database);
        OLogId.serialize(this.id, output);
        output.writeInt(this.response.getResponseType());
        this.response.serialize(output);
    }

    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        DataInputStream input = new DataInputStream(channel.getDataInput());
        this.senderNode = input.readUTF();
        this.database = input.readUTF();
        this.id = OLogId.deserialize(input);
        int responseType = input.readInt();
        this.response = this.factory.createOperationResponse(responseType);
        this.response.deserialize(input);
    }

    public byte getCommand() {
        return 106;
    }

    public OBinaryResponse createResponse() {
        return null;
    }

    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public void executeDistributed(OCoordinatedExecutor executor) {
        executor.executeOperationResponse(this);
    }

    public ONodeResponse getResponse() {
        return this.response;
    }

    public OLogId getId() {
        return this.id;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSenderNode() {
        return this.senderNode;
    }
}

