/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.network;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OCoordinateMessagesFactory;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OCoordinatedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ODistributedExecutable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OOperationRequest
implements OBinaryRequest,
ODistributedExecutable {
    private String senderNode;
    private String database;
    private OLogId id;
    private ONodeRequest request;
    private OCoordinateMessagesFactory factory;

    public OOperationRequest(String senderNode, String database, OLogId id, ONodeRequest request) {
        this.senderNode = senderNode;
        this.database = database;
        this.id = id;
        this.request = request;
    }

    public OOperationRequest(OCoordinateMessagesFactory coordinateMessagesFactory) {
        this.factory = coordinateMessagesFactory;
    }

    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        DataOutputStream output = new DataOutputStream(network.getDataOutput());
        output.writeUTF(this.senderNode);
        output.writeUTF(this.database);
        OLogId.serialize(this.id, output);
        output.writeInt(this.request.getRequestType());
        this.request.serialize(output);
    }

    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        DataInputStream input = new DataInputStream(channel.getDataInput());
        this.senderNode = input.readUTF();
        this.database = input.readUTF();
        this.id = OLogId.deserialize(input);
        int requestType = input.readInt();
        this.request = this.factory.createOperationRequest(requestType);
        this.request.deserialize(input);
    }

    public byte getCommand() {
        return 105;
    }

    public OBinaryResponse createResponse() {
        return null;
    }

    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return null;
    }

    public String getDescription() {
        return "Distributed Operation Request/Response";
    }

    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public void executeDistributed(OCoordinatedExecutor executor) {
        executor.executeOperationRequest(this);
    }

    public OLogId getId() {
        return this.id;
    }

    public ONodeRequest getRequest() {
        return this.request;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSenderNode() {
        return this.senderNode;
    }
}

