/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.network;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OCoordinateMessagesFactory;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OCoordinatedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ODistributedExecutable;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ONetworkSubmitResponse
implements OBinaryRequest,
ODistributedExecutable {
    private String senderNode;
    private String database;
    private OSessionOperationId operationId;
    private OSubmitResponse response;
    private OCoordinateMessagesFactory factory;

    public ONetworkSubmitResponse(String senderNode, String database, OSessionOperationId operationId, OSubmitResponse response) {
        this.senderNode = senderNode;
        this.database = database;
        this.operationId = operationId;
        this.response = response;
    }

    public ONetworkSubmitResponse(OCoordinateMessagesFactory coordinateMessagesFactory) {
        this.factory = coordinateMessagesFactory;
    }

    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        DataOutputStream output = new DataOutputStream(network.getDataOutput());
        this.operationId.serialize(output);
        output.writeUTF(this.senderNode);
        output.writeUTF(this.database);
        output.writeInt(this.response.getResponseType());
        this.response.serialize(output);
    }

    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        DataInputStream input = new DataInputStream(channel.getDataInput());
        this.operationId = new OSessionOperationId();
        this.operationId.deserialize(input);
        this.senderNode = input.readUTF();
        this.database = input.readUTF();
        int responseType = input.readInt();
        this.response = this.factory.createSubmitResponse(responseType);
        this.response.deserialize(input);
    }

    public byte getCommand() {
        return 104;
    }

    public OBinaryResponse createResponse() {
        return null;
    }

    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return null;
    }

    public String getDescription() {
        return "execution response from coordinator";
    }

    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public void executeDistributed(OCoordinatedExecutor executor) {
        executor.executeSubmitResponse(this);
    }

    public OSubmitResponse getResponse() {
        return this.response;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSenderNode() {
        return this.senderNode;
    }

    public OSessionOperationId getOperationId() {
        return this.operationId;
    }
}

