/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.network;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OCoordinateMessagesFactory;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OCoordinatedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ODistributedExecutable;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ONetworkSubmitRequest
implements OBinaryRequest,
ODistributedExecutable {
    private String senderNode;
    private String database;
    private OSubmitRequest request;
    private OCoordinateMessagesFactory factory;
    private OSessionOperationId operationId;

    public ONetworkSubmitRequest(String senderNode, String database, OSessionOperationId operationId, OSubmitRequest request) {
        this.database = database;
        this.request = request;
        this.senderNode = senderNode;
        this.operationId = operationId;
    }

    public ONetworkSubmitRequest(OCoordinateMessagesFactory coordinateMessagesFactory) {
        this.factory = coordinateMessagesFactory;
    }

    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        DataOutputStream output = new DataOutputStream(network.getDataOutput());
        this.operationId.serialize(output);
        output.writeUTF(this.senderNode);
        output.writeUTF(this.database);
        output.writeInt(this.request.getRequestType());
        this.request.serialize(output);
    }

    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        DataInputStream input = new DataInputStream(channel.getDataInput());
        this.operationId = new OSessionOperationId();
        this.operationId.deserialize(input);
        this.senderNode = input.readUTF();
        this.database = input.readUTF();
        int requestType = input.readInt();
        this.request = this.factory.createSubmitRequest(requestType);
        this.request.deserialize(input);
    }

    public byte getCommand() {
        return 103;
    }

    public OBinaryResponse createResponse() {
        return null;
    }

    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return null;
    }

    public String getDescription() {
        return "Execution request to the coordinator";
    }

    public boolean requireDatabaseSession() {
        return false;
    }

    @Override
    public void executeDistributed(OCoordinatedExecutor executor) {
        executor.executeSubmitRequest(this);
    }

    public OSubmitRequest getRequest() {
        return this.request;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSenderNode() {
        return this.senderNode;
    }

    public OSessionOperationId getOperationId() {
        return this.operationId;
    }
}

