/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.network;

import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedChannel;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ONetworkSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ONetworkSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OOperationRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OOperationResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;

public class ODistributedChannelBinaryProtocol
implements ODistributedChannel {
    private String nodeName;
    private ORemoteServerController controller;

    public ODistributedChannelBinaryProtocol(String nodeName, ORemoteServerController remoteServer) {
        this.nodeName = nodeName;
        this.controller = remoteServer;
    }

    @Override
    public void sendRequest(String database, OLogId id, ONodeRequest nodeRequest) {
        this.controller.sendBinaryRequest((OBinaryRequest)new OOperationRequest(this.nodeName, database, id, nodeRequest));
    }

    @Override
    public void sendResponse(String database, OLogId id, ONodeResponse nodeResponse) {
        this.controller.sendBinaryRequest((OBinaryRequest)new OOperationResponse(this.nodeName, database, id, nodeResponse));
    }

    @Override
    public void submit(String database, OSessionOperationId operationId, OSubmitRequest request) {
        this.controller.sendBinaryRequest((OBinaryRequest)new ONetworkSubmitRequest(this.nodeName, database, operationId, request));
    }

    @Override
    public void reply(String database, OSessionOperationId operationId, OSubmitResponse response) {
        this.controller.sendBinaryRequest((OBinaryRequest)new ONetworkSubmitResponse(this.nodeName, database, operationId, response));
    }
}

