/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class OSubmitContextImpl
implements OSubmitContext {
    private Map<OSessionOperationId, CompletableFuture<OSubmitResponse>> operations = new HashMap<OSessionOperationId, CompletableFuture<OSubmitResponse>>();
    private volatile ODistributedMember coordinator;

    @Override
    public synchronized Future<OSubmitResponse> send(OSessionOperationId operationId, OSubmitRequest request) {
        while (this.coordinator == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        CompletableFuture<OSubmitResponse> value = new CompletableFuture<OSubmitResponse>();
        this.operations.put(operationId, value);
        this.coordinator.submit(operationId, request);
        return value;
    }

    @Override
    public synchronized void receive(OSessionOperationId requestId, OSubmitResponse response) {
        CompletableFuture<OSubmitResponse> future = this.operations.remove(requestId);
        future.complete(response);
    }

    @Override
    public ODistributedMember getCoordinator() {
        return this.coordinator;
    }

    @Override
    public synchronized void setCoordinator(ODistributedMember coordinator) {
        this.coordinator = coordinator;
        this.notifyAll();
    }
}

