/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OResponseHandler;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import java.util.Collection;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class ORequestContext {
    private OSubmitRequest submitRequest;
    private ONodeRequest nodeRequest;
    private Collection<ODistributedMember> involvedMembers;
    private Map<ODistributedMember, ONodeResponse> responses = new ConcurrentHashMap<ODistributedMember, ONodeResponse>();
    private ODistributedCoordinator coordinator;
    private int quorum;
    private OResponseHandler handler;
    private TimerTask timerTask;
    private OLogId requestId;

    public ORequestContext(final ODistributedCoordinator coordinator, OSubmitRequest submitRequest, ONodeRequest nodeRequest, Collection<ODistributedMember> involvedMembers, final OResponseHandler handler, OLogId requestId) {
        this.coordinator = coordinator;
        this.submitRequest = submitRequest;
        this.nodeRequest = nodeRequest;
        this.involvedMembers = involvedMembers;
        this.handler = handler;
        this.quorum = involvedMembers.size() / 2 + 1;
        this.requestId = requestId;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                coordinator.executeOperation(() -> {
                    if (handler.timeout(coordinator, ORequestContext.this)) {
                        ORequestContext.this.finish();
                    }
                });
            }
        };
    }

    public void finish() {
        this.coordinator.finish(this.requestId);
    }

    public void receive(ODistributedMember member, ONodeResponse response) {
        this.responses.put(member, response);
        if (this.handler.receive(this.coordinator, this, member, response)) {
            this.finish();
        }
    }

    public Map<ODistributedMember, ONodeResponse> getResponses() {
        return this.responses;
    }

    public int getQuorum() {
        return this.quorum;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public Collection<ODistributedMember> getInvolvedMembers() {
        return this.involvedMembers;
    }

    public static enum Status {
        STARTED,
        QUORUM_OK,
        QUORUM_KO;

    }
}

