/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedChannel;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;

public class ODistributedMember {
    private String name;
    private String database;
    private ODistributedChannel channel;

    public ODistributedMember(String name, String database, ODistributedChannel channel) {
        this.name = name;
        this.database = database;
        this.channel = channel;
    }

    public String getName() {
        return this.name;
    }

    public void sendRequest(OLogId id, ONodeRequest nodeRequest) {
        this.channel.sendRequest(this.database, id, nodeRequest);
    }

    public void reply(OSessionOperationId operationId, OSubmitResponse response) {
        this.channel.reply(this.database, operationId, response);
    }

    public void sendResponse(OLogId opId, ONodeResponse response) {
        this.channel.sendResponse(this.database, opId, response);
    }

    public void submit(OSessionOperationId operationId, OSubmitRequest request) {
        this.channel.submit(this.database, operationId, request);
    }
}

