/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ODistributedExecutor
implements AutoCloseable {
    private OOperationLog operationLog;
    private ExecutorService executor;
    private OrientDBInternal orientDB;
    private final String database;
    private final Map<String, ODistributedMember> members = new ConcurrentHashMap<String, ODistributedMember>();

    public ODistributedExecutor(ExecutorService executor, OOperationLog operationLog, OrientDBInternal orientDB, String database) {
        this.operationLog = operationLog;
        this.executor = executor;
        this.orientDB = orientDB;
        this.database = database;
    }

    public void receive(ODistributedMember member, OLogId opId, ONodeRequest request) {
        this.executor.execute(() -> {
            ONodeResponse response;
            this.operationLog.logReceived(opId, request);
            try (ODatabaseDocumentInternal session = this.orientDB.openNoAuthorization(this.database);){
                response = request.execute(member, opId, this, session);
            }
            member.sendResponse(opId, response);
        });
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void join(ODistributedMember member) {
        this.members.put(member.getName(), member);
    }

    public ODistributedMember getMember(String senderNode) {
        return this.members.get(senderNode);
    }

    public void leave(ODistributedMember member) {
        this.members.remove(member.getName());
    }
}

