/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator;

import com.orientechnologies.orient.server.distributed.impl.coordinator.OClusterPositionAllocator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLog;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ORequestContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OResponseHandler;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ODistributedCoordinator
implements AutoCloseable {
    private final ExecutorService requestExecutor;
    private final OOperationLog operationLog;
    private final ConcurrentMap<OLogId, ORequestContext> contexts = new ConcurrentHashMap<OLogId, ORequestContext>();
    private final Map<String, ODistributedMember> members = new ConcurrentHashMap<String, ODistributedMember>();
    private final Timer timer;
    private final ODistributedLockManager lockManager;
    private final OClusterPositionAllocator allocator;

    public ODistributedCoordinator(ExecutorService requestExecutor, OOperationLog operationLog, ODistributedLockManager lockManager, OClusterPositionAllocator allocator) {
        this.requestExecutor = requestExecutor;
        this.operationLog = operationLog;
        this.timer = new Timer(true);
        this.lockManager = lockManager;
        this.allocator = allocator;
    }

    public void submit(ODistributedMember member, OSessionOperationId operationId, OSubmitRequest request) {
        this.requestExecutor.execute(() -> request.begin(member, operationId, this));
    }

    public void reply(ODistributedMember member, OSessionOperationId operationId, OSubmitResponse response) {
        member.reply(operationId, response);
    }

    public void receive(ODistributedMember member, OLogId relativeRequest, ONodeResponse response) {
        this.requestExecutor.execute(() -> ((ORequestContext)this.contexts.get(relativeRequest)).receive(member, response));
    }

    public OLogId log(ONodeRequest request) {
        return this.operationLog.log(request);
    }

    public ORequestContext sendOperation(OSubmitRequest submitRequest, ONodeRequest nodeRequest, OResponseHandler handler) {
        OLogId id = this.log(nodeRequest);
        ORequestContext context = new ORequestContext(this, submitRequest, nodeRequest, this.members.values(), handler, id);
        this.contexts.put(id, context);
        for (ODistributedMember member : this.members.values()) {
            member.sendRequest(id, nodeRequest);
        }
        this.timer.schedule(context.getTimerTask(), 1000L, 1000L);
        return context;
    }

    public void join(ODistributedMember member) {
        this.members.put(member.getName(), member);
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.requestExecutor.shutdown();
        try {
            this.requestExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void executeOperation(Runnable runnable) {
        this.requestExecutor.execute(runnable);
    }

    protected void finish(OLogId requestId) {
        this.contexts.remove(requestId);
    }

    protected ConcurrentMap<OLogId, ORequestContext> getContexts() {
        return this.contexts;
    }

    public ODistributedLockManager getLockManager() {
        return this.lockManager;
    }

    public OClusterPositionAllocator getAllocator() {
        return this.allocator;
    }

    public ODistributedMember getMember(String senderNode) {
        return this.members.get(senderNode);
    }

    public void leave(ODistributedMember member) {
        this.members.remove(member.getName());
    }
}

