/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.delta.ODocumentDelta;
import com.orientechnologies.orient.core.delta.ODocumentDeltaSerializer;
import com.orientechnologies.orient.core.delta.ODocumentDeltaSerializerI;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyChange;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyOperation;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexOperationRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OTransactionOptimisticDistributed
extends OTransactionOptimistic {
    private final Map<ORID, ORecord> createdRecords = new HashMap<ORID, ORecord>();
    private final Map<ORID, ORecord> updatedRecords = new HashMap<ORID, ORecord>();
    private final Set<ORID> deletedRecord = new HashSet<ORID>();
    private List<ORecordOperation> changes;
    private boolean useDeltas;

    public OTransactionOptimisticDistributed(ODatabaseDocumentInternal database, List<ORecordOperation> changes, boolean useDeltas) {
        super(database);
        this.changes = changes;
        this.useDeltas = useDeltas;
    }

    public void begin(List<ORecordOperationRequest> operations, List<OIndexOperationRequest> indexes) {
        super.begin();
        ArrayList<ORecordOperation> ops = new ArrayList<ORecordOperation>();
        for (ORecordOperationRequest req : operations) {
            byte type = req.getType();
            if (type == 0) continue;
            ORecord record = null;
            switch (type) {
                case 3: {
                    this.addUpdatedRid(req.getOldId(), req.getId());
                    record = ORecordSerializerNetworkV37.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)this.database.getSerializer());
                    this.createdRecords.put(req.getOldId(), record);
                    break;
                }
                case 1: {
                    if (this.useDeltas) {
                        ODocumentDeltaSerializerI serializer = ODocumentDeltaSerializer.getActiveSerializer();
                        ODocumentDelta updateRecord = serializer.fromStream(new BytesContainer(req.getRecord()));
                        ORecordOperation op = new ORecordOperation((OIdentifiable)updateRecord, type);
                        ops.add(op);
                        break;
                    }
                    record = ORecordSerializerNetworkV37.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)this.database.getSerializer());
                    break;
                }
                case 2: {
                    record = this.database.getRecord((OIdentifiable)req.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(req.getRecordType(), req.getId().getClusterId(), this.database);
                }
            }
            if (type != 3 && type != 2 && (type != 1 || this.useDeltas)) continue;
            ORecordInternal.setIdentity((ORecord)record, (ORecordId)((ORecordId)req.getId()));
            ORecordInternal.setVersion((ORecord)record, (int)req.getVersion());
            ORecordOperation op = new ORecordOperation((OIdentifiable)record, type);
            ops.add(op);
        }
        for (ORecordOperation change : ops) {
            this.allEntries.put(change.getRID(), change);
            this.resolveTracking(change, false);
        }
        for (OIndexOperationRequest indexChange : indexes) {
            OIndex index = this.database.getMetadata().getIndexManager().getIndex(indexChange.getIndexName());
            if (indexChange.isCleanIndexValues()) {
                this.addIndexEntry(index, indexChange.getIndexName(), OTransactionIndexChanges.OPERATION.CLEAR, null, null);
            }
            for (OIndexKeyChange key : indexChange.getIndexKeyChanges()) {
                for (OIndexKeyOperation operation : key.getOperations()) {
                    ORID value = operation.getValue();
                    if (!value.isPersistent()) {
                        value = this.getRecordEntry(value).getRID();
                    }
                    if (operation.getType() == 1) {
                        this.addIndexEntry(index, indexChange.getIndexName(), OTransactionIndexChanges.OPERATION.PUT, key.getKey(), (OIdentifiable)value);
                        continue;
                    }
                    this.addIndexEntry(index, indexChange.getIndexName(), OTransactionIndexChanges.OPERATION.REMOVE, key.getKey(), (OIdentifiable)value);
                }
            }
        }
    }

    public void begin() {
        super.begin();
        for (ORecordOperation change : this.changes) {
            this.allEntries.put(change.getRID(), change);
            this.resolveTracking(change, true);
        }
    }

    private void resolveTracking(ORecordOperation change, boolean onlyExecutorCase) {
        ArrayList changes = new ArrayList();
        if (change.getRecordContainer() instanceof ORecord && change.getRecord() instanceof ODocument) {
            ODocument rec = (ODocument)change.getRecord();
            switch (change.getType()) {
                case 3: {
                    ODocument doc = (ODocument)change.getRecord();
                    OLiveQueryHook.addOp((ODocument)doc, (byte)3, (ODatabaseDocument)this.database);
                    OLiveQueryHookV2.addOp((ODocument)doc, (byte)3, (ODatabaseDocument)this.database);
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)doc);
                    if (clazz != null) {
                        if (onlyExecutorCase) {
                            OClassIndexManager.processIndexOnCreate((ODatabaseDocumentInternal)this.database, (ODocument)rec, changes);
                        }
                        if (clazz.isFunction()) {
                            this.database.getSharedContext().getFunctionLibrary().createdFunction(doc);
                            Orient.instance().getScriptManager().close(this.database.getName());
                        }
                        if (clazz.isSequence()) {
                            ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceCreated(this.database, doc);
                        }
                        if (clazz.isScheduler()) {
                            this.database.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(doc));
                        }
                    }
                    if (!onlyExecutorCase) break;
                    this.createdRecords.put(change.getRID().copy(), change.getRecord());
                    break;
                }
                case 1: {
                    ORecord updateRecord = change.getRecord();
                    ODocument original = (ODocument)this.database.load(updateRecord.getIdentity());
                    if (original == null) {
                        throw new ORecordNotFoundException(updateRecord.getIdentity());
                    }
                    original.merge((ODocument)updateRecord, false, false);
                    ODocument updateDoc = original;
                    OLiveQueryHook.addOp((ODocument)updateDoc, (byte)1, (ODatabaseDocument)this.database);
                    OLiveQueryHookV2.addOp((ODocument)updateDoc, (byte)1, (ODatabaseDocument)this.database);
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)updateDoc);
                    if (clazz != null) {
                        if (onlyExecutorCase) {
                            OClassIndexManager.processIndexOnUpdate((ODatabaseDocumentInternal)this.database, (ODocument)updateDoc, changes);
                        }
                        if (clazz.isFunction()) {
                            this.database.getSharedContext().getFunctionLibrary().updatedFunction(updateDoc);
                            Orient.instance().getScriptManager().close(this.database.getName());
                        }
                        if (clazz.isSequence()) {
                            ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceUpdated(this.database, updateDoc);
                        }
                    }
                    this.updatedRecords.put(change.getRID(), change.getRecord());
                    break;
                }
                case 2: {
                    ODocument doc = (ODocument)change.getRecord();
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)doc);
                    if (clazz != null) {
                        if (onlyExecutorCase) {
                            OClassIndexManager.processIndexOnDelete((ODatabaseDocumentInternal)this.database, (ODocument)rec, changes);
                        }
                        if (clazz.isFunction()) {
                            this.database.getSharedContext().getFunctionLibrary().droppedFunction(doc);
                            Orient.instance().getScriptManager().close(this.database.getName());
                        }
                        if (clazz.isSequence()) {
                            ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceDropped(this.database, doc);
                        }
                        if (clazz.isScheduler()) {
                            String eventName = (String)doc.field("name");
                            this.database.getSharedContext().getScheduler().removeEventInternal(eventName);
                        }
                    }
                    OLiveQueryHook.addOp((ODocument)doc, (byte)2, (ODatabaseDocument)this.database);
                    OLiveQueryHookV2.addOp((ODocument)doc, (byte)2, (ODatabaseDocument)this.database);
                    this.deletedRecord.add(change.getRID());
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (change.getRecordContainer() instanceof ODocumentDelta) {
            switch (change.getType()) {
                case 1: {
                    ODocumentDelta deltaRecord = (ODocumentDelta)change.getRecordContainer();
                    ODocument original = (ODocument)this.database.load(deltaRecord.getIdentity());
                    if (original == null) {
                        throw new ORecordNotFoundException(deltaRecord.getIdentity());
                    }
                    ODocument updateDoc = original = original.mergeDelta(deltaRecord);
                    OLiveQueryHook.addOp((ODocument)updateDoc, (byte)1, (ODatabaseDocument)this.database);
                    OLiveQueryHookV2.addOp((ODocument)updateDoc, (byte)1, (ODatabaseDocument)this.database);
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)updateDoc);
                    if (clazz == null) break;
                    if (onlyExecutorCase) {
                        OClassIndexManager.processIndexOnUpdate((ODatabaseDocumentInternal)this.database, (ODocument)updateDoc, changes);
                    }
                    if (clazz.isFunction()) {
                        this.database.getSharedContext().getFunctionLibrary().updatedFunction(updateDoc);
                        Orient.instance().getScriptManager().close(this.database.getName());
                    }
                    if (!clazz.isSequence()) break;
                    ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceUpdated(this.database, updateDoc);
                }
            }
        }
        if (onlyExecutorCase) {
            for (OClassIndexManager.IndexChange indexChange : changes) {
                this.addIndexEntry(indexChange.index, indexChange.index.getName(), indexChange.operation, indexChange.key, indexChange.value);
            }
        }
    }

    public Map<ORID, ORID> getUpdatedRids() {
        return super.getUpdatedRids();
    }

    public Map<ORID, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORID, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    public Set<ORID> getDeletedRecord() {
        return this.deletedRecord;
    }

    public void addUpdatedRid(ORID oldId, ORID id) {
        this.updatedRids.put(oldId, id);
    }

    public boolean isUseDeltas() {
        return this.useDeltas;
    }
}

