/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.impl.OPersistentOperationalLogIterator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OCoordinateMessagesFactory;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLog;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLogEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class OPersistentOperationalLogV1
implements OOperationLog {
    private OCoordinateMessagesFactory factory;
    protected static final long MAGIC = 0x5555555555555555L;
    protected static final String OPLOG_INFO_FILE = "oplog.opl";
    protected static final String OPLOG_FILE = "oplog_$NUM$.opl";
    protected static final int LOG_ENTRIES_PER_FILE = 16384;
    private final String storagePath;
    private OplogInfo info;
    private FileOutputStream fileOutput;
    private DataOutputStream stream;
    private AtomicLong inc;

    public static OPersistentOperationalLogV1 newInstance(String databaseName, OrientDBInternal context) {
        OAbstractPaginatedStorage s = ((OrientDBDistributed)context).getStorage(databaseName);
        OLocalPaginatedStorage storage = (OLocalPaginatedStorage)s.getUnderlying();
        return new OPersistentOperationalLogV1(storage.getStoragePath().toString());
    }

    public OPersistentOperationalLogV1(String storageFolder) {
        this.storagePath = storageFolder;
        this.info = this.readInfo();
        this.stream = this.initStream(this.info);
        this.inc = this.readLastLogId();
    }

    private DataOutputStream initStream(OplogInfo info) {
        String filePath = this.calculateLogFileFullPath(info.currentFileNum);
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fileOutput = new FileOutputStream(file, true);
            return new DataOutputStream(this.fileOutput);
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot create oplog file " + info.currentFileNum + ": " + e.getMessage());
        }
    }

    protected String calculateLogFileFullPath(int fileNum) {
        String fileName = OPLOG_FILE.replace("$NUM$", "" + fileNum);
        String fullPath = this.storagePath + File.separator + fileName;
        return fullPath;
    }

    private OplogInfo readInfo() {
        File infoFile = new File(this.storagePath, OPLOG_INFO_FILE);
        OplogInfo result = new OplogInfo();
        if (infoFile.exists()) {
            this.writeInfo(infoFile, result);
        } else {
            this.initNewInfoFile(infoFile, result);
        }
        return result;
    }

    private void writeInfo(File infoFile, OplogInfo result) {
        try {
            FileOutputStream stream = new FileOutputStream(infoFile);
            result.toStream(stream);
            stream.close();
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot write oplog info:" + e.getMessage());
        }
    }

    private void initNewInfoFile(File infoFile, OplogInfo result) {
        try {
            result.currentFileNum = -1;
            result.firstFileNum = 0;
            result.keepUntil = 0L;
            infoFile.createNewFile();
            FileOutputStream stream = new FileOutputStream(infoFile);
            result.toStream(stream);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot init oplog info:" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AtomicLong readLastLogId() {
        String filePath = this.storagePath + File.separator + OPLOG_FILE.replace("$NUM$", "" + this.info.currentFileNum);
        File f = new File(filePath);
        if (!f.exists()) {
            return new AtomicLong(-1L);
        }
        try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
            if (file.length() == 0L) {
                AtomicLong atomicLong = new AtomicLong(-1L);
                return atomicLong;
            }
            file.seek(file.length() - 16L);
            long size = file.readLong();
            long magic = file.readLong();
            if (magic != 0x5555555555555555L) {
                throw new IllegalStateException();
            }
            file.seek(file.length() - 16L - size - 12L);
            AtomicLong atomicLong = new AtomicLong(file.readLong());
            return atomicLong;
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot open oplog file: " + e.getMessage());
        }
    }

    @Override
    public OLogId log(ONodeRequest request) {
        return new OLogId(this.inc.incrementAndGet());
    }

    @Override
    public void logReceived(OLogId logId, ONodeRequest request) {
        this.write(logId, request);
    }

    private void write(OLogId logId, ONodeRequest request) {
        if (logId.getId() % 16384L == 0L) {
            this.createNewStreamFile();
        }
        this.writeRecord(this.stream, logId, request);
    }

    protected void writeRecord(DataOutputStream stream, OLogId logId, ONodeRequest request) {
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outArray);
        try {
            request.serialize(out);
            byte[] packet = outArray.toByteArray();
            int packetLengthPlusPacket = packet.length + 4;
            stream.writeLong(logId.getId());
            stream.writeInt(packetLengthPlusPacket);
            stream.writeInt(request.getRequestType());
            stream.write(packet);
            stream.writeLong(packetLengthPlusPacket);
            stream.writeLong(0x5555555555555555L);
            stream.flush();
        }
        catch (IOException e) {
            throw new ODistributedException("Cannot write oplog: " + e.getMessage());
        }
    }

    protected OOperationLogEntry readRecord(DataInputStream stream) {
        try {
            long logId = stream.readLong();
            int totalPacketSize = stream.readInt();
            int packetType = stream.readInt();
            ONodeRequest request = this.getCoordinateMessagesFactory().createOperationRequest(packetType);
            request.deserialize(stream);
            stream.readLong();
            long magic = stream.readLong();
            if (magic != 0x5555555555555555L) {
                // empty if block
            }
            return new OOperationLogEntry(new OLogId(logId), request);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected OCoordinateMessagesFactory getCoordinateMessagesFactory() {
        if (this.factory == null) {
            this.factory = new OCoordinateMessagesFactory();
        }
        return this.factory;
    }

    private void createNewStreamFile() {
        ++this.info.currentFileNum;
        File infoFile = new File(this.storagePath, OPLOG_INFO_FILE);
        this.writeInfo(infoFile, this.info);
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.stream = this.initStream(this.info);
    }

    @Override
    public Iterator<OOperationLogEntry> iterate(OLogId from, OLogId to) {
        return new OPersistentOperationalLogIterator(this, from, to);
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class OplogInfo {
        int currentFileNum;
        int firstFileNum;
        long keepUntil;

        private OplogInfo() {
        }

        void fromStream(InputStream stream) {
            try {
                DataInputStream in = new DataInputStream(stream);
                int version = in.readInt();
                if (version != 0) {
                    throw new ODistributedException("Wrong oplog info: version " + version);
                }
                this.currentFileNum = in.readInt();
                this.firstFileNum = in.readInt();
                this.keepUntil = in.readLong();
            }
            catch (IOException e) {
                throw new ODistributedException("Cannot read oplog info: " + e.getMessage());
            }
        }

        void toStream(OutputStream stream) {
            try {
                DataOutputStream out = new DataOutputStream(stream);
                out.writeInt(0);
                out.writeInt(this.currentFileNum);
                out.writeInt(this.firstFileNum);
                out.writeLong(this.keepUntil);
            }
            catch (Exception e) {
                throw new ODistributedException("Cannot write oplog info: " + e.getMessage());
            }
        }
    }
}

