/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.server.distributed.impl.OPersistentOperationalLogV1;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLogEntry;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OPersistentOperationalLogIterator
implements Iterator<OOperationLogEntry> {
    private final OLogId from;
    private final OLogId to;
    private final OPersistentOperationalLogV1 opLog;
    long nextIdToLoad;
    OOperationLogEntry nextEntry;
    private DataInputStream stream;

    public OPersistentOperationalLogIterator(OPersistentOperationalLogV1 opLog, OLogId from, OLogId to) {
        this.opLog = opLog;
        this.from = from;
        this.to = to;
        if (to == null) {
            throw new IllegalArgumentException("'to' value cannot be null");
        }
        this.nextIdToLoad = from == null ? 0L : from.getId();
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.loadNext();
        }
        return this.nextEntry != null;
    }

    @Override
    public OOperationLogEntry next() {
        if (this.nextEntry == null) {
            this.loadNext();
        }
        if (this.nextEntry == null) {
            System.out.println(this.nextIdToLoad);
            throw new NoSuchElementException();
        }
        OOperationLogEntry result = this.nextEntry;
        this.nextEntry = null;
        return result;
    }

    private void loadNext() {
        this.nextEntry = null;
        if (this.nextIdToLoad > this.to.getId()) {
            return;
        }
        if (this.stream == null || this.nextIdToLoad % 16384L == 0L) {
            this.initStream();
        }
        do {
            this.nextEntry = this.opLog.readRecord(this.stream);
        } while (this.nextEntry != null && this.nextEntry.getLogId().getId() < this.from.getId());
        ++this.nextIdToLoad;
    }

    private void initStream() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int fileSuffix = (int)(this.nextIdToLoad / 16384L);
        File file = new File(this.opLog.calculateLogFileFullPath(fileSuffix));
        try {
            this.stream = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Oplog file not found: " + file.getAbsolutePath());
        }
    }
}

