/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.OWriteOperationNotPermittedException;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.task.OBackgroundBackup;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordIfNotLatestTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.impl.task.OScriptTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ODistributedStorage
implements OStorage,
OFreezableStorageComponent,
OAutoshardedStorage {
    private final String name;
    private final OServer serverInstance;
    private final ODistributedServerManager dManager;
    private volatile OAbstractPaginatedStorage wrapped;
    private ODistributedServerManager.DB_STATUS prevStatus;
    private ODistributedDatabase localDistributedDatabase;
    private ODistributedStorageEventListener eventListener;
    private volatile ODistributedConfiguration distributedConfiguration;
    private volatile OBackgroundBackup lastValidBackup = null;

    public ODistributedStorage(OServer iServer, String dbName) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.name = dbName;
    }

    public synchronized void replaceIfNeeded(OAbstractPaginatedStorage wrapped) {
        if (this.wrapped != wrapped) {
            this.wrapped = wrapped;
        }
    }

    public synchronized void wrap(OAbstractPaginatedStorage wrapped) {
        if (this.wrapped != null) {
            return;
        }
        this.wrapped = wrapped;
        this.wrapped.underDistributedStorage();
        this.localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.getName());
        ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Installing distributed storage on database '%s'", (Object[])new Object[]{wrapped.getName()});
        int queueSize = this.getServer().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ASYNCH_QUEUE_SIZE);
    }

    public String getCreatedAtVersion() {
        throw new UnsupportedOperationException("Supported only in embedded storage. Use 'SELECT FROM metadata:storage' instead.");
    }

    public boolean isDistributed() {
        return true;
    }

    public boolean isAssigningClusterIds() {
        return true;
    }

    public Object command(final OCommandRequestText iCommand) {
        OCommandExecutor exec;
        if (this.isLocalEnv()) {
            return this.wrapped.command(iCommand);
        }
        ArrayList<String> servers = (ArrayList<String>)iCommand.getContext().getVariable("servers");
        if (servers == null) {
            servers = new ArrayList<String>();
            iCommand.getContext().setVariable("servers", servers);
        }
        final String localNodeName = this.dManager.getLocalNodeName();
        servers.add(localNodeName);
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        if (!dbCfg.isReplicationActive(null, localNodeName)) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        OCommandExecutor oCommandExecutor = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (!exec.isIdempotent()) {
            this.resetLastValidBackup();
        }
        if (exec.isIdempotent() && !this.dManager.isNodeAvailable(this.dManager.getLocalNodeName(), this.getName())) {
            ODistributedServerLog.warn((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Node '%s' is %s, the command '%s' against database '%s' will be executed only on local server with the possibility to have partial result", (Object[])new Object[]{this.dManager.getLocalNodeName(), this.dManager.getDatabaseStatus(this.dManager.getLocalNodeName(), this.getName()), iCommand, this.wrapped.getName()});
            return this.wrapped.command(iCommand);
        }
        if (!exec.isIdempotent()) {
            this.checkNodeIsMaster(localNodeName, dbCfg, "Command '" + iCommand + "'");
        }
        try {
            Object result = null;
            OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
            OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT resultMgmt = OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
            boolean executeOnLocalNodeFirst = true;
            if (OScenarioThreadLocal.INSTANCE.getRunMode() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
                executionMode = ((OCommandDistributedReplicateRequest)exec).getDistributedExecutionMode();
                resultMgmt = ((OCommandDistributedReplicateRequest)exec).getDistributedResultManagement();
                executeOnLocalNodeFirst = ((OCommandDistributedReplicateRequest)exec).isDistributedExecutingOnLocalNodeFirst();
            }
            switch (executionMode) {
                case LOCAL: {
                    return this.wrapped.command(iCommand);
                }
                case REPLICATE: {
                    final Set involvedClusters = exec.getInvolvedClusters();
                    if (resultMgmt == OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE) {
                        Map<String, Object> results;
                        if (!exec.isIdempotent() && dbCfg.isSharded()) {
                            throw new ODistributedException("Cannot distribute the command '" + iCommand.getText() + "' because it is not idempotent and a map-reduce has been requested");
                        }
                        Map nodeClusterMap = dbCfg.getServerClusterMap((Collection)involvedClusters, localNodeName, exec.isIdempotent());
                        if (exec.isIdempotent() && nodeClusterMap.size() == 1 && ((String)nodeClusterMap.keySet().iterator().next()).equals(localNodeName)) {
                            result = this.wrapped.command(iCommand);
                            results = new HashMap<String, Object>(1);
                            results.put(localNodeName, result);
                        } else {
                            results = this.executeOnServers(iCommand, exec, involvedClusters, nodeClusterMap);
                        }
                        OCommandExecutorSQLSelect select = exec instanceof OCommandExecutorSQLSelect ? (OCommandExecutorSQLSelect)exec : null;
                        result = select != null && select.isAnyFunctionAggregates() && !select.hasGroupBy() ? this.mergeResultByAggregation(select, results) : exec.mergeResults(results);
                        if (!(result instanceof Throwable) || !results.containsKey(localNodeName)) break;
                        this.undoCommandOnLocalServer(iCommand);
                        break;
                    }
                    final OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, new HashSet<String>());
                    task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
                    final Set nodes = dbCfg.getServers((Collection)involvedClusters);
                    if (iCommand instanceof ODistributedCommand) {
                        nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                    }
                    if (this.executeOnlyLocally(localNodeName, dbCfg, exec, involvedClusters, nodes)) {
                        return this.wrapped.command(iCommand);
                    }
                    final boolean executedLocally = executeOnLocalNodeFirst && nodes.contains(localNodeName);
                    result = exec.involveSchema() ? this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            return ODistributedStorage.this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                        }
                    }) : this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                }
            }
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed COMMAND"), (Throwable)((Exception)result));
            }
            return result;
        }
        catch (OConcurrentModificationException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)e.getRid());
            throw e;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    public void acquireDistributedExclusiveLock(long timeout) {
        this.dManager.getLockManagerRequester().acquireExclusiveLock(this.getName(), this.dManager.getLocalNodeName(), timeout);
    }

    public void releaseDistributedExclusiveLock() {
        this.dManager.getLockManagerRequester().releaseExclusiveLock(this.getName(), this.dManager.getLocalNodeName());
    }

    protected Object executeCommand(final OCommandRequestText iCommand, String localNodeName, Collection<String> involvedClusters, OAbstractCommandTask task, Set<String> nodes, boolean executedLocally) {
        Object result;
        Object localResult;
        if (executedLocally) {
            try {
                localResult = OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.command(iCommand);
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw OException.wrapException((OException)new ODistributedException("Cannot execute command " + iCommand), (Throwable)e);
            }
            nodes.remove(localNodeName);
        } else {
            localResult = null;
        }
        if (!nodes.isEmpty()) {
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending command '%s' database '%s'", (Object[])new Object[]{iCommand, this.wrapped.getName()});
            }
            ODistributedResponse dResponse = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null);
            result = dResponse.getPayload();
            if (executedLocally && result instanceof Throwable) {
                this.undoCommandOnLocalServer(iCommand);
            }
        } else {
            result = localResult;
        }
        return result;
    }

    protected void undoCommandOnLocalServer(final OCommandRequestText iCommand) {
        OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

            public Object call() throws Exception {
                OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
                executor.setContext(iCommand.getContext());
                executor.setProgressListener(iCommand.getProgressListener());
                executor.parse((OCommandRequest)iCommand);
                String undoCommand = ((OCommandDistributedReplicateRequest)executor).getUndoCommand();
                if (undoCommand != null) {
                    ODistributedStorage.this.wrapped.command((OCommandRequestText)new OCommandSQL(undoCommand));
                }
                return null;
            }
        });
    }

    protected Map<String, Object> executeOnServers(OCommandRequestText iCommand, OCommandExecutor exec, Collection<String> involvedClusters, Map<String, Collection<String>> nodeClusterMap) {
        HashMap<String, Object> results = new HashMap<String, Object>(nodeClusterMap.size());
        ArrayList<String> nodes = new ArrayList<String>(1);
        for (Map.Entry<String, Collection<String>> c : nodeClusterMap.entrySet()) {
            String nodeName = c.getKey();
            if (!this.dManager.isNodeAvailable(nodeName, this.getName())) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Node '%s' is involved in the command '%s' against database '%s', but the node is not active. Excluding it", (Object[])new Object[]{nodeName, iCommand, this.wrapped.getName()});
                continue;
            }
            OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, c.getValue());
            task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
            nodes.clear();
            nodes.add(nodeName);
            try {
                ODistributedResponse response = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                if (response == null || response.getPayload() instanceof ODistributedOperationException) continue;
                results.put(nodeName, response.getPayload());
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on execution of command '%s' against server '%s', database '%s'", (Object[])new Object[]{iCommand, nodeName, this.wrapped.getName()});
            }
        }
        if (results.isEmpty()) {
            throw new ODistributedException("No active nodes found to execute command: " + iCommand);
        }
        return results;
    }

    protected Object mergeResultByAggregation(OCommandExecutorSQLSelect select, Map<String, Object> iResults) {
        ArrayList<ODocument> list = null;
        ODocument doc = null;
        boolean hasNonAggregates = false;
        Map proj = select.getProjections();
        for (Map.Entry entry : proj.entrySet()) {
            if (entry.getValue() instanceof OSQLFunctionRuntime) continue;
            hasNonAggregates = true;
            break;
        }
        if (hasNonAggregates) {
            for (Map.Entry<Object, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList<ODocument>();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    for (Map.Entry p : proj.entrySet()) {
                        if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                        doc.field((String)p.getKey(), d.field((String)p.getKey()));
                    }
                }
            }
        }
        ArrayList<Object> toMerge = new ArrayList<Object>();
        for (Map.Entry p : proj.entrySet()) {
            if (!(p.getValue() instanceof OSQLFunctionRuntime)) continue;
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)p.getValue();
            toMerge.clear();
            for (Map.Entry<String, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    toMerge.add(d.rawField((String)p.getKey()));
                }
            }
            if (doc == null) continue;
            doc.field((String)p.getKey(), f.getFunction().mergeDistributedResult(toMerge));
        }
        return list;
    }

    protected boolean executeOnlyLocally(String localNodeName, ODistributedConfiguration dbCfg, OCommandExecutor exec, Collection<String> involvedClusters, Collection<String> nodes) {
        boolean executeLocally = false;
        if (exec.isIdempotent()) {
            int maxReadQuorum;
            int availableNodes = nodes.size();
            if (involvedClusters.isEmpty()) {
                maxReadQuorum = dbCfg.getReadQuorum(null, availableNodes, localNodeName);
            } else {
                maxReadQuorum = 0;
                for (String cl : involvedClusters) {
                    maxReadQuorum = Math.max(maxReadQuorum, dbCfg.getReadQuorum(cl, availableNodes, localNodeName));
                }
            }
            if (nodes.contains(localNodeName) && maxReadQuorum <= 1) {
                executeLocally = true;
            }
        }
        return executeLocally;
    }

    public boolean isLocalEnv() {
        return this.localDistributedDatabase == null || this.dManager == null || this.distributedConfiguration == null || OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    public OStorageOperationResult<ORawBuffer> readRecord(final ORecordId iRecordId, final String iFetchPlan, final boolean iIgnoreCache, final boolean prefetchRecords, final ORecordCallback<ORawBuffer> iCallback) {
        if (this.isLocalEnv()) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, prefetchRecords, iCallback);
        }
        ORawBuffer memCopy = this.localDistributedDatabase.getRecordIfLocked((ORID)iRecordId);
        if (memCopy != null) {
            return new OStorageOperationResult((Object)memCopy);
        }
        try {
            Object dResult;
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, prefetchRecords, iCallback);
                    }
                });
            }
            OReadRecordTask task = ((OReadRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(1)).init(iRecordId);
            ODistributedResponse response = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            Object object = dResult = response != null ? response.getPayload() : null;
            if (dResult instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)dResult);
            }
            if (dResult instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed read record"), (Throwable)((Exception)dResult));
            }
            return new OStorageOperationResult((Object)((ORawBuffer)dResult));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(final ORecordId rid, final String fetchPlan, final boolean ignoreCache, final int recordVersion) throws ORecordNotFoundException {
        if (this.isLocalEnv()) {
            return this.wrapped.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
        }
        ORawBuffer memCopy = this.localDistributedDatabase.getRecordIfLocked((ORID)rid);
        if (memCopy != null) {
            return new OStorageOperationResult((Object)memCopy);
        }
        try {
            String clusterName = this.getClusterNameByRID(rid);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
                    }
                });
            }
            OReadRecordIfNotLatestTask task = (OReadRecordIfNotLatestTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(2);
            task.init(rid, recordVersion);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null).getPayload();
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed read record"), (Throwable)((Exception)result));
            }
            return new OStorageOperationResult((Object)((ORawBuffer)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, rid);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRecordId, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
    }

    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.wrapped.getSBtreeCollectionManager();
    }

    public OStorageOperationResult<Integer> recyclePosition(ORecordId iRecordId, byte[] iContent, int iVersion, byte iRecordType) {
        return this.wrapped.recyclePosition(iRecordId, iContent, iVersion, iRecordType);
    }

    public int getConfigurationUpdated() {
        return this.distributedConfiguration.getVersion();
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException();
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public OCluster getClusterByName(String iName) {
        return this.wrapped.getClusterByName(iName);
    }

    public ORecordConflictStrategy getConflictStrategy() {
        return this.getUnderlying().getConflictStrategy();
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getUnderlying().setConflictStrategy(iResolver);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, OContextConfiguration iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(OContextConfiguration iProperties) throws IOException {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.delete();
    }

    public String incrementalBackup(String backupDirectory) {
        return this.wrapped.incrementalBackup(backupDirectory);
    }

    public void restoreFromIncrementalBackup(String filePath) {
        this.wrapped.restoreFromIncrementalBackup(filePath);
    }

    public void close() {
        this.close(false, false);
    }

    public void close(boolean iForce, boolean onDelete) {
        if (this.wrapped == null) {
            return;
        }
        if (onDelete && this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.close(iForce, onDelete);
    }

    public void closeOnDrop() {
        if (this.wrapped == null) {
            return;
        }
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
    }

    public boolean isClosed() {
        if (this.wrapped == null) {
            return true;
        }
        return this.wrapped.isClosed();
    }

    public List<ORecordOperation> commit(OTransactionInternal iTx) {
        return this.wrapped.commit(iTx);
    }

    public void rollback(OTransactionInternal iTx) {
        this.wrapped.rollback(iTx);
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(final String iClusterName, final Object ... iParameters) {
        for (int retry = 0; retry < 10; ++retry) {
            final AtomicInteger clId = new AtomicInteger();
            if (!this.isLocalEnv()) {
                final StringBuilder cmd = new StringBuilder("create cluster `");
                cmd.append(iClusterName);
                cmd.append("`");
                Object result = null;
                try {
                    result = this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            clId.set(ODistributedStorage.this.wrapped.addCluster(iClusterName, iParameters));
                            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                            commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                            return ODistributedStorage.this.command((OCommandRequestText)commandSQL);
                        }
                    });
                }
                catch (Exception e) {
                    this.wrapped.dropCluster(iClusterName, false);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (result != null && ((Integer)result).intValue() != clId.get()) {
                    ODistributedServerLog.warn((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating cluster '%s' on distributed nodes: ids are different (local=%d and remote=%d). Local clusters %s. Retrying %d/%d...", (Object[])new Object[]{iClusterName, clId.get(), (int)((Integer)result), this.getClusterNames(), retry, 10});
                    this.wrapped.dropCluster(clId.get(), false);
                    cmd.setLength(0);
                    cmd.append("drop cluster ");
                    cmd.append(iClusterName);
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(this.getNodeId());
                    this.command((OCommandRequestText)commandSQL);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrapped.reload();
                    continue;
                }
            } else {
                clId.set(this.wrapped.addCluster(iClusterName, iParameters));
            }
            return clId.get();
        }
        throw new ODistributedException("Error on creating cluster '" + iClusterName + "' on distributed nodes: local and remote ids assigned are different");
    }

    public int addCluster(final String iClusterName, final int iRequestedId, final Object ... iParameters) {
        this.resetLastValidBackup();
        for (int retry = 0; retry < 10; ++retry) {
            final AtomicInteger clId = new AtomicInteger();
            if (!this.isLocalEnv()) {
                final StringBuilder cmd = new StringBuilder("create cluster `");
                cmd.append(iClusterName);
                cmd.append("`");
                cmd.append(" ID ");
                cmd.append(iRequestedId);
                Object result = null;
                try {
                    result = this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            clId.set(ODistributedStorage.this.wrapped.addCluster(iClusterName, iRequestedId, iParameters));
                            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                            commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                            return ODistributedStorage.this.command((OCommandRequestText)commandSQL);
                        }
                    });
                }
                catch (Exception e) {
                    this.wrapped.dropCluster(iClusterName, false);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (result != null && ((Integer)result).intValue() != clId.get()) {
                    ODistributedServerLog.warn((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating cluster '%s' on distributed nodes: ids are different (local=%d and remote=%d). Local clusters %s. Retrying %d/%d...", (Object[])new Object[]{iClusterName, clId.get(), (int)((Integer)result), this.getClusterNames(), retry, 10});
                    this.wrapped.dropCluster(clId.get(), false);
                    cmd.setLength(0);
                    cmd.append("drop cluster ");
                    cmd.append(iClusterName);
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(this.getNodeId());
                    this.command((OCommandRequestText)commandSQL);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrapped.reload();
                    continue;
                }
            } else {
                clId.set(this.wrapped.addCluster(iClusterName, iRequestedId, iParameters));
            }
            return clId.get();
        }
        throw new ODistributedException("Error on creating cluster '" + iClusterName + "' on distributed nodes: local and remote ids assigned are different");
    }

    public boolean dropCluster(final String iClusterName, final boolean iTruncate) {
        this.resetLastValidBackup();
        final AtomicBoolean clId = new AtomicBoolean();
        if (!this.isLocalEnv()) {
            final StringBuilder cmd = new StringBuilder();
            if (iTruncate) {
                cmd.append("truncate cluster `");
            } else {
                cmd.append("create cluster `");
            }
            cmd.append(iClusterName);
            cmd.append("`");
            this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                public Object call(OModifiableDistributedConfiguration iArgument) {
                    clId.set(ODistributedStorage.this.wrapped.dropCluster(iClusterName, iTruncate));
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                    return ODistributedStorage.this.command((OCommandRequestText)commandSQL);
                }
            });
            return clId.get();
        }
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        this.resetLastValidBackup();
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public long[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public ODistributedStorageEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ODistributedStorageEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OServer getServer() {
        return this.serverInstance;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.dManager;
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        if (this.distributedConfiguration == null) {
            Map map = this.dManager.getConfigurationMap();
            if (map == null) {
                return null;
            }
            ODocument doc = (ODocument)map.get("database." + this.getName());
            if (doc != null) {
                ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Downloaded configuration for database '%s' from the cluster", (Object[])new Object[]{this.getName()});
                this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
            } else {
                doc = this.loadDatabaseConfiguration(this.getDistributedConfigFile());
                if (doc == null) {
                    doc = this.loadDatabaseConfiguration(this.dManager.getDefaultDatabaseConfigFile());
                    if (doc == null) {
                        throw new OConfigurationException("Cannot load default distributed for database '" + this.getName() + "' config file: " + this.dManager.getDefaultDatabaseConfigFile());
                    }
                    this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
                } else {
                    this.distributedConfiguration = new ODistributedConfiguration(doc);
                }
                this.dManager.updateCachedDatabaseConfiguration(this.getName(), new OModifiableDistributedConfiguration(doc), true);
            }
        }
        return this.distributedConfiguration;
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration distributedConfiguration) {
        if (this.distributedConfiguration == null || distributedConfiguration.getVersion() > this.distributedConfiguration.getVersion()) {
            this.distributedConfiguration = new ODistributedConfiguration(distributedConfiguration.getDocument().copy());
            String cfgOutput = ODistributedOutput.formatClusterTable(this.dManager, this.getName(), (ODistributedConfiguration)distributedConfiguration, this.dManager.getTotalNodes(this.getName()));
            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Setting new distributed configuration for database: %s (version=%d)%s\n", (Object[])new Object[]{this.getName(), distributedConfiguration.getVersion(), cfgOutput});
            this.saveDatabaseConfiguration();
        }
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OStorage getUnderlying() {
        return this.wrapped;
    }

    public boolean isRemote() {
        return false;
    }

    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.wrapped.getComponentsFactory();
    }

    public String getType() {
        return "distributed";
    }

    public void freeze(boolean throwException) {
        String localNode = this.dManager.getLocalNodeName();
        this.prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        this.getFreezableStorage().freeze(throwException);
    }

    public boolean isFrozen() {
        return this.getFreezableStorage().isFrozen();
    }

    public void release() {
        String localNode = this.dManager.getLocalNodeName();
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.ONLINE);
        }
        this.getFreezableStorage().release();
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        String localNode = this.dManager.getLocalNodeName();
        ODistributedServerManager.DB_STATUS prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        try {
            List list = this.wrapped.backup(out, options, callable, iListener, compressionLevel, bufferSize);
            return list;
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIOException("Error on executing backup"), (Throwable)e);
        }
        finally {
            if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
                this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.ONLINE);
            }
        }
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.wrapped.restore(in, options, callable, iListener);
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.getClusterId());
        return cluster != null ? cluster.getName() : "*";
    }

    public String getStorageId() {
        return this.dManager.getLocalNodeName() + "." + this.getName();
    }

    public String getNodeId() {
        return this.dManager != null ? this.dManager.getLocalNodeName() : "?";
    }

    public void shutdown() {
        this.close(true, false);
    }

    protected void checkNodeIsMaster(String localNodeName, ODistributedConfiguration dbCfg, String operation) {
        ODistributedConfiguration.ROLES nodeRole = dbCfg.getServerRole(localNodeName);
        if (nodeRole != ODistributedConfiguration.ROLES.MASTER) {
            throw new OWriteOperationNotPermittedException("Cannot execute write operation (" + operation + ") on node '" + localNodeName + "' because is non a master");
        }
    }

    public OBackgroundBackup getLastValidBackup() {
        return this.lastValidBackup;
    }

    public void setLastValidBackup(OBackgroundBackup lastValidBackup) {
        this.lastValidBackup = lastValidBackup;
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        if (e != null) {
            if (e instanceof OException) {
                throw (OException)e;
            }
            if (e.getCause() instanceof OException) {
                throw (OException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof OException) {
                throw (OException)e.getCause().getCause();
            }
        }
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        throw OException.wrapException((OException)new OStorageException(String.format(iMessage, iParams)), (Throwable)e);
    }

    private OFreezableStorageComponent getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorageComponent) {
            return this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }

    public void resetLastValidBackup() {
        this.lastValidBackup = null;
    }

    protected void dropStorageFiles() {
        ODistributedStorage.dropStorageFiles((OLocalPaginatedStorage)this.wrapped);
    }

    public static void dropStorageFiles(OLocalPaginatedStorage storage) {
        File dCfg = new File(storage.getStoragePath() + "/" + "distributed-config.json");
        try {
            File dCfg2;
            if (dCfg.exists()) {
                for (int i = 0; i < 10 && !dCfg.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
            if ((dCfg2 = new File(storage.getStoragePath() + "/" + "distributed-sync.json")).exists()) {
                for (int i = 0; i < 10 && !dCfg2.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument loadDatabaseConfiguration(File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Loaded configuration for database '%s' from disk: %s", (Object[])new Object[]{this.getName(), file});
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = new ODocument().fromJSON(new String(buffer), "noMap");
            doc.field("version", (Object)1);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on loading distributed configuration file in: %s", (Throwable)e, (Object[])new Object[]{file.getAbsolutePath()});
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected void saveDatabaseConfiguration() {
        FileOutputStream f = null;
        try {
            File file = this.getDistributedConfigFile();
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Saving distributed configuration file for database '%s' to: %s", (Object[])new Object[]{this.getName(), file});
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            f = new FileOutputStream(file);
            f.write(this.distributedConfiguration.getDocument().toJSON().getBytes());
            f.flush();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed configuration file", (Throwable)e, (Object[])new Object[0]);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getDistributedConfigFile() {
        return new File(this.serverInstance.getDatabaseDirectory() + this.getName() + "/" + "distributed-config.json");
    }

    public ODistributedDatabase getLocalDistributedDatabase() {
        return this.localDistributedDatabase;
    }

    public void setSchemaRecordId(String schemaRecordId) {
        this.wrapped.setSchemaRecordId(schemaRecordId);
    }

    public void setDateFormat(String dateFormat) {
        this.wrapped.setDateFormat(dateFormat);
    }

    public void setTimeZone(TimeZone timeZoneValue) {
        this.wrapped.setTimeZone(timeZoneValue);
    }

    public void setLocaleLanguage(String locale) {
        this.wrapped.setLocaleLanguage(locale);
    }

    public void setCharset(String charset) {
        this.wrapped.setCharset(charset);
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.wrapped.setIndexMgrRecordId(indexMgrRecordId);
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.wrapped.setDateTimeFormat(dateTimeFormat);
    }

    public void setLocaleCountry(String localeCountry) {
        this.wrapped.setLocaleCountry(localeCountry);
    }

    public void setClusterSelection(String clusterSelection) {
        this.wrapped.setClusterSelection(clusterSelection);
    }

    public void setMinimumClusters(int minimumClusters) {
        this.wrapped.setMinimumClusters(minimumClusters);
    }

    public void setValidation(boolean validation) {
        this.wrapped.setValidation(validation);
    }

    public void removeProperty(String property) {
        this.wrapped.removeProperty(property);
    }

    public void setProperty(String property, String value) {
        this.wrapped.setProperty(property, value);
    }

    public void setRecordSerializer(String recordSerializer, int version) {
        this.wrapped.setRecordSerializer(recordSerializer, version);
    }

    public void clearProperties() {
        this.wrapped.clearProperties();
    }
}

