/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.ODistributedLockTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ODistributedLockManagerRequester
implements ODistributedLockManager {
    private final ODistributedServerManager manager;
    private volatile String server;
    private Map<String, Long> acquiredResources = new HashMap<String, Long>();
    private static final ThreadLocal<Map<String, OModifiableInteger>> acquired = ThreadLocal.withInitial(() -> new HashMap());

    public ODistributedLockManagerRequester(ODistributedServerManager manager) {
        this.manager = manager;
    }

    public void acquireExclusiveLock(String resource, String nodeSource, long timeout) {
        block12: {
            Object result;
            block13: {
                while (true) {
                    boolean distribException;
                    OModifiableInteger counter;
                    if ((counter = acquired.get().get(resource)) != null) {
                        counter.increment();
                        return;
                    }
                    if (this.server == null || this.server.equals(this.manager.getLocalNodeName())) {
                        this.manager.getLockManagerExecutor().acquireExclusiveLock(resource, this.manager.getLocalNodeName(), timeout);
                        acquired.get().put(resource, new OModifiableInteger(0));
                        break block12;
                    }
                    HashSet<String> servers = new HashSet<String>();
                    servers.add(this.server);
                    ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' is acquiring distributed lock on resource '%s'...", (Object[])new Object[]{nodeSource, resource});
                    try {
                        ODistributedResponse dResponse = this.manager.sendRequest("OSystem", null, servers, (ORemoteTask)new ODistributedLockTask(this.server, resource, timeout, true), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                        if (dResponse == null) {
                            ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' cannot acquire distributed lock on resource '%s' (timeout=%d)...", (Object[])new Object[]{nodeSource, resource, timeout});
                            throw new OLockException("Server '" + nodeSource + "' cannot acquire exclusive lock on resource '" + resource + "' (timeout=" + timeout + ")");
                        }
                        result = dResponse.getPayload();
                    }
                    catch (ODistributedException e) {
                        result = e;
                    }
                    boolean bl = distribException = result instanceof ODistributedOperationException || result instanceof ODistributedException;
                    if (!distribException) break block13;
                    if (this.manager.getActiveServers().contains(this.server)) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            break block12;
                        }
                    }
                    if (this.manager.getActiveServers().contains(this.server)) break;
                    ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Lock Manager server '%s' went down during the request of locking resource '%s'. Waiting for the election of a new Lock Manager...", (Object[])new Object[]{this.server, resource});
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break block12;
                    }
                }
                throw (RuntimeException)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            acquired.get().put(resource, new OModifiableInteger(0));
        }
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' has acquired distributed lock on resource '%s'", (Object[])new Object[]{nodeSource, resource});
        this.acquiredResources.put(resource, System.currentTimeMillis());
    }

    public void releaseExclusiveLock(String resource, String nodeSource) {
        block14: {
            Object result;
            block15: {
                while (true) {
                    boolean distribException;
                    OModifiableInteger counter;
                    if ((counter = acquired.get().get(resource)) == null) {
                        return;
                    }
                    if (counter.getValue() > 0) {
                        counter.decrement();
                        return;
                    }
                    acquired.get().remove(resource);
                    if (this.server == null || this.server.equals(this.manager.getLocalNodeName())) {
                        this.manager.getLockManagerExecutor().releaseExclusiveLock(resource, this.manager.getLocalNodeName());
                        break block14;
                    }
                    ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Releasing distributed lock on resource '%s'", (Object[])new Object[]{resource});
                    HashSet<String> servers = new HashSet<String>();
                    servers.add(this.server);
                    try {
                        ODistributedResponse dResponse = this.manager.sendRequest("OSystem", null, servers, (ORemoteTask)new ODistributedLockTask(this.server, resource, 20000L, false), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                        if (dResponse == null) {
                            throw new OLockException("Cannot release exclusive lock on resource '" + resource + "'");
                        }
                        result = dResponse.getPayload();
                    }
                    catch (ODistributedException e) {
                        result = e;
                    }
                    if (this.manager.getNodeStatus() == ODistributedServerManager.NODE_STATUS.OFFLINE) {
                        throw new ODistributedException("Server is OFFLINE");
                    }
                    boolean bl = distribException = result instanceof ODistributedOperationException || result instanceof ODistributedException;
                    if (!distribException) break block15;
                    if (this.manager.getActiveServers().contains(this.server)) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.manager.getActiveServers().contains(this.server)) break;
                    ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Lock Manager server '%s' went down during the request of releasing resource '%s'. Assigning new Lock Manager (error: %s)...", (Object[])new Object[]{this.server, resource, result});
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.server = this.manager.getLockManagerServer();
                }
                throw (RuntimeException)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
        }
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Released distributed lock on resource '%s'", (Object[])new Object[]{resource});
        this.acquiredResources.remove(resource);
    }

    public void handleUnreachableServer(String nodeLeftName) {
    }

    public void setServer(String server) {
        String lockManagerServer = this.server;
        if (lockManagerServer != null && lockManagerServer.equals(server)) {
            return;
        }
        this.server = server;
        if (!this.acquiredResources.isEmpty()) {
            try {
                for (String resource : this.acquiredResources.keySet()) {
                    this.acquireExclusiveLock(resource, this.manager.getLocalNodeName(), 20000L);
                }
                ODistributedServerLog.info((Object)this, (String)this.manager.getLocalNodeName(), (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Re-acquired %d locks against the new Lock Manager server '%s'", (Object[])new Object[]{this.acquiredResources.size(), server});
            }
            catch (OLockException e) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on re-acquiring %d locks against the new Lock Manager '%s'", (Object[])new Object[]{this.acquiredResources.size(), server});
                throw e;
            }
        }
    }

    public String getServer() {
        return this.server;
    }

    public void shutdown() {
        this.acquiredResources.clear();
    }
}

