/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OSimpleLockManager;
import com.orientechnologies.common.concur.lock.OSimpleLockManagerImpl;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManagerImpl;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedSyncConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.OConflictResolverDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedResponseManagerFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedWorker;
import com.orientechnologies.orient.server.distributed.impl.OSynchronizedTaskWrapper;
import com.orientechnologies.orient.server.distributed.impl.task.ODistributedLockTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUnreachableServerLocalTask;
import com.orientechnologies.orient.server.distributed.impl.task.OWaitForTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ODistributedDatabaseImpl
implements ODistributedDatabase {
    public static final String DISTRIBUTED_SYNC_JSON_FILENAME = "distributed-sync.json";
    private static final HashSet<Integer> ALL_QUEUES = new HashSet();
    protected final ODistributedAbstractPlugin manager;
    protected final ODistributedMessageServiceImpl msgService;
    protected final String databaseName;
    protected ODistributedDatabaseRepairer repairer;
    protected ODistributedSyncConfiguration syncConfiguration;
    protected ConcurrentHashMap<ORID, ODistributedLock> lockManager = new ConcurrentHashMap(256);
    protected ConcurrentHashMap<ODistributedRequestId, ODistributedTxContext> activeTxContexts = new ConcurrentHashMap(64);
    protected final List<ODistributedWorker> workerThreads = new ArrayList<ODistributedWorker>();
    protected ODistributedWorker lockThread;
    protected ODistributedWorker nowaitThread;
    private AtomicLong totalSentRequests = new AtomicLong();
    private AtomicLong totalReceivedRequests = new AtomicLong();
    private TimerTask txTimeoutTask = null;
    private CountDownLatch waitForOnline = new CountDownLatch(1);
    private volatile boolean running = true;
    private AtomicBoolean parsing = new AtomicBoolean(true);
    private final AtomicReference<ODistributedMomentum> filterByMomentum = new AtomicReference();
    private final String localNodeName;
    private final OSimpleLockManager<ORID> recordLockManager;
    private final OSimpleLockManager<Object> indexKeyLockManager;

    public OSimpleLockManager<ORID> getRecordLockManager() {
        return this.recordLockManager;
    }

    public OSimpleLockManager<Object> getIndexKeyLockManager() {
        return this.indexKeyLockManager;
    }

    public ODistributedDatabaseImpl(OHazelcastPlugin manager, ODistributedMessageServiceImpl msgService, String iDatabaseName, ODistributedConfiguration cfg, OServer server) {
        this.manager = manager;
        this.msgService = msgService;
        this.databaseName = iDatabaseName;
        this.localNodeName = manager.getLocalNodeName();
        ODistributedDatabaseImpl prev = msgService.databases.put(iDatabaseName, this);
        if (prev != null) {
            prev.shutdown();
        }
        this.startAcceptingRequests();
        if (iDatabaseName.equals("OSystem")) {
            this.recordLockManager = null;
            this.indexKeyLockManager = null;
            return;
        }
        this.startTxTimeoutTimerTask();
        this.repairer = new OConflictResolverDatabaseRepairer(manager, this.databaseName);
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgSent", "Number of replication messages sent from current node", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalSentRequests.get();
            }
        }, "distributed.db.*.msgSent");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgReceived", "Number of replication messages received from external nodes", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalReceivedRequests.get();
            }
        }, "distributed.db.*.msgReceived");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".activeContexts", "Number of active distributed transactions", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.activeTxContexts.size();
            }
        }, "distributed.db.*.activeContexts");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".workerThreads", "Number of worker threads", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.workerThreads.size();
            }
        }, "distributed.db.*.workerThreads");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".recordLocks", "Number of record locked", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.lockManager.size();
            }
        }, "distributed.db.*.recordLocks");
        long timeout = manager.getServerInstance().getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
        this.recordLockManager = new OSimpleLockManagerImpl(timeout);
        this.indexKeyLockManager = new OSimpleLockManagerImpl(timeout);
    }

    public OLogSequenceNumber getLastLSN(String server) {
        if (server == null) {
            return null;
        }
        return this.getSyncConfiguration().getLastLSN(server);
    }

    public void waitForOnline() {
        try {
            if (!this.databaseName.equalsIgnoreCase("OSystem")) {
                this.waitForOnline.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void reEnqueue(final int senderNodeId, final long msgSequence, final String databaseName, final ORemoteTask payload, int retryCount) {
        Orient.instance().scheduleTask(new TimerTask(){

            @Override
            public void run() {
                ODistributedDatabaseImpl.this.processRequest(new ODistributedRequest(ODistributedDatabaseImpl.this.getManager(), senderNodeId, msgSequence, databaseName, payload), false);
            }
        }, (long)(10 * retryCount), 0L);
    }

    public void processRequest(ODistributedRequest request, boolean waitForAcceptingRequests) {
        if (!this.running) {
            throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
        }
        ORemoteTask task = request.getTask();
        if (waitForAcceptingRequests) {
            this.waitIsReady(task);
            if (!this.running) {
                throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
            }
        }
        this.totalReceivedRequests.incrementAndGet();
        int[] partitionKeys = task.getPartitionKey();
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)task.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' partitionKeys=%s task=%s", (Object[])new Object[]{request, this.databaseName, Arrays.toString(partitionKeys), task});
        }
        if (partitionKeys.length > 1 || partitionKeys[0] == -1) {
            Set<Integer> involvedWorkerQueues = partitionKeys.length > 1 ? this.getInvolvedQueuesByPartitionKeys(partitionKeys) : ALL_QUEUES;
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Request %s on database '%s' involvedQueues=%s", (Object[])new Object[]{request, this.databaseName, involvedWorkerQueues});
            if (involvedWorkerQueues.size() == 1) {
                this.processRequest(involvedWorkerQueues.iterator().next(), request);
            } else {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Request %s on database '%s' waiting for all the previous requests to be completed", (Object[])new Object[]{request, this.databaseName});
                CountDownLatch syncLatch = new CountDownLatch(involvedWorkerQueues.size());
                ODistributedRequest syncRequest = new ODistributedRequest(null, request.getId().getNodeId(), -1L, this.databaseName, (ORemoteTask)new OSynchronizedTaskWrapper(syncLatch));
                for (int queue : involvedWorkerQueues) {
                    ODistributedWorker worker = this.workerThreads.get(queue);
                    worker.processRequest(syncRequest);
                }
                long taskTimeout = 0L;
                try {
                    if (taskTimeout <= 0L) {
                        syncLatch.await();
                    } else {
                        long start = System.currentTimeMillis();
                        long cycleTimeout = Math.min(taskTimeout, 2000L);
                        boolean locked = false;
                        do {
                            if (!syncLatch.await(cycleTimeout, TimeUnit.MILLISECONDS)) continue;
                            locked = true;
                            break;
                        } while (this.workerThreads.size() != 0 && System.currentTimeMillis() - start < taskTimeout);
                        if (!locked) {
                            String msg = String.format("Cannot execute distributed request (%s) because all worker threads (%d) are busy (pending=%d timeout=%d)", request, this.workerThreads.size(), syncLatch.getCount(), taskTimeout);
                            ODistributedWorker.sendResponseBack(this, this.manager, request, new ODistributedOperationException(msg));
                            return;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    String msg = String.format("Cannot execute distributed request (%s) because all worker threads (%d) are busy", request, this.workerThreads.size());
                    ODistributedWorker.sendResponseBack(this, this.manager, request, new ODistributedOperationException(msg));
                    return;
                }
                CountDownLatch queueLatch = new CountDownLatch(1);
                int i = 0;
                for (int queue : involvedWorkerQueues) {
                    ODistributedRequest req;
                    if (i++ == 0) {
                        String senderNodeName = this.manager.getNodeNameById(request.getId().getNodeId());
                        request.setTask((ORemoteTask)new OSynchronizedTaskWrapper(queueLatch, senderNodeName, task));
                        req = request;
                    } else {
                        req = new ODistributedRequest((ODistributedServerManager)this.manager, request.getId().getNodeId(), -1L, this.databaseName, (ORemoteTask)new OWaitForTask(queueLatch));
                    }
                    this.workerThreads.get(queue).processRequest(req);
                }
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -2) {
            boolean found = false;
            for (ODistributedWorker q : this.workerThreads) {
                if (!q.isWaitingForNextRequest() || !q.localQueue.isEmpty()) continue;
                q.processRequest(request);
                found = true;
                break;
            }
            if (!found) {
                for (ODistributedWorker q : this.workerThreads) {
                    if (!q.localQueue.isEmpty()) continue;
                    q.processRequest(request);
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.workerThreads.get(0).processRequest(request);
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -3) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the lock worker", (Object[])new Object[]{request, this.databaseName});
            this.lockThread.processRequest(request);
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -4) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the nowait worker", (Object[])new Object[]{request, this.databaseName});
            this.nowaitThread.processRequest(request);
        } else {
            this.processRequest(partitionKeys[0], request);
        }
    }

    public void waitIsReady(ORemoteTask task) {
        if (task.isNodeOnlineRequired() && !this.parsing.get()) {
            while (!this.parsing.get()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected Set<Integer> getInvolvedQueuesByPartitionKeys(int[] partitionKeys) {
        HashSet<Integer> involvedWorkerQueues = new HashSet<Integer>(partitionKeys.length);
        for (int pk : partitionKeys) {
            if (pk < 0) continue;
            involvedWorkerQueues.add(pk % this.workerThreads.size());
        }
        return involvedWorkerQueues;
    }

    protected void processRequest(int partitionKey, ODistributedRequest request) {
        if (this.workerThreads.isEmpty()) {
            throw new ODistributedException("There are no worker threads to process request " + request);
        }
        int partition = partitionKey % this.workerThreads.size();
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the worker %d", (Object[])new Object[]{request, this.databaseName, partition});
        this.workerThreads.get(partition).processRequest(request);
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback) {
        return this.send2Nodes(iRequest, iClusterNames, iNodes, iExecutionMode, localResult, iAfterSentCallback, endCallback, (iRequest1, iNodes1, endCallback1, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> new ODistributedResponseManagerImpl((ODistributedServerManager)this.manager, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses), iRequest.getId()), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes), iRequest.getId()), groupByResponse, endCallback));
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback, ODistributedResponseManagerFactory responseManagerFactory) {
        boolean afterSendCallBackCalled = false;
        try {
            ODistributedResponse oDistributedResponse;
            this.checkForServerOnline(iRequest);
            String databaseName = iRequest.getDatabaseName();
            if (iNodes.isEmpty()) {
                ODistributedServerLog.error((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for database '%s' request: %s", (Object[])new Object[]{databaseName, iRequest});
                throw new ODistributedException("No nodes configured for partition '" + databaseName + "' request: " + iRequest);
            }
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(databaseName);
            ORemoteTask task = iRequest.getTask();
            boolean checkNodesAreOnline = task.isNodeOnlineRequired();
            Set nodesConcurToTheQuorum = this.manager.getDistributedStrategy().getNodesConcurInQuorum((ODistributedServerManager)this.manager, cfg, iRequest, iNodes, databaseName, localResult);
            int availableNodes = checkNodesAreOnline ? this.manager.getNodesWithStatus(iNodes, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP, ODistributedServerManager.DB_STATUS.SYNCHRONIZING) : iNodes.size();
            int expectedResponses = localResult != null ? availableNodes + 1 : availableNodes;
            int quorum = this.calculateQuorum(task.getQuorumType(), iClusterNames, cfg, expectedResponses, nodesConcurToTheQuorum.size(), checkNodesAreOnline, this.localNodeName);
            boolean groupByResponse = task.getResultStrategy() != ORemoteTask.RESULT_STRATEGY.UNION;
            boolean waitLocalNode = this.waitForLocalNode(cfg, iClusterNames, iNodes);
            ODistributedResponseManager currentResponseMgr = responseManagerFactory.newResponseManager(iRequest, iNodes, endCallback, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode);
            if (localResult != null && currentResponseMgr.setLocalResult(this.localNodeName, localResult)) {
                ODistributedResponse oDistributedResponse2 = currentResponseMgr.getFinalResponse();
                return oDistributedResponse2;
            }
            if (!(iNodes instanceof List)) {
                iNodes = new ArrayList<String>(iNodes);
            }
            if (iNodes.size() > 1) {
                Collections.sort((List)iNodes);
            }
            this.msgService.registerRequest(iRequest.getId().getMessageId(), currentResponseMgr);
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending request %s...", (Object[])new Object[]{iRequest});
            }
            for (String node : iNodes) {
                try {
                    ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                    remoteServer.sendRequest(iRequest);
                }
                catch (Exception e) {
                    currentResponseMgr.removeServerBecauseUnreachable(node);
                    String reason = e.getMessage();
                    if (e instanceof ODistributedException && e.getCause() instanceof IOException) {
                        reason = e.getCause().getMessage();
                        this.manager.closeRemoteServer(node);
                    } else if (e instanceof OSecurityAccessException) {
                        this.manager.closeRemoteServer(node);
                        try {
                            ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                            remoteServer.sendRequest(iRequest);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.manager.isNodeAvailable(node)) {
                        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s. The target node is not available. Active nodes: %s", (Throwable)e, (Object[])new Object[]{iRequest, this.manager.getAvailableNodeNames(databaseName)});
                        continue;
                    }
                    ODistributedServerLog.error((Object)this, (String)this.localNodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s (err=%s). Active nodes: %s", (Object[])new Object[]{iRequest, reason, this.manager.getAvailableNodeNames(databaseName)});
                }
            }
            if (currentResponseMgr.getExpectedNodes().isEmpty()) {
                throw new ODistributedException("No server active for distributed request (" + iRequest + ") against database '" + databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes);
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sent request %s", (Object[])new Object[]{iRequest});
            }
            this.totalSentRequests.incrementAndGet();
            afterSendCallBackCalled = true;
            if (iAfterSentCallback != null) {
                iAfterSentCallback.call((Object)iRequest.getId());
            }
            if (iExecutionMode == ODistributedRequest.EXECUTION_MODE.RESPONSE) {
                oDistributedResponse = this.waitForResponse(iRequest, currentResponseMgr);
                return oDistributedResponse;
            }
            oDistributedResponse = null;
            return oDistributedResponse;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODistributedException("Error on executing distributed request (" + iRequest + ") against database '" + this.databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes), (Throwable)e);
        }
        finally {
            if (iAfterSentCallback != null && !afterSendCallBackCalled) {
                iAfterSentCallback.call((Object)iRequest.getId());
            }
        }
    }

    public ODistributedResponseManager newResponseManager(ODistributedRequest iRequest, Collection<String> iNodes, OCallable<Void, ODistributedResponseManager> endCallback, ORemoteTask task, Set<String> nodesConcurToTheQuorum, int availableNodes, int expectedResponses, int quorum, boolean groupByResponse, boolean waitLocalNode) {
        return new ODistributedResponseManagerImpl((ODistributedServerManager)this.manager, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses), iRequest.getId()), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes), iRequest.getId()), groupByResponse, endCallback);
    }

    private long adjustTimeoutWithLatency(Collection<String> iNodes, long timeout, ODistributedRequestId requestId) {
        long delta = 0L;
        if (iNodes != null) {
            for (String n : iNodes) {
                long l = this.msgService.getCurrentLatency(n);
                delta = Math.max(delta, l);
            }
        }
        if (delta > 500L) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Adjusted timeouts by adding +%dms because this is the maximum latency recorded against servers %s (reqId=%s)", (Object[])new Object[]{delta, iNodes, requestId});
        }
        return timeout + delta;
    }

    public void setOnline() {
        ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Publishing ONLINE status for database %s.%s...", (Object[])new Object[]{this.localNodeName, this.databaseName});
        this.manager.setDatabaseStatus(this.localNodeName, this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        this.waitForOnline.countDown();
    }

    public ORawBuffer getRecordIfLocked(ORID rid) {
        ODistributedLock currentLock = this.lockManager.get(rid);
        if (currentLock != null) {
            return currentLock.record;
        }
        return null;
    }

    public void replaceRecordContentIfLocked(ORID rid, byte[] bytes) {
        ODistributedLock currentLock = this.lockManager.get(rid);
        if (currentLock != null && currentLock.record != null) {
            currentLock.record.buffer = bytes;
        }
    }

    public boolean lockRecord(ORID rid, ODistributedRequestId requestId, long timeout) {
        ODistributedLock lock = new ODistributedLock(requestId);
        ORawBuffer currentRecord = null;
        boolean newLock = true;
        ODistributedLock currentLock = this.lockManager.putIfAbsent(rid, lock);
        if (currentLock != null) {
            currentRecord = currentLock.record;
            if (requestId.equals((Object)currentLock.reqId)) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s locked record %s in database '%s' owned by %s (thread=%d)", (Object[])new Object[]{requestId, rid, this.databaseName, currentLock.reqId, Thread.currentThread().getId()});
                currentLock = null;
                newLock = false;
            } else {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        if (timeout > 0L) {
                            if (!currentLock.lock.await(timeout, TimeUnit.MILLISECONDS)) {
                                continue;
                            }
                        } else {
                            currentLock.lock.await();
                        }
                        currentLock = this.lockManager.putIfAbsent(rid, lock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (currentLock != null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout));
            }
        }
        if (currentLock == null) {
            ODatabaseDocumentInternal db;
            if (currentRecord != null) {
                lock.record = currentRecord;
            } else if (rid.isPersistent() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                lock.record = (ORawBuffer)db.getStorage().getUnderlying().readRecord((ORecordId)rid, null, false, false, null).getResult();
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Locked record %s in database '%s' (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, requestId, Thread.currentThread().getId()});
            }
        } else if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot lock record %s in database '%s' owned by %s (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, currentLock.reqId, requestId, Thread.currentThread().getId()});
        }
        if (currentLock != null) {
            throw new ODistributedRecordLockedException(this.manager.getLocalNodeName(), rid, currentLock.reqId, timeout);
        }
        return newLock;
    }

    public void unlockRecord(OIdentifiable iRecord, ODistributedRequestId requestId) {
        if (requestId == null) {
            return;
        }
        ODistributedLock owner = this.lockManager.get(iRecord.getIdentity());
        if (owner != null) {
            if (!owner.reqId.equals((Object)requestId)) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: cannot unlock record %s in database '%s' because owner %s <> current %s (thread=%d)", (Object[])new Object[]{iRecord, this.databaseName, owner.reqId, requestId, Thread.currentThread().getId()});
                return;
            }
            this.lockManager.remove(iRecord.getIdentity());
            owner.lock.countDown();
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s unlocked record %s in database '%s' (owner=%s, thread=%d)", (Object[])new Object[]{requestId, iRecord, this.databaseName, owner != null ? owner.reqId : "null", Thread.currentThread().getId()});
        }
    }

    public boolean forceLockRecord(ORID rid, ODistributedRequestId requestId) {
        ODistributedLock lock = new ODistributedLock(requestId);
        ORawBuffer currentRecord = null;
        boolean newLock = true;
        ODistributedLock currentLock = this.lockManager.put(rid, lock);
        if (currentLock != null) {
            currentRecord = currentLock.record;
            if (requestId.equals((Object)currentLock.reqId)) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rid %s was already locked by %s in database '%s' owned by %s (thread=%d)", (Object[])new Object[]{rid, requestId, this.databaseName, currentLock.reqId, Thread.currentThread().getId()});
                currentLock = null;
                newLock = false;
            } else {
                if (currentLock.reqId.getNodeId() == requestId.getNodeId()) {
                    return this.lockRecord(rid, requestId, 0L);
                }
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Canceling request %s in database '%s' (reqId=%s thread=%d)", (Object[])new Object[]{currentLock.reqId, this.databaseName, requestId, Thread.currentThread().getId()});
                currentLock.lock.countDown();
                ODistributedTxContext lockedCtx = this.activeTxContexts.get(currentLock.reqId);
                if (lockedCtx != null) {
                    lockedCtx.cancel((ODistributedServerManager)this.manager, ODatabaseRecordThreadLocal.instance().get());
                } else {
                    ODistributedResponseManager respMgr = this.manager.getMessageService().getResponseManager(requestId);
                    if (respMgr != null) {
                        respMgr.cancel();
                    }
                }
            }
        }
        if (currentLock == null) {
            ODatabaseDocumentInternal db;
            if (currentRecord != null) {
                lock.record = currentRecord;
            } else if (rid.isPersistent() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                lock.record = (ORawBuffer)db.getStorage().getUnderlying().readRecord((ORecordId)rid, null, false, false, null).getResult();
            }
            if (newLock && ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Locked rid %s in database '%s' (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, requestId, Thread.currentThread().getId()});
            }
        } else if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Forced locking of rid %s in database '%s' owned by %s (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, currentLock.reqId, requestId, Thread.currentThread().getId()});
        }
        return newLock;
    }

    public void unlockResourcesOfServer(ODatabaseDocumentInternal database, String serverName) {
        int nodeLeftId = this.manager.getNodeIdByName(serverName);
        HashSet rids2Repair = new HashSet();
        int rollbacks = 0;
        Iterator<ODistributedTxContext> pendingReqIterator = this.activeTxContexts.values().iterator();
        while (pendingReqIterator.hasNext()) {
            ODistributedTxContext pReq = pendingReqIterator.next();
            if (pReq == null || pReq.getReqId().getNodeId() != nodeLeftId) continue;
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            try {
                rids2Repair.addAll(pReq.rollback(database));
                ++rollbacks;
            }
            catch (Exception t) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: error on rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            }
            pReq.destroy();
            pendingReqIterator.remove();
        }
        int recordLocks = 0;
        for (Map.Entry<ORID, ODistributedLock> entry : this.lockManager.entrySet()) {
            ODistributedLock lock = entry.getValue();
            if (lock == null || lock.reqId == null || lock.reqId.getNodeId() != nodeLeftId) continue;
            OLogManager.instance().debug((Object)this, "Unlocking record %s acquired with req=%s", new Object[]{entry.getKey(), lock.reqId});
            ++recordLocks;
        }
        ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rolled back %d transactions and %d single locks in database '%s' owned by server '%s'", (Object[])new Object[]{rollbacks, recordLocks, this.databaseName, serverName});
        this.getDatabaseRepairer().enqueueRepairRecords(rids2Repair);
    }

    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId) {
        return this.registerTxContext(reqId, new ODistributedTxContextImpl(this, reqId));
    }

    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId, ODistributedTxContext ctx) {
        ODistributedTxContext prevCtx = this.activeTxContexts.putIfAbsent(reqId, ctx);
        if (prevCtx != null) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: repeating request %s in database '%s' (thread=%d)", (Object[])new Object[]{reqId, this.databaseName, Thread.currentThread().getId()});
            ctx = prevCtx;
        } else {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: registered request %s in database '%s' (thread=%d)", (Object[])new Object[]{reqId, this.databaseName, Thread.currentThread().getId()});
        }
        return ctx;
    }

    public ODistributedTxContext popTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = this.activeTxContexts.remove(requestId);
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: pop request %s for database %s -> %s", (Object[])new Object[]{requestId, this.databaseName, ctx});
        return ctx;
    }

    public ODistributedTxContext getTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = this.activeTxContexts.get(requestId);
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: pop request %s for database %s -> %s", (Object[])new Object[]{requestId, this.databaseName, ctx});
        return ctx;
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public boolean exists() {
        return this.manager.getServerInstance().existsDatabase(this.databaseName);
    }

    public ODistributedSyncConfiguration getSyncConfiguration() {
        if (this.syncConfiguration == null) {
            String path = this.manager.getServerInstance().getDatabaseDirectory() + this.databaseName + "/" + DISTRIBUTED_SYNC_JSON_FILENAME;
            File cfgFile = new File(path);
            try {
                this.syncConfiguration = new ODistributedSyncConfiguration((ODistributedServerManager)this.manager, this.databaseName, cfgFile);
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new ODistributedException("Cannot open database distributed sync configuration file: " + cfgFile), (Throwable)e);
            }
        }
        return this.syncConfiguration;
    }

    public void filterBeforeThisMomentum(ODistributedMomentum momentum) {
        this.filterByMomentum.set(momentum);
    }

    public void handleUnreachableNode(String nodeName) {
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction: rolling back all the pending transactions coordinated by the unreachable server '%s'", (Object[])new Object[]{nodeName});
        OUnreachableServerLocalTask task = new OUnreachableServerLocalTask(nodeName);
        ODistributedRequest rollbackRequest = new ODistributedRequest(null, this.manager.getLocalNodeId(), this.manager.getNextMessageIdCounter(), null, (ORemoteTask)task);
        this.processRequest(rollbackRequest, false);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ODatabaseDocumentInternal getDatabaseInstance() {
        return this.manager.getServerInstance().openDatabase(this.databaseName, "internal", "internal", null, true);
    }

    public long getReceivedRequests() {
        return this.totalReceivedRequests.get();
    }

    public long getProcessedRequests() {
        long total = 0L;
        if (this.lockThread != null) {
            total += this.lockThread.getProcessedRequests();
        }
        if (this.nowaitThread != null) {
            total += this.nowaitThread.getProcessedRequests();
        }
        for (ODistributedWorker workerThread : this.workerThreads) {
            if (workerThread == null) continue;
            total += workerThread.getProcessedRequests();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            if (this.txTimeoutTask != null) {
                this.txTimeoutTask.cancel();
            }
            if (this.repairer != null) {
                this.repairer.shutdown();
            }
            if (this.lockThread != null) {
                this.lockThread.sendShutdown();
            }
            if (this.nowaitThread != null) {
                this.nowaitThread.sendShutdown();
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                workerThread.sendShutdown();
            }
            if (this.lockThread != null) {
                try {
                    this.lockThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.nowaitThread != null) {
                try {
                    this.nowaitThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                try {
                    workerThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lockThread = null;
            this.nowaitThread = null;
            this.workerThreads.clear();
            try {
                this.getSyncConfiguration().save();
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed LSN table for database '%s'", (Object[])new Object[]{this.databaseName});
            }
            this.syncConfiguration = null;
            ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Shutting down distributed database manager '%s'. Pending objects: txs=%d locks=%d", (Object[])new Object[]{this.databaseName, this.activeTxContexts.size(), this.lockManager.size()});
            this.lockManager.clear();
            this.activeTxContexts.clear();
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgSent");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgReceived");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".activeContexts");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".workerThreads");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".recordLocks");
        }
        finally {
            ODistributedServerManager.DB_STATUS serverStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName);
            if (serverStatus == ODistributedServerManager.DB_STATUS.ONLINE || serverStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING) {
                try {
                    this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void checkForServerOnline(ODistributedRequest iRequest) throws ODistributedException {
        ODistributedServerManager.NODE_STATUS srvStatus = this.manager.getNodeStatus();
        if (srvStatus == ODistributedServerManager.NODE_STATUS.OFFLINE || srvStatus == ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN) {
            ODistributedServerLog.error((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Local server is not online (status='%s'). Request %s will be ignored", (Object[])new Object[]{srvStatus, iRequest});
            throw new OOfflineNodeException("Local server is not online (status='" + srvStatus + "'). Request " + iRequest + " will be ignored");
        }
    }

    protected boolean waitForLocalNode(ODistributedConfiguration cfg, Collection<String> iClusterNames, Collection<String> iNodes) {
        boolean waitLocalNode;
        block1: {
            block2: {
                waitLocalNode = false;
                if (!iNodes.contains(this.localNodeName)) break block1;
                if (iClusterNames != null && !iClusterNames.isEmpty()) break block2;
                if (!cfg.isReadYourWrites(null).booleanValue()) break block1;
                waitLocalNode = true;
                break block1;
            }
            for (String clName : iClusterNames) {
                if (!cfg.isReadYourWrites(clName).booleanValue()) continue;
                waitLocalNode = true;
                break;
            }
        }
        return waitLocalNode;
    }

    protected int calculateQuorum(OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType, Collection<String> clusterNames, ODistributedConfiguration cfg, int totalServers, int totalMasterServers, boolean checkNodesAreOnline, String localNodeName) {
        int quorum = 1;
        if (clusterNames == null || clusterNames.isEmpty()) {
            clusterNames = new ArrayList<String>(1);
            clusterNames.add(null);
        }
        int totalServerInQuorum = totalServers;
        for (String cluster : clusterNames) {
            int clusterQuorum = 0;
            switch (quorumType) {
                case NONE: {
                    break;
                }
                case READ: {
                    clusterQuorum = cfg.getReadQuorum(cluster, totalServers, localNodeName);
                    break;
                }
                case WRITE: {
                    clusterQuorum = cfg.getWriteQuorum(cluster, totalMasterServers, localNodeName);
                    totalServerInQuorum = totalMasterServers;
                    break;
                }
                case ALL: {
                    clusterQuorum = totalServers;
                }
            }
            quorum = Math.max(quorum, clusterQuorum);
        }
        if (quorum < 0) {
            quorum = 0;
        }
        if (checkNodesAreOnline && quorum > totalServerInQuorum) {
            throw new ODistributedException("Quorum (" + quorum + ") cannot be reached on server '" + localNodeName + "' database '" + this.databaseName + "' because it is major than available nodes (" + totalServerInQuorum + ")");
        }
        return quorum;
    }

    protected ODistributedResponse waitForResponse(ODistributedRequest iRequest, ODistributedResponseManager currentResponseMgr) throws InterruptedException {
        long elapsed;
        long beginTime = System.currentTimeMillis();
        if (!currentResponseMgr.waitForSynchronousResponses() && (elapsed = System.currentTimeMillis() - beginTime) > currentResponseMgr.getSynchTimeout()) {
            ODistributedServerLog.warn((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Timeout (%dms) on waiting for synchronous responses from nodes=%s responsesSoFar=%s request=(%s)", (Object[])new Object[]{elapsed, currentResponseMgr.getExpectedNodes(), currentResponseMgr.getRespondingNodes(), iRequest});
        }
        return currentResponseMgr.getFinalResponse();
    }

    public void checkNodeInConfiguration(ODistributedConfiguration cfg, final String serverName) {
        this.manager.executeInDistributedDatabaseLock(this.databaseName, 20000L, cfg != null ? cfg.modify() : null, new OCallable<Void, OModifiableDistributedConfiguration>(){

            public Void call(OModifiableDistributedConfiguration lastCfg) {
                List foundPartition = lastCfg.addNewNodeInServerList(serverName);
                if (foundPartition != null) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Adding node '%s' in partition: %s db=%s v=%d", (Object[])new Object[]{serverName, foundPartition, ODistributedDatabaseImpl.this.databaseName, lastCfg.getVersion()});
                }
                return null;
            }
        });
    }

    protected String getLocalNodeName() {
        return this.localNodeName;
    }

    private void startAcceptingRequests() {
        int totalWorkers = OGlobalConfiguration.DISTRIBUTED_DB_WORKERTHREADS.getValueAsInteger();
        if (totalWorkers < 0) {
            throw new ODistributedException("Cannot create configured distributed workers (" + totalWorkers + ")");
        }
        if (totalWorkers == 0) {
            int totalDatabases = this.manager.getManagedDatabases().size() + 1;
            int cpus = Runtime.getRuntime().availableProcessors();
            if (cpus > 1) {
                totalWorkers = cpus / totalDatabases;
            }
            if (totalWorkers == 0) {
                totalWorkers = 1;
            }
        }
        this.lockThread = new ODistributedWorker(this, this.databaseName, -3, false){

            @Override
            protected void handleError(ODistributedRequest iRequest, Object responsePayload) {
                ODistributedLockTask task = (ODistributedLockTask)iRequest.getTask();
                task.undo(this.manager);
            }
        };
        this.lockThread.start();
        this.nowaitThread = new ODistributedWorker(this, this.databaseName, -4, true);
        this.nowaitThread.start();
        for (int i = 0; i < totalWorkers; ++i) {
            ODistributedWorker workerThread = new ODistributedWorker(this, this.databaseName, i, true);
            this.workerThreads.add(workerThread);
            workerThread.start();
            ALL_QUEUES.add(i);
        }
    }

    public void setLSN(String sourceNodeName, OLogSequenceNumber taskLastLSN, boolean updateLastOperationTimestamp) throws IOException {
        if (taskLastLSN == null) {
            return;
        }
        ODistributedSyncConfiguration cfg = this.getSyncConfiguration();
        cfg.setLastLSN(sourceNodeName, taskLastLSN, updateLastOperationTimestamp);
    }

    public ODistributedDatabaseRepairer getDatabaseRepairer() {
        return this.repairer;
    }

    private void startTxTimeoutTimerTask() {
        this.txTimeoutTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ODatabaseDocumentInternal database = null;
                try {
                    long now = System.currentTimeMillis();
                    long timeout = OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong();
                    HashSet rids2Repair = new HashSet();
                    Iterator<Object> it = ODistributedDatabaseImpl.this.activeTxContexts.values().iterator();
                    while (it.hasNext() && ODistributedDatabaseImpl.this.isRunning()) {
                        long started;
                        long elapsed;
                        ODistributedTxContext ctx = it.next();
                        if (ctx == null || (elapsed = now - (started = ctx.getStartedOn())) <= timeout) continue;
                        if (database == null) {
                            database = ODistributedDatabaseImpl.this.getDatabaseInstance();
                        }
                        ODistributedServerLog.debug((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s on database '%s' is expired after %dms", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, elapsed});
                        if (database != null) {
                            database.activateOnCurrentThread();
                        }
                        try {
                            rids2Repair.addAll(ctx.cancel((ODistributedServerManager)ODistributedDatabaseImpl.this.manager, database));
                            if (ctx.getReqId().getNodeId() != ODistributedDatabaseImpl.this.manager.getLocalNodeId()) continue;
                            ODistributedDatabaseImpl.this.msgService.timeoutRequest(ctx.getReqId().getMessageId());
                        }
                        catch (Exception t) {
                            ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on rolling back distributed transaction %s on database '%s' (err=%s)", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, t});
                        }
                        finally {
                            it.remove();
                        }
                    }
                    it = ODistributedDatabaseImpl.this.lockManager.entrySet().iterator();
                    while (it.hasNext()) {
                        long elapsed;
                        Map.Entry entry = (Map.Entry)it.next();
                        ODistributedLock lock = (ODistributedLock)entry.getValue();
                        if (lock == null || (elapsed = now - lock.acquiredOn) <= timeout) continue;
                        ODistributedServerLog.debug((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed lock on database '%s' record %s is expired after %dms", (Object[])new Object[]{ODistributedDatabaseImpl.this.databaseName, entry.getKey(), elapsed});
                        it.remove();
                    }
                    ODistributedDatabaseImpl.this.getDatabaseRepairer().enqueueRepairRecords(rids2Repair);
                }
                catch (Exception t) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on checking for expired distributed transaction on database '%s'", (Object[])new Object[]{ODistributedDatabaseImpl.this.databaseName});
                }
                finally {
                    if (database != null) {
                        database.activateOnCurrentThread();
                        database.close();
                    }
                }
            }
        };
    }

    private boolean isRunning() {
        return this.running;
    }

    public void suspend() {
        if (this.parsing.get()) {
            if (this.lockThread != null) {
                this.lockThread.reset();
            }
            if (this.nowaitThread != null) {
                this.nowaitThread.reset();
            }
            for (ODistributedWorker w : this.workerThreads) {
                if (w == null) continue;
                w.reset();
            }
        }
        this.parsing.set(false);
    }

    public void resume() {
        this.parsing.set(true);
    }

    public String dump() {
        int i;
        ArrayBlockingQueue<ODistributedRequest> queue;
        ODistributedRequest processing;
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("\n\nDATABASE '" + this.databaseName + "' ON SERVER '" + this.manager.getLocalNodeName() + "'");
        buffer.append("\n- " + ODistributedOutput.formatRecordLocks(this.manager, this.databaseName));
        buffer.append("\n- MESSAGES IN QUEUES");
        buffer.append(" (" + (this.workerThreads != null ? this.workerThreads.size() : 0) + " WORKERS):");
        if (this.lockThread != null) {
            processing = this.lockThread.getProcessing();
            queue = this.lockThread.localQueue;
            if (processing != null || !queue.isEmpty()) {
                buffer.append("\n - QUEUE LOCK EXECUTING: " + processing);
                i = 0;
                for (ODistributedRequest m : queue) {
                    if (m == null) continue;
                    buffer.append("\n  - " + i + " = " + m.toString());
                }
            }
        }
        if (this.nowaitThread != null) {
            processing = this.nowaitThread.getProcessing();
            queue = this.nowaitThread.localQueue;
            if (processing != null || !queue.isEmpty()) {
                buffer.append("\n - QUEUE UNLOCK EXECUTING: " + processing);
                i = 0;
                for (ODistributedRequest m : queue) {
                    if (m == null) continue;
                    buffer.append("\n  - " + i + " = " + m.toString());
                }
            }
        }
        if (this.workerThreads != null) {
            for (ODistributedWorker t : this.workerThreads) {
                ODistributedRequest processing2 = t.getProcessing();
                ArrayBlockingQueue<ODistributedRequest> queue2 = t.localQueue;
                if (processing2 == null && queue2.isEmpty()) continue;
                buffer.append("\n  - QUEUE " + t.id + " EXECUTING: " + processing2);
                int i2 = 0;
                for (ODistributedRequest m : queue2) {
                    if (m == null) continue;
                    buffer.append("\n   - " + i2++ + " = " + m.toString());
                }
            }
        }
        return buffer.toString();
    }

    public class ODistributedLock {
        protected final ODistributedRequestId reqId;
        protected final CountDownLatch lock;
        protected final long acquiredOn;
        protected volatile ORawBuffer record;

        private ODistributedLock(ODistributedRequestId reqId) {
            this.reqId = reqId;
            this.lock = new CountDownLatch(1);
            this.acquiredOn = System.currentTimeMillis();
        }
    }
}

