/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class ODistributedDatabaseChunk
implements OStreamable {
    public String filePath;
    public long offset;
    public byte[] buffer;
    public boolean gzipCompressed;
    public boolean last;
    private ODistributedMomentum momentum;
    public boolean incremental;
    public long walSegment;
    public long walPosition;

    public ODistributedDatabaseChunk() {
    }

    public ODistributedDatabaseChunk(File iFile, long iOffset, int iMaxSize, ODistributedMomentum momentum, boolean gzipCompressed, boolean incremental) throws IOException {
        this(iFile, iOffset, iMaxSize, momentum, gzipCompressed, incremental, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedDatabaseChunk(File iFile, long iOffset, int iMaxSize, ODistributedMomentum momentum, boolean gzipCompressed, boolean incremental, long walSegment, long walPosition) throws IOException {
        this.filePath = iFile.getAbsolutePath();
        this.offset = iOffset;
        this.momentum = momentum;
        this.gzipCompressed = gzipCompressed;
        this.incremental = incremental;
        this.walSegment = walSegment;
        this.walPosition = walPosition;
        long fileSize = iFile.length();
        File completedFile = new File(iFile.getAbsolutePath() + ".completed");
        int retry = 0;
        while (fileSize <= iOffset) {
            if (fileSize == 0L || iOffset > fileSize) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            fileSize = iFile.length();
            if (completedFile.exists()) break;
            ++retry;
        }
        int toRead = (int)Math.min((long)iMaxSize, fileSize - this.offset);
        this.buffer = new byte[toRead];
        InputStream in = gzipCompressed ? new GZIPInputStream(new FileInputStream(iFile)) : new FileInputStream(iFile);
        try {
            in.skip(this.offset);
            in.read(this.buffer);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        fileSize = iFile.length();
        if (completedFile.exists() && fileSize - (this.offset + (long)toRead) == 0L) {
            this.last = true;
        }
    }

    public String toString() {
        return this.filePath + "[" + this.offset + "-" + this.buffer.length + "] (last=" + this.last + ")";
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.filePath);
        out.writeLong(this.offset);
        out.writeInt(this.buffer.length);
        out.write(this.buffer);
        if (this.momentum != null) {
            out.writeBoolean(true);
            this.momentum.toStream(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.gzipCompressed);
        out.writeBoolean(this.last);
        out.writeBoolean(this.incremental);
        out.writeLong(this.walSegment);
        out.writeLong(this.walPosition);
    }

    public void fromStream(DataInput in) throws IOException {
        this.filePath = in.readUTF();
        this.offset = in.readLong();
        int size = in.readInt();
        this.buffer = new byte[size];
        in.readFully(this.buffer);
        this.momentum = new ODistributedMomentum();
        boolean momentumPresent = in.readBoolean();
        if (momentumPresent) {
            this.momentum.fromStream(in);
        }
        this.gzipCompressed = in.readBoolean();
        this.last = in.readBoolean();
        this.incremental = in.readBoolean();
        this.walSegment = in.readLong();
        this.walPosition = in.readLong();
    }

    public ODistributedMomentum getMomentum() {
        return this.momentum;
    }

    public OLogSequenceNumber getLastWal() {
        return new OLogSequenceNumber(this.walSegment, this.walPosition);
    }
}

