/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OClusterPositionAllocator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class OClusterPositionAllocatorDatabase
implements OClusterPositionAllocator {
    private volatile Map<String, Integer> names = new HashMap<String, Integer>();
    private volatile AtomicLong[] allocators;

    public OClusterPositionAllocatorDatabase(OSharedContext context) {
        this.registerListener(context);
    }

    private void registerListener(final OSharedContext context1) {
        context1.registerListener((Object)new OMetadataUpdateListener(){

            public void onSchemaUpdate(String database, OSchemaShared schema) {
                OClusterPositionAllocatorDatabase.this.initAllocators(context1.getStorage());
            }

            public void onIndexManagerUpdate(String database, OIndexManager indexManager) {
            }

            public void onFunctionLibraryUpdate(String database) {
            }

            public void onSequenceLibraryUpdate(String database) {
            }

            public void onStorageConfigurationUpdate(String database, OStorageConfiguration update) {
                OClusterPositionAllocatorDatabase.this.initAllocators(context1.getStorage());
            }
        });
        this.initAllocators(context1.getStorage());
    }

    @Override
    public synchronized long allocate(int clusterId) {
        return this.allocators[clusterId].getAndIncrement();
    }

    private synchronized void initAllocators(OStorage storage) {
        int clusters = storage.getClusters();
        Collection clusterInstances = storage.getClusterInstances();
        AtomicLong[] newAllocators = new AtomicLong[clusters];
        HashMap<String, Integer> newNames = new HashMap<String, Integer>();
        for (OCluster cluster : clusterInstances) {
            try {
                Integer exits = this.names.get(cluster.getName());
                if (exits != null) {
                    newAllocators[cluster.getId()] = this.allocators[exits];
                } else {
                    long next = cluster.getLastPosition() + 1L;
                    newAllocators[cluster.getId()] = new AtomicLong(next);
                }
                newNames.put(cluster.getName(), cluster.getId());
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "error resolving last position", (Throwable)e, new Object[0]);
            }
        }
        this.allocators = newAllocators;
        this.names = newNames;
    }
}

