/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCacheSoftRefs;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentEmbeddedPooled;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerAware;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributedPooled;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedChannel;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.metadata.ODistributedContext;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSharedContextDistributed;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

public class OrientDBDistributed
extends OrientDBEmbedded
implements OServerAware {
    private OServer server;
    private volatile OHazelcastPlugin plugin;
    private final Map<String, ODistributedChannel> members = new HashMap<String, ODistributedChannel>();
    private volatile boolean coordinator = false;
    private volatile String coordinatorName;

    public OrientDBDistributed(String directoryPath, OrientDBConfig config, Orient instance) {
        super(directoryPath, config, instance);
    }

    public void init(OServer server) {
        this.server = server;
    }

    public synchronized OHazelcastPlugin getPlugin() {
        if (this.plugin == null && this.server != null && this.server.isActive()) {
            this.plugin = (OHazelcastPlugin)this.server.getPlugin("cluster");
        }
        return this.plugin;
    }

    protected OSharedContext createSharedContext(OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.getPlugin() == null || !this.getPlugin().isEnabled()) {
            return new OSharedContextEmbedded((OStorage)storage, (OrientDBEmbedded)this);
        }
        return new OSharedContextDistributed((OStorage)storage, this);
    }

    protected ODatabaseDocumentEmbedded newSessionInstance(OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.getPlugin() == null || !this.getPlugin().isEnabled()) {
            return new ODatabaseDocumentEmbedded((OStorage)storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName(), this.plugin.getDatabaseConfiguration(storage.getName()));
        return new ODatabaseDocumentDistributed(this.plugin.getStorage(storage.getName(), storage), this.plugin);
    }

    protected ODatabaseDocumentEmbedded newPooledSessionInstance(ODatabasePoolInternal pool, OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.getPlugin() == null || !this.getPlugin().isEnabled()) {
            return new ODatabaseDocumentEmbeddedPooled(pool, (OStorage)storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName(), this.plugin.getDatabaseConfiguration(storage.getName()));
        return new ODatabaseDocumentDistributedPooled(pool, this.plugin.getStorage(storage.getName(), storage), this.plugin);
    }

    public void setPlugin(OHazelcastPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage fullSync(String dbName, String backupPath, OrientDBConfig config) {
        OSharedContext context;
        OAbstractPaginatedStorage storage = null;
        OrientDBDistributed orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            try {
                storage = (OAbstractPaginatedStorage)this.storages.get(dbName);
                if (storage != null) {
                    OCommandCacheSoftRefs.clearFiles((OAbstractPaginatedStorage)storage);
                    ODistributedStorage.dropStorageFiles((OLocalPaginatedStorage)storage);
                    context = (OSharedContext)this.sharedContexts.remove(dbName);
                    context.close();
                    storage.delete();
                    this.storages.remove(dbName);
                }
                storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(dbName), new HashMap());
                ODatabaseDocumentEmbedded embedded = this.internalCreate(config, storage);
                this.storages.put(dbName, storage);
            }
            catch (Exception e) {
                if (storage != null) {
                    storage.delete();
                }
                throw OException.wrapException((OException)new ODatabaseException("Cannot restore database '" + dbName + "'"), (Throwable)e);
            }
        }
        storage.restoreFromIncrementalBackup(backupPath);
        orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            context = (OSharedContext)this.sharedContexts.remove(dbName);
            context.close();
        }
        ODatabaseDocumentEmbedded instance = this.openNoAuthorization(dbName);
        instance.close();
        this.checkCoordinator(dbName);
        return storage;
    }

    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        super.restore(name, in, options, callable, iListener);
        ODatabaseDocumentEmbedded instance = this.openNoAuthorization(name);
        instance.close();
        this.checkCoordinator(name);
    }

    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        super.restore(name, user, password, type, path, config);
        ODatabaseDocumentEmbedded instance = this.openNoAuthorization(name);
        instance.close();
        this.checkCoordinator(name);
    }

    public void create(String name, String user, String password, ODatabaseType type, OrientDBConfig config) {
        super.create(name, user, password, type, config);
        this.checkCoordinator(name);
    }

    public ODatabaseDocumentEmbedded openNoAuthenticate(String name, String user) {
        ODatabaseDocumentEmbedded session = super.openNoAuthenticate(name, user);
        this.checkCoordinator(name);
        return session;
    }

    public ODatabaseDocumentEmbedded openNoAuthorization(String name) {
        ODatabaseDocumentEmbedded session = super.openNoAuthorization(name);
        this.checkCoordinator(name);
        return session;
    }

    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        ODatabaseDocumentInternal session = super.open(name, user, password, config);
        this.checkCoordinator(name);
        return session;
    }

    public ODatabaseDocumentInternal poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        ODatabaseDocumentInternal session = super.poolOpen(name, user, password, pool);
        this.checkCoordinator(name);
        return session;
    }

    private synchronized void checkCoordinator(String database) {
        OSharedContext shared;
        if (!this.isDistributedVersionTwo()) {
            return;
        }
        if (!database.equals("OSystem") && (shared = (OSharedContext)this.sharedContexts.get(database)) instanceof OSharedContextDistributed) {
            ODistributedMember member;
            ODistributedContext distributed = ((OSharedContextDistributed)shared).getDistributedContext();
            if (distributed.getCoordinator() == null) {
                if (this.coordinator) {
                    distributed.makeCoordinator(this.plugin.getLocalNodeName(), shared);
                    for (Map.Entry<String, ODistributedChannel> node : this.members.entrySet()) {
                        member = new ODistributedMember(node.getKey(), database, node.getValue());
                        distributed.getCoordinator().join(member);
                    }
                } else {
                    ODistributedMember member2 = new ODistributedMember(this.coordinatorName, database, this.members.get(this.coordinatorName));
                    distributed.setExternalCoordinator(member2);
                }
            }
            for (Map.Entry<String, ODistributedChannel> node : this.members.entrySet()) {
                member = new ODistributedMember(node.getKey(), database, node.getValue());
                distributed.getExecutor().join(member);
            }
        }
    }

    private boolean isDistributedVersionTwo() {
        return this.getConfigurations().getConfigurations().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_REPLICATION_PROTOCOL_VERSION) == 2;
    }

    public synchronized void nodeJoin(String nodeName, ODistributedChannel channel) {
        if (!this.isDistributedVersionTwo()) {
            return;
        }
        this.members.put(nodeName, channel);
        for (OSharedContext context : this.sharedContexts.values()) {
            if (this.isContextToIgnore(context)) continue;
            ODistributedContext distributed = ((OSharedContextDistributed)context).getDistributedContext();
            ODistributedMember member = new ODistributedMember(nodeName, context.getStorage().getName(), channel);
            distributed.getExecutor().join(member);
            if (!this.coordinator) continue;
            ODistributedCoordinator c = distributed.getCoordinator();
            if (c == null) {
                distributed.makeCoordinator(this.plugin.getLocalNodeName(), context);
                c = distributed.getCoordinator();
            }
            c.join(member);
        }
    }

    public synchronized void nodeLeave(String nodeName) {
        if (!this.isDistributedVersionTwo()) {
            return;
        }
        this.members.remove(nodeName);
        for (OSharedContext context : this.sharedContexts.values()) {
            ODistributedCoordinator c;
            if (this.isContextToIgnore(context)) continue;
            ODistributedContext distributed = ((OSharedContextDistributed)context).getDistributedContext();
            distributed.getExecutor().leave(distributed.getExecutor().getMember(nodeName));
            if (!this.coordinator || (c = distributed.getCoordinator()) != null) continue;
            c.leave(c.getMember(nodeName));
        }
    }

    private boolean isContextToIgnore(OSharedContext context) {
        return context.getStorage().getName().equals("OSystem") || context.getStorage().isClosed();
    }

    public synchronized void setCoordinator(String lockManager, boolean isSelf) {
        if (!this.isDistributedVersionTwo()) {
            return;
        }
        this.coordinatorName = lockManager;
        if (isSelf) {
            if (!this.coordinator) {
                for (OSharedContext context : this.sharedContexts.values()) {
                    if (this.isContextToIgnore(context)) continue;
                    ODistributedContext distributed = ((OSharedContextDistributed)context).getDistributedContext();
                    distributed.makeCoordinator(lockManager, context);
                    for (Map.Entry<String, ODistributedChannel> node : this.members.entrySet()) {
                        ODistributedMember member = new ODistributedMember(node.getKey(), context.getStorage().getName(), node.getValue());
                        distributed.getCoordinator().join(member);
                    }
                }
                this.coordinator = true;
            }
        } else {
            for (OSharedContext context : this.sharedContexts.values()) {
                if (this.isContextToIgnore(context)) continue;
                ODistributedContext distributed = ((OSharedContextDistributed)context).getDistributedContext();
                ODistributedMember member = new ODistributedMember(lockManager, context.getStorage().getName(), this.members.get(lockManager));
                distributed.setExternalCoordinator(member);
            }
            this.coordinator = false;
        }
    }

    public synchronized ODistributedContext getDistributedContext(String database) {
        OSharedContext shared = (OSharedContext)this.sharedContexts.get(database);
        if (shared != null) {
            return ((OSharedContextDistributed)shared).getDistributedContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String name, String user, String password) {
        OrientDBDistributed orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            this.checkOpen();
            OSharedContext sharedContext = (OSharedContext)this.sharedContexts.get(name);
            if (sharedContext != null) {
                sharedContext.getViewManager().close();
            }
        }
        ODatabaseDocumentEmbedded db = this.openNoAuthenticate(name, user);
        Iterator it = this.orient.getDbLifecycleListeners();
        while (it.hasNext()) {
            ((ODatabaseLifecycleListener)it.next()).onDrop((ODatabaseInternal)db);
        }
        db.close();
        OrientDBDistributed orientDBDistributed2 = this;
        synchronized (orientDBDistributed2) {
            if (this.exists(name, user, password)) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                OSharedContext sharedContext = (OSharedContext)this.sharedContexts.get(name);
                if (sharedContext != null) {
                    sharedContext.close();
                }
                storage.delete();
                this.storages.remove(name);
                this.sharedContexts.remove(name);
            }
        }
    }
}

