/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtreebonsai.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OSBTreeBonsaiLocalException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import com.orientechnologies.orient.core.storage.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsaiBucket;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSysBucket;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;

public class OSBTreeBonsaiLocal<K, V>
extends ODurableComponent
implements OSBTreeBonsai<K, V> {
    private static final OLockManager<Long> FILE_LOCK_MANAGER = new OPartitionedLockManager<Long>();
    private static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final float freeSpaceReuseTrigger = OGlobalConfiguration.SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER.getValueAsFloat();
    private static final OBonsaiBucketPointer SYS_BUCKET = new OBonsaiBucketPointer(0L, 0);
    private OBonsaiBucketPointer rootBucketPointer;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private volatile Long fileId = -1L;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;

    public OSBTreeBonsaiLocal(String name, String dataFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during sbtree creation", this), e);
            }
            Lock lock = FILE_LOCK_MANAGER.acquireExclusiveLock(-1L);
            try {
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.fileId = this.isFileExists(atomicOperation, this.getFullName()) ? Long.valueOf(this.openFile(atomicOperation, this.getFullName())) : Long.valueOf(this.addFile(atomicOperation, this.getFullName()));
                this.initAfterCreate(atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error creation of sbtree with name" + this.getName(), this), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error creation of sbtree with name" + this.getName(), this), e);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAfterCreate(OAtomicOperation atomicOperation) throws IOException {
        this.initSysBucket(atomicOperation);
        AllocationResult allocationResult = this.allocateBucketForWrite(atomicOperation);
        OCacheEntry rootCacheEntry = allocationResult.getCacheEntry();
        this.rootBucketPointer = allocationResult.getPointer();
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, this);
            rootBucket.setTreeSize(0L);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileId() {
        Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
        try {
            long l = this.fileId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBonsaiBucketPointer getRootBucketPointer() {
        Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
        try {
            OBonsaiBucketPointer oBonsaiBucketPointer = this.rootBucketPointer;
            return oBonsaiBucketPointer;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBonsaiCollectionPointer getCollectionPointer() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
            try {
                OBonsaiCollectionPointer oBonsaiCollectionPointer = new OBonsaiCollectionPointer(this.fileId, this.rootBucketPointer);
                lock.unlock();
                return oBonsaiCollectionPointer;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean put(K key, V value) {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        this.startOperation();
        if (statistic != null) {
            statistic.startRidBagEntryUpdateTimer();
        }
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during sbtree entrie put", this), e);
            }
            Lock lock = FILE_LOCK_MANAGER.acquireExclusiveLock(this.fileId);
            try {
                BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
                OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                boolean itemFound = bucketSearchResult.itemIndex >= 0;
                boolean result = true;
                if (itemFound) {
                    int updateResult = keyBucket.updateValue(bucketSearchResult.itemIndex, value);
                    assert (updateResult == 0 || updateResult == 1);
                    result = updateResult != 0;
                } else {
                    int insertionIndex = -bucketSearchResult.itemIndex - 1;
                    while (!keyBucket.addEntry(insertionIndex, new OSBTreeBonsaiBucket.SBTreeEntry<K, V>(OBonsaiBucketPointer.NULL, OBonsaiBucketPointer.NULL, key, value), true)) {
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key, atomicOperation);
                        bucketPointer = bucketSearchResult.getLastPathItem();
                        insertionIndex = bucketSearchResult.itemIndex;
                        keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem().getPageIndex(), false);
                        keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                    }
                }
                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                if (!itemFound) {
                    this.updateSize(1L, atomicOperation);
                }
                this.endAtomicOperation(false, null);
                boolean bl = result;
                return bl;
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during index update with key " + key + " and value " + value, this), e);
            }
            finally {
                lock.unlock();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopRidBagEntryUpdateTimer();
            }
            this.completeOperation();
        }
    }

    private void rollback(Exception e) {
        try {
            this.endAtomicOperation(true, e);
        }
        catch (IOException e1) {
            OLogManager.instance().error(this, "Error during sbtree operation  rollback", e1, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) {
        this.startOperation();
        try {
            Lock lock = FILE_LOCK_MANAGER.acquireExclusiveLock(this.fileId);
            try {
                this.readCache.closeFile(this.fileId, flush, this.writeCache);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during sbtree entrie clear", this), e);
            }
            Lock lock = FILE_LOCK_MANAGER.acquireExclusiveLock(this.fileId);
            try {
                LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false);
                try {
                    OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                    this.addChildrenToQueue(subTreesToDelete, rootBucket);
                    rootBucket.shrink(0);
                    rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, this);
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
                this.recycleSubTrees(subTreesToDelete, atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during clear of sbtree with name " + this.getName(), this), e);
            }
            catch (RuntimeException e) {
                this.rollback(e);
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private void addChildrenToQueue(Queue<OBonsaiBucketPointer> subTreesToDelete, OSBTreeBonsaiBucket<K, V> rootBucket) {
        if (!rootBucket.isLeaf()) {
            int size = rootBucket.size();
            if (size > 0) {
                subTreesToDelete.add(rootBucket.getEntry((int)0).leftChild);
            }
            for (int i = 0; i < size; ++i) {
                OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = rootBucket.getEntry(i);
                subTreesToDelete.add(entry.rightChild);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSubTrees(Queue<OBonsaiBucketPointer> subTreesToDelete, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer head = OBonsaiBucketPointer.NULL;
        OBonsaiBucketPointer tail = subTreesToDelete.peek();
        int bucketCount = 0;
        while (!subTreesToDelete.isEmpty()) {
            OBonsaiBucketPointer bucketPointer = subTreesToDelete.poll();
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
            try {
                OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                this.addChildrenToQueue(subTreesToDelete, bucket);
                bucket.setFreeListPointer(head);
                bucket.setDelted(true);
                head = bucketPointer;
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            ++bucketCount;
        }
        if (head.isValid()) {
            OCacheEntry sysCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false);
            try {
                OSysBucket sysBucket = new OSysBucket(sysCacheEntry);
                this.attachFreeListHead(tail, sysBucket.getFreeListHead(), atomicOperation);
                sysBucket.setFreeListHead(head);
                sysBucket.setFreeListLength(sysBucket.freeListLength() + (long)bucketCount);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, sysCacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachFreeListHead(OBonsaiBucketPointer bucketPointer, OBonsaiBucketPointer freeListHead, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
        try {
            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
            bucket.setFreeListPointer(freeListHead);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during sbtree deletion", this), e);
            }
            Lock lock = FILE_LOCK_MANAGER.acquireExclusiveLock(this.fileId);
            try {
                LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
                subTreesToDelete.add(this.rootBucketPointer);
                this.recycleSubTrees(subTreesToDelete, atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during delete of sbtree with name " + this.getName(), this), e);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean load(OBonsaiBucketPointer rootBucketPointer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false);
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
            rootBucket.setTreeSize(rootBucket.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false);
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
            rootBucket.setTreeSize(size);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public V remove(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> getValuesMinor(K key, boolean inclusive, final int maxValuesToFetch) {
        this.startOperation();
        try {
            final ArrayList result = new ArrayList();
            this.loadEntriesMinor(key, inclusive, new OTreeInternal.RangeResultListener<K, V>(){

                @Override
                public boolean addResult(Map.Entry<K, V> entry) {
                    result.add(entry.getValue());
                    return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
                }
            });
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        this.startOperation();
        int readEntries = 0;
        if (statistic != null) {
            statistic.startRidBagEntryReadTimer();
        }
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                    OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
                    int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                    boolean firstBucket = true;
                    do {
                        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
                        try {
                            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                            if (!firstBucket) {
                                index = bucket.size() - 1;
                            }
                            for (int i = index; i >= 0; --i) {
                                if (listener.addResult(bucket.getEntry(i))) continue;
                                ++readEntries;
                                return;
                            }
                            bucketPointer = bucket.getLeftSibling();
                            firstBucket = false;
                        }
                        finally {
                            this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    } while (bucketPointer.getPageIndex() >= 0L);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during fetch of minor values for key " + key + " in sbtree " + this.getName(), this), ioe);
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopRidBagEntryReadTimer(readEntries);
            }
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> getValuesMajor(K key, boolean inclusive, final int maxValuesToFetch) {
        this.startOperation();
        try {
            final ArrayList result = new ArrayList();
            this.loadEntriesMajor(key, inclusive, true, new OTreeInternal.RangeResultListener<K, V>(){

                @Override
                public boolean addResult(Map.Entry<K, V> entry) {
                    result.add(entry.getValue());
                    return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
                }
            });
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        int readEntries = 0;
        this.startOperation();
        if (statistic != null) {
            statistic.startRidBagEntryReadTimer();
        }
        try {
            if (!ascSortOrder) {
                throw new IllegalStateException("Descending sort order is not supported.");
            }
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                    OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
                    int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                    do {
                        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
                        try {
                            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                            int bucketSize = bucket.size();
                            for (int i = index; i < bucketSize; ++i) {
                                if (listener.addResult(bucket.getEntry(i))) continue;
                                ++readEntries;
                                return;
                            }
                            bucketPointer = bucket.getRightSibling();
                            index = 0;
                        }
                        finally {
                            this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    } while (bucketPointer.getPageIndex() >= 0L);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during fetch of major values for key " + key + " in sbtree " + this.getName(), this), ioe);
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopRidBagEntryReadTimer(readEntries);
            }
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, final int maxValuesToFetch) {
        this.startOperation();
        try {
            final ArrayList result = new ArrayList();
            this.loadEntriesBetween(keyFrom, fromInclusive, keyTo, toInclusive, new OTreeInternal.RangeResultListener<K, V>(){

                @Override
                public boolean addResult(Map.Entry<K, V> entry) {
                    result.add(entry.getValue());
                    return maxValuesToFetch <= 0 || result.size() < maxValuesToFetch;
                }
            });
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 25[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 25[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        block20: {
            OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
            int readEntries = 0;
            this.startOperation();
            if (statistic != null) {
                statistic.startRidBagEntryReadTimer();
            }
            try {
                this.atomicOperationsManager.acquireReadLock(this);
                try {
                    Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
                    try {
                        OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResultFrom = this.findBucket(keyFrom, atomicOperation);
                        OBonsaiBucketPointer bucketPointerFrom = bucketSearchResultFrom.getLastPathItem();
                        int indexFrom = bucketSearchResultFrom.itemIndex >= 0 ? (fromInclusive ? bucketSearchResultFrom.itemIndex : bucketSearchResultFrom.itemIndex + 1) : -bucketSearchResultFrom.itemIndex - 1;
                        BucketSearchResult bucketSearchResultTo = this.findBucket(keyTo, atomicOperation);
                        OBonsaiBucketPointer bucketPointerTo = bucketSearchResultTo.getLastPathItem();
                        int indexTo = bucketSearchResultTo.itemIndex >= 0 ? (toInclusive ? bucketSearchResultTo.itemIndex : bucketSearchResultTo.itemIndex - 1) : -bucketSearchResultTo.itemIndex - 2;
                        int startIndex = indexFrom;
                        OBonsaiBucketPointer bucketPointer = bucketPointerFrom;
                        while (true) {
                            block21: {
                                OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
                                try {
                                    OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                                    int endIndex = !bucketPointer.equals(bucketPointerTo) ? bucket.size() - 1 : indexTo;
                                    for (int i = startIndex; i <= endIndex; ++i) {
                                        if (listener.addResult(bucket.getEntry(i))) continue;
                                        ++readEntries;
                                        break block20;
                                    }
                                    if (!bucketPointer.equals(bucketPointerTo) && (bucketPointer = bucket.getRightSibling()).getPageIndex() >= 0L) break block21;
                                    break;
                                }
                                finally {
                                    this.releasePageFromRead(atomicOperation, cacheEntry);
                                }
                            }
                            startIndex = 0;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (IOException ioe) {
                    throw OException.wrapException(new OSBTreeBonsaiLocalException("Error during fetch of values between key " + keyFrom + " and key " + keyTo + " in sbtree " + this.getName(), this), ioe);
                }
                finally {
                    this.atomicOperationsManager.releaseReadLock(this);
                }
            }
            finally {
                if (statistic != null) {
                    statistic.stopRidBagEntryReadTimer(readEntries);
                }
                this.completeOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.startOperation();
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
                try {
                    this.writeCache.flush();
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<OBonsaiBucketPointer> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer bucketPointer = path.get(path.size() - 1);
        OCacheEntry bucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
        try {
            int startRightIndex;
            OSBTreeBonsaiBucket<K, Object> bucketToSplit = new OSBTreeBonsaiBucket<K, Object>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList rightEntries = new ArrayList(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (!bucketPointer.equals(this.rootBucketPointer)) {
                Object parentBucketPointer;
                AllocationResult allocationResult = this.allocateBucketForWrite(atomicOperation);
                OCacheEntry rightBucketEntry = allocationResult.getCacheEntry();
                OBonsaiBucketPointer rightBucketPointer = allocationResult.getPointer();
                try {
                    OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this);
                    newRightBucket.addAll(rightEntries);
                    bucketToSplit.shrink(indexToSplit);
                    if (splitLeaf) {
                        OBonsaiBucketPointer rightSiblingBucketPointer = bucketToSplit.getRightSibling();
                        newRightBucket.setRightSibling(rightSiblingBucketPointer);
                        newRightBucket.setLeftSibling(bucketPointer);
                        bucketToSplit.setRightSibling(rightBucketPointer);
                        if (rightSiblingBucketPointer.isValid()) {
                            OCacheEntry rightSiblingBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSiblingBucketPointer.getPageIndex(), false);
                            OSBTreeBonsaiBucket<K, V> rightSiblingBucket = new OSBTreeBonsaiBucket<K, V>(rightSiblingBucketEntry, rightSiblingBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                            try {
                                rightSiblingBucket.setLeftSibling(rightBucketPointer);
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                            }
                        }
                    }
                    parentBucketPointer = path.get(path.size() - 2);
                    OCacheEntry parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false);
                    try {
                        OSBTreeBonsaiBucket<K, Object> parentBucket = new OSBTreeBonsaiBucket<K, Object>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, this);
                        OSBTreeBonsaiBucket.SBTreeEntry<K, Object> parentEntry = new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(bucketPointer, rightBucketPointer, separationKey, null);
                        int insertionIndex = parentBucket.find(separationKey);
                        assert (insertionIndex < 0);
                        insertionIndex = -insertionIndex - 1;
                        while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                            this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                            BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                            parentBucketPointer = bucketSearchResult.getLastPathItem();
                            parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false);
                            insertionIndex = bucketSearchResult.itemIndex;
                            parentBucket = new OSBTreeBonsaiBucket<K, V>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, this);
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                    }
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rightBucketEntry);
                }
                ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
                if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                    resultPath.add(bucketPointer);
                    parentBucketPointer = new BucketSearchResult(keyIndex, resultPath);
                    return parentBucketPointer;
                }
                resultPath.add(rightBucketPointer);
                if (splitLeaf) {
                    parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                    return parentBucketPointer;
                }
                parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
                return parentBucketPointer;
            }
            long treeSize = bucketToSplit.getTreeSize();
            ArrayList leftEntries = new ArrayList(indexToSplit);
            for (int i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getEntry(i));
            }
            AllocationResult leftAllocationResult = this.allocateBucketForWrite(atomicOperation);
            OCacheEntry leftBucketEntry = leftAllocationResult.getCacheEntry();
            OBonsaiBucketPointer leftBucketPointer = leftAllocationResult.getPointer();
            AllocationResult rightAllocationResult = this.allocateBucketForWrite(atomicOperation);
            OCacheEntry rightBucketEntry = rightAllocationResult.getCacheEntry();
            OBonsaiBucketPointer rightBucketPointer = rightAllocationResult.getPointer();
            try {
                OSBTreeBonsaiBucket newLeftBucket = new OSBTreeBonsaiBucket(leftBucketEntry, leftBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this);
                newLeftBucket.addAll(leftEntries);
                if (splitLeaf) {
                    newLeftBucket.setRightSibling(rightBucketPointer);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, leftBucketEntry);
            }
            try {
                OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this);
                newRightBucket.addAll(rightEntries);
                if (splitLeaf) {
                    newRightBucket.setLeftSibling(leftBucketPointer);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, rightBucketEntry);
            }
            bucketToSplit = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), false, this.keySerializer, this.valueSerializer, this);
            bucketToSplit.setTreeSize(treeSize);
            bucketToSplit.addEntry(0, new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(leftBucketPointer, rightBucketPointer, separationKey, null), true);
            ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
            if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                resultPath.add(leftBucketPointer);
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex, resultPath);
                return bucketSearchResult;
            }
            resultPath.add(rightBucketPointer);
            if (splitLeaf) {
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
            return bucketSearchResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer bucketPointer = this.rootBucketPointer;
        ArrayList<OBonsaiBucketPointer> path = new ArrayList<OBonsaiBucketPointer>();
        while (true) {
            OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry;
            path.add(bucketPointer);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false);
            try {
                int insertionIndex;
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                bucketPointer = entry.rightChild;
                continue;
            }
            bucketPointer = entry.leftChild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSysBucket(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry sysCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false);
        if (sysCacheEntry == null) {
            sysCacheEntry = this.addPage(atomicOperation, this.fileId);
            assert (sysCacheEntry.getPageIndex() == SYS_BUCKET.getPageIndex());
        }
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry);
            if (sysBucket.isInitialized()) {
                this.releasePageFromWrite(atomicOperation, sysCacheEntry);
                sysCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false);
                sysBucket = new OSysBucket(sysCacheEntry);
                sysBucket.init();
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, sysCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocationResult allocateBucketForWrite(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry sysCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false);
        if (sysCacheEntry == null) {
            sysCacheEntry = this.addPage(atomicOperation, this.fileId);
            assert (sysCacheEntry.getPageIndex() == SYS_BUCKET.getPageIndex());
        }
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry);
            if (1.0 * (double)sysBucket.freeListLength() / (1.0 * (double)this.getFilledUpTo(atomicOperation, this.fileId) * (double)PAGE_SIZE / (double)OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES) >= (double)this.freeSpaceReuseTrigger) {
                AllocationResult allocationResult;
                AllocationResult allocationResult2 = allocationResult = this.reuseBucketFromFreeList(sysBucket, atomicOperation);
                return allocationResult2;
            }
            OBonsaiBucketPointer freeSpacePointer = sysBucket.getFreeSpacePointer();
            if (freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES > PAGE_SIZE) {
                OCacheEntry cacheEntry = this.addPage(atomicOperation, this.fileId);
                long pageIndex = cacheEntry.getPageIndex();
                sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(pageIndex, OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
                AllocationResult allocationResult = new AllocationResult(new OBonsaiBucketPointer(pageIndex, 0), cacheEntry);
                return allocationResult;
            }
            sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(freeSpacePointer.getPageIndex(), freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, freeSpacePointer.getPageIndex(), false);
            AllocationResult allocationResult = new AllocationResult(freeSpacePointer, cacheEntry);
            return allocationResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, sysCacheEntry);
        }
    }

    private AllocationResult reuseBucketFromFreeList(OSysBucket sysBucket, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer oldFreeListHead = sysBucket.getFreeListHead();
        assert (oldFreeListHead.isValid());
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, oldFreeListHead.getPageIndex(), false);
        OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, oldFreeListHead.getPageOffset(), this.keySerializer, this.valueSerializer, this);
        sysBucket.setFreeListHead(bucket.getFreeListPointer());
        sysBucket.setFreeListLength(sysBucket.freeListLength() - 1L);
        return new AllocationResult(oldFreeListHead, cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRealBagSize(Map<K, Change> changes) {
        this.startOperation();
        try {
            final HashMap<K, Change> notAppliedChanges = new HashMap<K, Change>(changes);
            final OModifiableInteger size = new OModifiableInteger(0);
            this.loadEntriesMajor(this.firstKey(), true, true, new OTreeInternal.RangeResultListener<K, V>(){

                @Override
                public boolean addResult(Map.Entry<K, V> entry) {
                    Change change = (Change)notAppliedChanges.remove(entry.getKey());
                    Integer treeValue = (Integer)entry.getValue();
                    int result = change == null ? treeValue.intValue() : change.applyTo(treeValue);
                    size.increment(result);
                    return true;
                }
            });
            for (Change change : notAppliedChanges.values()) {
                size.increment(change.applyTo(0));
            }
            int n = size.intValue();
            return n;
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public OBinarySerializer<K> getKeySerializer() {
        Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
        try {
            OBinarySerializer<K> oBinarySerializer = this.keySerializer;
            return oBinarySerializer;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBinarySerializer<V> getValueSerializer() {
        Lock lock = FILE_LOCK_MANAGER.acquireSharedLock(this.fileId);
        try {
            OBinarySerializer<V> oBinarySerializer = this.valueSerializer;
            return oBinarySerializer;
        }
        finally {
            lock.unlock();
        }
    }

    public void debugPrintBucket(PrintStream writer) throws IOException {
        ArrayList<OBonsaiBucketPointer> path = new ArrayList<OBonsaiBucketPointer>();
        path.add(this.rootBucketPointer);
        this.debugPrintBucket(this.rootBucketPointer, writer, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugPrintBucket(OBonsaiBucketPointer bucketPointer, PrintStream writer, ArrayList<OBonsaiBucketPointer> path) throws IOException {
        OCacheEntry bucketEntry = this.loadPageForRead(null, this.fileId, bucketPointer.getPageIndex(), false);
        try {
            OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this);
            if (keyBucket.isLeaf()) {
                for (int i = 0; i < path.size(); ++i) {
                    writer.append("\t");
                }
                writer.append(" Leaf backet:" + bucketPointer.getPageIndex() + "|" + bucketPointer.getPageOffset());
                writer.append(" left bucket:" + keyBucket.getLeftSibling().getPageIndex() + "|" + keyBucket.getLeftSibling().getPageOffset());
                writer.append(" right bucket:" + keyBucket.getRightSibling().getPageIndex() + "|" + keyBucket.getRightSibling().getPageOffset());
                writer.append(" size:" + keyBucket.size());
                writer.append(" content: [");
                for (int index = 0; index < keyBucket.size(); ++index) {
                    OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = keyBucket.getEntry(index);
                    writer.append(entry.getKey() + ",");
                }
                writer.append("\n");
            } else {
                for (int i = 0; i < path.size(); ++i) {
                    writer.append("\t");
                }
                writer.append(" node bucket:" + bucketPointer.getPageIndex() + "|" + bucketPointer.getPageOffset());
                writer.append(" left bucket:" + keyBucket.getLeftSibling().getPageIndex() + "|" + keyBucket.getLeftSibling().getPageOffset());
                writer.append(" right bucket:" + keyBucket.getRightSibling().getPageIndex() + "|" + keyBucket.getRightSibling().getPageOffset());
                writer.append("\n");
                for (int index = 0; index < keyBucket.size(); ++index) {
                    OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = keyBucket.getEntry(index);
                    for (int i = 0; i < path.size(); ++i) {
                        writer.append("\t");
                    }
                    writer.append(" entry:" + index + " key: " + entry.getKey() + " left \n");
                    OBonsaiBucketPointer next = entry.leftChild;
                    path.add(next);
                    this.debugPrintBucket(next, writer, path);
                    path.remove(next);
                    for (int i = 0; i < path.size(); ++i) {
                        writer.append("\t");
                    }
                    writer.append(" entry:" + index + " key: " + entry.getKey() + " right \n");
                    next = entry.rightChild;
                    path.add(next);
                    this.debugPrintBucket(next, writer, path);
                    path.remove(next);
                }
            }
        }
        finally {
            this.releasePageFromRead(null, bucketEntry);
        }
    }

    @Override
    protected void startOperation() {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startComponentOperation(this.getFullName(), OSessionStoragePerformanceStatistic.ComponentType.RIDBAG);
        }
    }

    private static final class PagePathItemUnit {
        private final OBonsaiBucketPointer bucketPointer;
        private final int itemIndex;

        private PagePathItemUnit(OBonsaiBucketPointer bucketPointer, int itemIndex) {
            this.bucketPointer = bucketPointer;
            this.itemIndex = itemIndex;
        }

        static /* synthetic */ OBonsaiBucketPointer access$400(PagePathItemUnit x0) {
            return x0.bucketPointer;
        }

        static /* synthetic */ int access$500(PagePathItemUnit x0) {
            return x0.itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<OBonsaiBucketPointer> path;

        private BucketSearchResult(int itemIndex, ArrayList<OBonsaiBucketPointer> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public OBonsaiBucketPointer getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static class AllocationResult {
        private final OBonsaiBucketPointer pointer;
        private final OCacheEntry cacheEntry;

        private AllocationResult(OBonsaiBucketPointer pointer, OCacheEntry cacheEntry) {
            this.pointer = pointer;
            this.cacheEntry = cacheEntry;
        }

        private OBonsaiBucketPointer getPointer() {
            return this.pointer;
        }

        private OCacheEntry getCacheEntry() {
            return this.cacheEntry;
        }
    }
}

