/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class OSBTreeBucket<K, V>
extends ODurablePage {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int TREE_SIZE_OFFSET = 53;
    private static final int KEY_SERIALIZER_OFFSET = 61;
    private static final int VALUE_SERIALIZER_OFFSET = 62;
    private static final int FREE_VALUES_LIST_OFFSET = 63;
    private static final int POSITIONS_ARRAY_OFFSET = 71;
    private final boolean isLeaf;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private final OType[] keyTypes;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final OEncryption encryption;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OSBTreeBucket(OCacheEntry cacheEntry, boolean isLeaf, OBinarySerializer<K> keySerializer, OType[] keyTypes, OBinarySerializer<V> valueSerializer, OEncryption encryption) throws IOException {
        super(cacheEntry);
        this.isLeaf = isLeaf;
        this.keySerializer = keySerializer;
        this.keyTypes = keyTypes;
        this.valueSerializer = valueSerializer;
        this.encryption = encryption;
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
        this.setLongValue(53, 0L);
        this.setLongValue(63, -1L);
        this.setByteValue(61, this.keySerializer.getId());
        this.setByteValue(62, this.valueSerializer.getId());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OSBTreeBucket(OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OType[] keyTypes, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
        super(cacheEntry);
        this.keyTypes = keyTypes;
        this.encryption = encryption;
        this.isLeaf = this.getByteValue(36) > 0;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void setTreeSize(long size) throws IOException {
        this.setLongValue(53, size);
    }

    public long getTreeSize() {
        return this.getLongValue(53);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long getValuesFreeListFirstIndex() {
        return this.getLongValue(63);
    }

    public void setValuesFreeListFirstIndex(long pageIndex) throws IOException {
        this.setLongValue(63, pageIndex);
    }

    public int find(K key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public long remove(int entryIndex) throws IOException {
        int entrySize;
        int keySize;
        int entryPosition = this.getIntValue(71 + entryIndex * 4);
        if (this.encryption == null) {
            keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int decryptedSize = this.getIntValue(entryPosition);
            keySize = 4 + decryptedSize;
        }
        long linkValue = -1L;
        if (this.isLeaf) {
            if (this.valueSerializer.isFixedLength()) {
                entrySize = keySize + this.valueSerializer.getFixedLength() + 1;
            } else {
                boolean isLink;
                boolean bl = isLink = this.getByteValue(entryPosition + keySize) > 0;
                if (!isLink) {
                    entrySize = keySize + this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + keySize + 1) + 1;
                } else {
                    entrySize = keySize + 1 + 8;
                    linkValue = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + keySize + 1);
                }
            }
        } else {
            throw new IllegalStateException("Remove is applies to leaf buckets only");
        }
        int size = this.size();
        if (entryIndex < size - 1) {
            this.moveData(71 + (entryIndex + 1) * 4, 71 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 71;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        return linkValue;
    }

    public int size() {
        return this.getIntValue(32);
    }

    public SBTreeEntry<K, V> getEntry(int entryIndex) {
        K key;
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.isLeaf) {
            K key2;
            if (this.encryption == null) {
                key2 = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
                entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptionSize = this.getIntValue(entryPosition);
                byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
                entryPosition += encryptedKey.length;
                byte[] serializedKey = this.encryption.decrypt(encryptedKey);
                key2 = this.keySerializer.deserializeNativeObject(serializedKey, 0);
            }
            boolean isLinkValue = this.getByteValue(entryPosition) > 0;
            long link = -1L;
            Object value = null;
            if (isLinkValue) {
                link = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + 1);
            } else {
                value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition + 1);
            }
            return new SBTreeEntry<K, Object>(-1L, -1L, key2, new OSBTreeValue<Object>(link >= 0L, link, value));
        }
        long leftChild = this.getLongValue(entryPosition);
        long rightChild = this.getLongValue(entryPosition += 8);
        entryPosition += 8;
        if (this.encryption == null) {
            key = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
            byte[] serializedKey = this.encryption.decrypt(encryptedKey);
            key = this.keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        return new SBTreeEntry(leftChild, rightChild, key, null);
    }

    public OSBTreeValue<V> getValue(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        boolean isLinkValue = this.getByteValue(entryPosition) > 0;
        long link = -1L;
        Object value = null;
        if (isLinkValue) {
            link = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + 1);
        } else {
            value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition + 1);
        }
        return new OSBTreeValue<Object>(link >= 0L, link, value);
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(index * 4 + 71);
        if (!this.isLeaf) {
            entryPosition += 16;
        }
        if (this.encryption == null) {
            return this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = this.encryption.decrypt(encryptedKey);
        return this.keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void addAll(List<SBTreeEntry<K, V>> entries) throws IOException {
        for (int i = 0; i < entries.size(); ++i) {
            this.addEntry(i, entries.get(i), false);
        }
    }

    public void shrink(int newSize) throws IOException {
        ArrayList<SBTreeEntry<K, V>> treeEntries = new ArrayList<SBTreeEntry<K, V>>(newSize);
        for (int i = 0; i < newSize; ++i) {
            treeEntries.add(this.getEntry(i));
        }
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        int index = 0;
        for (SBTreeEntry sBTreeEntry : treeEntries) {
            this.addEntry(index, sBTreeEntry, false);
            ++index;
        }
    }

    public boolean addEntry(int index, SBTreeEntry<K, V> treeEntry, boolean updateNeighbors) throws IOException {
        int keySize;
        byte[] encryptedKey = null;
        if (this.encryption == null) {
            keySize = this.keySerializer.getObjectSize(treeEntry.key, this.keyTypes);
        } else {
            int serializedKeySize = this.keySerializer.getObjectSize(treeEntry.key, this.keyTypes);
            byte[] serializedKey = new byte[serializedKeySize];
            this.keySerializer.serializeNativeObject(treeEntry.key, serializedKey, 0, this.keyTypes);
            encryptedKey = this.encryption.encrypt(serializedKey);
            keySize = encryptedKey.length + 4;
        }
        int valueSize = 0;
        int entrySize = keySize;
        if (this.isLeaf) {
            valueSize = this.valueSerializer.isFixedLength() ? this.valueSerializer.getFixedLength() : (treeEntry.value.isLink() ? 8 : this.valueSerializer.getObjectSize(treeEntry.value.getValue(), new Object[0]));
            entrySize += valueSize + 1;
        } else {
            entrySize += 16;
        }
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 71) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(71 + index * 4, 71 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(71 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        if (this.isLeaf) {
            if (this.encryption == null) {
                byte[] serializedKey = new byte[keySize];
                this.keySerializer.serializeNativeObject(treeEntry.key, serializedKey, 0, this.keyTypes);
                freePointer += this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                freePointer += 4;
                freePointer += this.setBinaryValue(freePointer, encryptedKey);
            }
            freePointer += this.setByteValue(freePointer, treeEntry.value.isLink() ? (byte)1 : 0);
            byte[] serializedValue = new byte[valueSize];
            if (treeEntry.value.isLink()) {
                OLongSerializer.INSTANCE.serializeNative(treeEntry.value.getLink(), serializedValue, 0, new Object[0]);
            } else {
                this.valueSerializer.serializeNativeObject(treeEntry.value.getValue(), serializedValue, 0, new Object[0]);
            }
            this.setBinaryValue(freePointer, serializedValue);
        } else {
            freePointer += this.setLongValue(freePointer, treeEntry.leftChild);
            freePointer += this.setLongValue(freePointer, treeEntry.rightChild);
            if (this.encryption == null) {
                byte[] serializedKey = new byte[keySize];
                this.keySerializer.serializeNativeObject(treeEntry.key, serializedKey, 0, this.keyTypes);
                this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                this.setBinaryValue(freePointer += 4, encryptedKey);
            }
            if (updateNeighbors && ++size > 1) {
                if (index < size - 1) {
                    int nextEntryPosition = this.getIntValue(71 + (index + 1) * 4);
                    this.setLongValue(nextEntryPosition, treeEntry.rightChild);
                }
                if (index > 0) {
                    int prevEntryPosition = this.getIntValue(71 + (index - 1) * 4);
                    this.setLongValue(prevEntryPosition + 8, treeEntry.leftChild);
                }
            }
        }
        return true;
    }

    public int updateValue(int index, OSBTreeValue<V> value) throws IOException {
        int entryPosition = this.getIntValue(index * 4 + 71);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        boolean isLinkValue = this.getByteValue(entryPosition) > 0;
        int newSize = 0;
        newSize = value.isLink() ? 8 : this.valueSerializer.getObjectSize(value.getValue(), new Object[0]);
        int oldSize = isLinkValue ? 8 : this.getObjectSizeInDirectMemory(this.valueSerializer, ++entryPosition);
        if (newSize != oldSize) {
            return -1;
        }
        byte[] serializedValue = new byte[newSize];
        if (value.isLink()) {
            OLongSerializer.INSTANCE.serializeNative(value.getLink(), serializedValue, 0, new Object[0]);
        } else {
            this.valueSerializer.serializeNativeObject(value.getValue(), serializedValue, 0, new Object[0]);
        }
        byte[] oldSerializedValue = this.getBinaryValue(entryPosition, oldSize);
        if (ODefaultComparator.INSTANCE.compare(oldSerializedValue, serializedValue) == 0) {
            return 0;
        }
        this.setBinaryValue(entryPosition, serializedValue);
        return 1;
    }

    public void setLeftSibling(long pageIndex) throws IOException {
        this.setLongValue(37, pageIndex);
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    public void setRightSibling(long pageIndex) throws IOException {
        this.setLongValue(45, pageIndex);
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class SBTreeEntry<K, V>
    implements Comparable<SBTreeEntry<K, V>> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        public final long leftChild;
        public final long rightChild;
        public final K key;
        public final OSBTreeValue<V> value;

        public SBTreeEntry(long leftChild, long rightChild, K key, OSBTreeValue<V> value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            if (this.leftChild != that.leftChild) {
                return false;
            }
            if (this.rightChild != that.rightChild) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = (int)(this.leftChild ^ this.leftChild >>> 32);
            result = 31 * result + (int)(this.rightChild ^ this.rightChild >>> 32);
            result = 31 * result + this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<K, V> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

