/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OHashIndexBucket<K, V>
extends ODurablePage
implements Iterable<Entry<K, V>> {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int DEPTH_OFFSET = 32;
    private static final int SIZE_OFFSET = 33;
    private static final int HISTORY_OFFSET = 37;
    private static final int NEXT_REMOVED_BUCKET_OFFSET = 549;
    private static final int POSITIONS_ARRAY_OFFSET = 557;
    public static final int MAX_BUCKET_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private final OType[] keyTypes;
    private final Comparator keyComparator = ODefaultComparator.INSTANCE;
    private final OEncryption encryption;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OHashIndexBucket(int depth, OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OEncryption encryption) throws IOException {
        super(cacheEntry);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyTypes = keyTypes;
        this.encryption = encryption;
        this.init(depth);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OHashIndexBucket(OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OEncryption encryption) {
        super(cacheEntry);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyTypes = keyTypes;
        this.encryption = encryption;
    }

    public void init(int depth) throws IOException {
        this.setByteValue(32, (byte)depth);
        this.setIntValue(28, MAX_BUCKET_SIZE_BYTES);
        this.setIntValue(33, 0);
    }

    public Entry<K, V> find(K key, long hashCode) {
        int index = this.binarySearch(key, hashCode);
        if (index < 0) {
            return null;
        }
        return this.getEntry(index);
    }

    private int binarySearch(K key, long hashCode) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            long midHashCode = this.getHashCode(mid);
            if (OHashIndexBucket.lessThanUnsigned(midHashCode, hashCode)) {
                cmp = -1;
            } else if (OHashIndexBucket.greaterThanUnsigned(midHashCode, hashCode)) {
                cmp = 1;
            } else {
                K midVal = this.getKey(mid);
                cmp = this.keyComparator.compare(midVal, key);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static boolean lessThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
    }

    private static boolean greaterThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE > longTwo + Long.MIN_VALUE;
    }

    public Entry<K, V> getEntry(int index) {
        K key;
        int entryPosition = this.getIntValue(557 + index * 4);
        long hashCode = this.getLongValue(entryPosition);
        entryPosition += 8;
        if (this.encryption == null) {
            key = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedLength = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedLength);
            entryPosition += encryptedLength;
            byte[] binaryKey = this.encryption.decrypt(encryptedKey);
            key = this.keySerializer.deserializeNativeObject(binaryKey, 0);
        }
        V value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition);
        return new Entry<K, V>(key, value, hashCode);
    }

    public V getValue(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        entryPosition += 8;
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedLength = this.getIntValue(entryPosition);
            entryPosition += encryptedLength + 4;
        }
        return this.deserializeFromDirectMemory(this.valueSerializer, entryPosition);
    }

    public long getHashCode(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        return this.getLongValue(entryPosition);
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        if (this.encryption == null) {
            return this.deserializeFromDirectMemory(this.keySerializer, entryPosition + 8);
        }
        int encryptedLength = this.getIntValue(entryPosition + 8);
        byte[] encryptedBinaryKey = this.getBinaryValue(entryPosition + 8 + 4, encryptedLength);
        byte[] decryptedBinaryKey = this.encryption.decrypt(encryptedBinaryKey);
        return this.keySerializer.deserializeNativeObject(decryptedBinaryKey, 0);
    }

    public int getIndex(long hashCode, K key) {
        return this.binarySearch(key, hashCode);
    }

    public int size() {
        return this.getIntValue(33);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator(0);
    }

    public Iterator<Entry<K, V>> iterator(int index) {
        return new EntryIterator(index);
    }

    public int mergedSize(OHashIndexBucket buddyBucket) {
        return 557 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28)) + buddyBucket.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28));
    }

    public int getContentSize() {
        return 557 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28));
    }

    public int updateEntry(int index, V value) throws IOException {
        int entryPosition = this.getIntValue(557 + index * 4);
        entryPosition += 8;
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        int newSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        int oldSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition);
        if (newSize != oldSize) {
            return -1;
        }
        byte[] newSerializedValue = new byte[newSize];
        this.valueSerializer.serializeNativeObject(value, newSerializedValue, 0, new Object[0]);
        byte[] oldSerializedValue = this.getBinaryValue(entryPosition, oldSize);
        if (ODefaultComparator.INSTANCE.compare(oldSerializedValue, newSerializedValue) == 0) {
            return 0;
        }
        this.setBinaryValue(entryPosition, newSerializedValue);
        return 1;
    }

    public Entry<K, V> deleteEntry(int index) throws IOException {
        int keySize;
        Entry<K, V> removedEntry = this.getEntry(index);
        int freePointer = this.getIntValue(28);
        int positionOffset = 557 + index * 4;
        int entryPosition = this.getIntValue(positionOffset);
        if (this.encryption == null) {
            keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition + 8);
        } else {
            int encryptedSize = this.getIntValue(entryPosition + 8);
            keySize = encryptedSize + 4;
        }
        int ridSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + keySize + 8);
        int entrySize = keySize + ridSize + 8;
        this.moveData(positionOffset + 4, positionOffset, this.size() * 4 - (index + 1) * 4);
        if (entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        int currentPositionOffset = 557;
        int size = this.size();
        for (int i = 0; i < size - 1; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.setIntValue(28, freePointer + entrySize);
        this.setIntValue(33, size - 1);
        return removedEntry;
    }

    public boolean addEntry(long hashCode, K key, V value) throws IOException {
        int entreeSize;
        byte[] encryptedKey = null;
        if (this.encryption == null) {
            entreeSize = this.keySerializer.getObjectSize(key, this.keyTypes) + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        } else {
            int keySize = this.keySerializer.getObjectSize(key, this.keyTypes);
            byte[] serializedKey = new byte[keySize];
            this.keySerializer.serializeNativeObject(key, serializedKey, 0, this.keyTypes);
            encryptedKey = this.encryption.encrypt(serializedKey);
            entreeSize = encryptedKey.length + 4 + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        }
        int freePointer = this.getIntValue(28);
        int size = this.size();
        if (freePointer - entreeSize < 557 + (size + 1) * 4) {
            return false;
        }
        int index = this.binarySearch(key, hashCode);
        if (index >= 0) {
            throw new IllegalArgumentException("Given value is present in bucket.");
        }
        int insertionPoint = -index - 1;
        this.insertEntry(hashCode, key, value, insertionPoint, entreeSize, encryptedKey);
        return true;
    }

    private void insertEntry(long hashCode, K key, V value, int insertionPoint, int entreeSize, byte[] encryptedKey) throws IOException {
        int freePointer = this.getIntValue(28);
        int size = this.size();
        int positionsOffset = insertionPoint * 4 + 557;
        this.moveData(positionsOffset, positionsOffset + 4, this.size() * 4 - insertionPoint * 4);
        int entreePosition = freePointer - entreeSize;
        this.setIntValue(positionsOffset, entreePosition);
        this.serializeEntry(hashCode, key, value, entreePosition, encryptedKey);
        this.setIntValue(28, entreePosition);
        this.setIntValue(33, size + 1);
    }

    public void appendEntry(long hashCode, K key, V value) throws IOException {
        int entreeSize;
        int positionsOffset = this.size() * 4 + 557;
        byte[] encryptedKey = null;
        if (this.encryption == null) {
            entreeSize = this.keySerializer.getObjectSize(key, this.keyTypes) + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        } else {
            int keySize = this.keySerializer.getObjectSize(key, this.keyTypes);
            byte[] serializedKey = new byte[keySize];
            this.keySerializer.serializeNativeObject(key, serializedKey, 0, this.keyTypes);
            encryptedKey = this.encryption.encrypt(serializedKey);
            entreeSize = 4 + encryptedKey.length + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        }
        int freePointer = this.getIntValue(28);
        int entreePosition = freePointer - entreeSize;
        this.setIntValue(positionsOffset, entreePosition);
        this.serializeEntry(hashCode, key, value, entreePosition, encryptedKey);
        this.setIntValue(28, freePointer - entreeSize);
        this.setIntValue(33, this.size() + 1);
    }

    private void serializeEntry(long hashCode, K key, V value, int entryOffset, byte[] encryptedKey) throws IOException {
        this.setLongValue(entryOffset, hashCode);
        entryOffset += 8;
        if (encryptedKey == null) {
            int keySize = this.keySerializer.getObjectSize(key, this.keyTypes);
            byte[] binaryKey = new byte[keySize];
            this.keySerializer.serializeNativeObject(key, binaryKey, 0, this.keyTypes);
            this.setBinaryValue(entryOffset, binaryKey);
            entryOffset += keySize;
        } else {
            this.setIntValue(entryOffset, encryptedKey.length);
            this.setBinaryValue(entryOffset += 4, encryptedKey);
            entryOffset += encryptedKey.length;
        }
        int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        byte[] binaryValue = new byte[valueSize];
        this.valueSerializer.serializeNativeObject(value, binaryValue, 0, new Object[0]);
        this.setBinaryValue(entryOffset, binaryValue);
    }

    public int getDepth() {
        return this.getByteValue(32);
    }

    public void setDepth(int depth) {
        this.setByteValue(32, (byte)depth);
    }

    public long getNextRemovedBucketPair() {
        return this.getLongValue(549);
    }

    public void setNextRemovedBucketPair(long nextRemovedBucketPair) throws IOException {
        this.setLongValue(549, nextRemovedBucketPair);
    }

    public long getSplitHistory(int level) {
        return this.getLongValue(37 + 8 * level);
    }

    public void setSplitHistory(int level, long position) throws IOException {
        this.setLongValue(37 + 8 * level, position);
    }

    private final class EntryIterator
    implements Iterator<Entry<K, V>> {
        private int currentIndex;

        private EntryIterator(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < OHashIndexBucket.this.size();
        }

        @Override
        public Entry<K, V> next() {
            if (this.currentIndex >= OHashIndexBucket.this.size()) {
                throw new NoSuchElementException("Iterator was reached last element");
            }
            Entry entry = OHashIndexBucket.this.getEntry(this.currentIndex);
            ++this.currentIndex;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }
    }

    public static class Entry<K, V> {
        public final K key;
        public final V value;
        public final long hashCode;

        public Entry(K key, V value, long hashCode) {
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }
    }
}

