/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import java.util.Map;
import java.util.NavigableMap;

public class ORidBagUpdateSerializationOperation
implements ORecordSerializationOperation {
    private final NavigableMap<OIdentifiable, Change> changedValues;
    private final OBonsaiCollectionPointer collectionPointer;
    private final OSBTreeCollectionManager collectionManager;

    public ORidBagUpdateSerializationOperation(NavigableMap<OIdentifiable, Change> changedValues, OBonsaiCollectionPointer collectionPointer) {
        this.changedValues = changedValues;
        this.collectionPointer = collectionPointer;
        this.collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OAbstractPaginatedStorage paginatedStorage) {
        if (this.changedValues.isEmpty()) {
            return;
        }
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree();
        try {
            for (Map.Entry entry : this.changedValues.entrySet()) {
                Integer storedCounter = tree.get((OIdentifiable)entry.getKey());
                storedCounter = ((Change)entry.getValue()).applyTo(storedCounter);
                if (storedCounter <= 0) {
                    tree.remove((OIdentifiable)entry.getKey());
                    continue;
                }
                tree.put((OIdentifiable)entry.getKey(), storedCounter);
            }
        }
        finally {
            this.releaseTree();
        }
        this.changedValues.clear();
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }
}

