/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.OEncryptionFactory;
import com.orientechnologies.orient.core.exception.OPaginatedClusterException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPageDebug;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterDebug;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterState;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class OPaginatedCluster
extends ODurableComponent
implements OCluster {
    private final boolean addRidMetadata = OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean();
    public static final String DEF_EXTENSION = ".pcl";
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private volatile OCompression compression;
    private volatile OEncryption encryption;
    private final boolean systemCluster;
    private OClusterPositionMap clusterPositionMap;
    private OAbstractPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private OStoragePaginatedClusterConfiguration config;
    private long pinnedStateEntryIndex;
    private ORecordConflictStrategy recordConflictStrategy;

    public OPaginatedCluster(String name, OAbstractPaginatedStorage storage) {
        super(storage, name, DEF_EXTENSION, name + DEF_EXTENSION);
        this.systemCluster = OMetadataInternal.SYSTEM_CLUSTER.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, int id, String clusterName, Object ... parameters) throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                OContextConfiguration ctxCfg = storage.getConfiguration().getContextConfiguration();
                String cfgCompression = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
                String cfgEncryption = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
                String cfgEncryptionKey = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
                this.config = new OStoragePaginatedClusterConfiguration((OStorageConfigurationImpl)storage.getConfiguration(), id, clusterName, null, true, 1.2f, 1.2f, cfgCompression, cfgEncryption, cfgEncryptionKey, null, OStorageClusterConfiguration.STATUS.ONLINE);
                this.config.name = clusterName;
                this.init((OAbstractPaginatedStorage)storage, this.config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.init((OAbstractPaginatedStorage)storage, config);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int startSize) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.initCusterState(atomicOperation);
                this.clusterPositionMap.create();
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OPaginatedClusterException("Error during creation of cluster with name " + this.getName(), this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void registerInStorageConfig(OStorageConfigurationImpl root) {
        root.addCluster(this.config);
        root.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = this.openFile(atomicOperation, this.getFullName());
                OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
                try {
                    this.pinPage(atomicOperation, pinnedStateEntry);
                    this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
                }
                finally {
                    this.releasePageFromRead(atomicOperation, pinnedStateEntry);
                }
                this.clusterPositionMap.open();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFile(File file) throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                long tempFileId;
                String tempFileName = file.getName() + "$temp";
                try {
                    tempFileId = this.writeCache.addFile(tempFileName);
                    this.writeCache.replaceFileContentWith(tempFileId, file.toPath());
                    this.readCache.deleteFile(this.fileId, this.writeCache);
                    this.writeCache.renameFile(tempFileId, this.getFullName());
                    this.fileId = tempFileId;
                }
                finally {
                    tempFileId = this.writeCache.fileIdByName(tempFileName);
                    if (tempFileId >= 0L) {
                        this.writeCache.deleteFile(tempFileId);
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceClusterMapFile(File file) throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                long tempFileId;
                String tempFileName = file.getName() + "$temp";
                try {
                    tempFileId = this.writeCache.addFile(tempFileName);
                    this.writeCache.replaceFileContentWith(tempFileId, file.toPath());
                    this.readCache.deleteFile(this.clusterPositionMap.getFileId(), this.writeCache);
                    this.writeCache.renameFile(tempFileId, this.clusterPositionMap.getFullName());
                    this.clusterPositionMap.replaceFileId(tempFileId);
                }
                finally {
                    tempFileId = this.writeCache.fileIdByName(tempFileName);
                    if (tempFileId >= 0L) {
                        this.writeCache.deleteFile(tempFileId);
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                if (flush) {
                    this.synch();
                }
                this.readCache.closeFile(this.fileId, flush, this.writeCache);
                this.clusterPositionMap.close(flush);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.clusterPositionMap.delete();
                this.endAtomicOperation(false, null);
            }
            catch (IOException ioe) {
                this.endAtomicOperation(true, ioe);
                throw ioe;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OPaginatedClusterException("Error during deletion of cluster " + this.getName(), this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        this.startOperation();
        try {
            if (attribute == null) {
                throw new IllegalArgumentException("attribute is null");
            }
            stringValue = value != null ? value.toString() : null;
            this.acquireExclusiveLock();
            try {
                switch (1.$SwitchMap$com$orientechnologies$orient$core$storage$OCluster$ATTRIBUTES[attribute.ordinal()]) {
                    case 1: {
                        this.setNameInternal(stringValue);
                        ** break;
lbl12:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.setRecordGrowFactorInternal(stringValue);
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.setRecordOverflowGrowFactorInternal(stringValue);
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        this.setRecordConflictStrategy(stringValue);
                        ** break;
lbl24:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        if (stringValue == null) {
                            throw new IllegalStateException("Value of attribute is null");
                        }
                        var4_4 = this.storageLocal.setClusterStatus(this.id, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase(this.storageLocal.getConfiguration().getLocaleInstance())));
                        return var4_4;
                    }
                    case 6: {
                        if (this.getEntries() > 0L) {
                            throw new IllegalArgumentException("Cannot change encryption setting on cluster '" + this.getName() + "' because it is not empty");
                        }
                        this.setEncryptionInternal(stringValue, ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY));
                        ** break;
lbl35:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Runtime change of attribute '" + (Object)attribute + " is not supported");
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
            var4_5 = null;
            return var4_5;
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public boolean isSystemCluster() {
        return this.systemCluster;
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String encryption() {
        this.acquireSharedLock();
        try {
            String string = this.config.encryption;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public OPhysicalPosition allocatePosition(byte recordType) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                OPhysicalPosition pos = this.createPhysicalPosition(recordType, this.clusterPositionMap.allocate(), -1);
                this.addAtomicOperationMetadata(new ORecordId(this.id, pos.clusterPosition), atomicOperation);
                this.endAtomicOperation(false, null);
                OPhysicalPosition oPhysicalPosition = pos;
                return oPhysicalPosition;
            }
            catch (IOException | RuntimeException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            finally {
                this.releaseExclusiveLock();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OPhysicalPosition createRecord(byte[] content, int recordVersion, byte recordType, OPhysicalPosition allocatedPosition) throws IOException {
        this.startOperation();
        statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startRecordCreationTimer();
        }
        content = this.compression.compress(content);
        content = this.encryption.encrypt(content);
        atomicOperation = this.startAtomicOperation(true);
        this.acquireExclusiveLock();
        entryContentLength = OPaginatedCluster.getEntryContentLength(content.length);
        if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
            try {
                entryContent = new byte[entryContentLength];
                entryPosition = 0;
                entryContent[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                entryContent[entryPosition += content.length] = 1;
                OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                this.updateClusterState(1L, AddEntryResult.access$000(addEntryResult), atomicOperation);
                if (allocatedPosition != null) {
                    this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(AddEntryResult.access$100(addEntryResult), AddEntryResult.access$200(addEntryResult)));
                    clusterPosition = allocatedPosition.clusterPosition;
                } else {
                    clusterPosition = this.clusterPositionMap.add(AddEntryResult.access$100(addEntryResult), AddEntryResult.access$200(addEntryResult));
                }
                this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                this.endAtomicOperation(false, null);
                var13_18 = this.createPhysicalPosition(recordType, clusterPosition, AddEntryResult.access$300(addEntryResult));
                return var13_18;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OPaginatedClusterException("Error during record creation", this), e);
            }
        }
        ** try [egrp 5[TRYBLOCK] [3 : 324->784)] { 
lbl-1000:
        // 1 sources

        {
            entrySize = content.length + 4 + 1;
            fullEntryPosition = 0;
            fullEntry = new byte[entrySize];
            fullEntry[fullEntryPosition] = recordType;
            OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
            System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
            prevPageRecordPointer = -1L;
            firstPageIndex = -1L;
            firstPagePosition = -1;
            version = 0;
            from = 0;
            to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
            recordsSizeDiff = 0;
            do {
                entryContent = new byte[to - from + 1 + 8];
                System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                entryContent[entryContent.length - 8 - 1] = from > 0 ? 0 : 1;
                OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                recordsSizeDiff += AddEntryResult.access$000(addEntryResult);
                if (firstPageIndex == -1L) {
                    firstPageIndex = AddEntryResult.access$100(addEntryResult);
                    firstPagePosition = AddEntryResult.access$200(addEntryResult);
                    version = AddEntryResult.access$300(addEntryResult);
                }
                addedPagePointer = OPaginatedCluster.createPagePointer(AddEntryResult.access$100(addEntryResult), AddEntryResult.access$200(addEntryResult));
                if (prevPageRecordPointer >= 0L) {
                    prevPageIndex = OPaginatedCluster.getPageIndex(prevPageRecordPointer);
                    prevPageRecordPosition = OPaginatedCluster.getRecordPosition(prevPageRecordPointer);
                    prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                    try {
                        prevPage = new OClusterPage(prevPageCacheEntry, false);
                        prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                    }
                }
                prevPageRecordPointer = addedPagePointer;
                from = to;
                if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                to = fullEntry.length;
            } while (from < to);
            this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
            if (allocatedPosition != null) {
                this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(firstPageIndex, firstPagePosition));
                clusterPosition = allocatedPosition.clusterPosition;
            } else {
                clusterPosition = this.clusterPositionMap.add(firstPageIndex, firstPagePosition);
            }
            this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
            this.endAtomicOperation(false, null);
            var22_29 = this.createPhysicalPosition(recordType, clusterPosition, version);
            return var22_29;
        }
lbl88:
        // 1 sources

        catch (RuntimeException e) {
            this.endAtomicOperation(true, e);
            throw OException.wrapException(new OPaginatedClusterException("Error during record creation", this), e);
        }
        {
            finally {
                this.releaseExclusiveLock();
            }
        }
        {
            catch (Throwable var31_36) {
                throw var31_36;
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopRecordCreationTimer();
            }
            this.completeOperation();
        }
    }

    private void addAtomicOperationMetadata(ORID rid, OAtomicOperation atomicOperation) {
        if (!this.addRidMetadata) {
            return;
        }
        if (atomicOperation == null) {
            return;
        }
        ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicOperation.getMetadata("cluster.record.rid");
        if (recordOperationMetadata == null) {
            recordOperationMetadata = new ORecordOperationMetadata();
            atomicOperation.addMetadata(recordOperationMetadata);
        }
        recordOperationMetadata.addRid(rid);
    }

    private static int getEntryContentLength(int grownContentSize) {
        int entryContentLength = grownContentSize + 2 + 4 + 8;
        return entryContentLength;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public ORawBuffer readRecord(long clusterPosition, boolean prefetchRecords) throws IOException {
        int pagesToPrefetch = 1;
        if (prefetchRecords) {
            pagesToPrefetch = OGlobalConfiguration.QUERY_SCAN_PREFETCH_PAGES.getValueAsInteger();
        }
        return this.readRecord(clusterPosition, pagesToPrefetch);
    }

    /*
     * Exception decompiling
     */
    private ORawBuffer readRecord(long clusterPosition, int pageCount) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer internalReadRecord(long clusterPosition, long pageIndex, int recordPosition, int pageCount) throws IOException {
        int recordVersion;
        OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            return null;
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, false);
            if (localPage.isDeleted(recordPosition)) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            recordVersion = localPage.getRecordVersion(recordPosition);
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
        byte[] fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation, pageCount);
        if (fullContent == null) {
            return null;
        }
        int fullContentPosition = 0;
        byte recordType = fullContent[fullContentPosition];
        int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
        byte[] recordContent = Arrays.copyOfRange(fullContent, fullContentPosition += 4, fullContentPosition + readContentSize);
        recordContent = this.encryption.decrypt(recordContent);
        recordContent = this.compression.uncompress(recordContent);
        return new ORawBuffer(recordContent, recordVersion, recordType);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ORawBuffer readRecordIfVersionIsNotLatest(long clusterPosition, int recordVersion) throws IOException, ORecordNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteRecord(long clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 26[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hideRecord(long position) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(position, 1);
                if (positionEntry == null) {
                    this.endAtomicOperation(false, null);
                    boolean bl = false;
                    return bl;
                }
                long pageIndex = positionEntry.getPageIndex();
                if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
                    this.endAtomicOperation(false, null);
                    boolean bl = false;
                    return bl;
                }
                this.updateClusterState(-1L, 0L, atomicOperation);
                this.clusterPositionMap.remove(position);
                this.addAtomicOperationMetadata(new ORecordId(this.id, position), atomicOperation);
                this.endAtomicOperation(false, null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        this.startOperation();
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startRecordUpdateTimer();
        }
        try {
            content = this.compression.compress(content);
            content = this.encryption.encrypt(content);
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                int to;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1);
                if (positionEntry == null) {
                    this.endAtomicOperation(false, null);
                    return;
                }
                int nextRecordPosition = positionEntry.getRecordPosition();
                long nextPageIndex = positionEntry.getPageIndex();
                int newRecordPosition = -1;
                long newPageIndex = -1L;
                long prevPageIndex = -1L;
                int prevRecordPosition = -1;
                long nextEntryPointer = -1L;
                int from = 0;
                long sizeDiff = 0L;
                byte[] updateEntry = null;
                do {
                    int updatedEntryPosition;
                    int entrySize;
                    if (updateEntry == null) {
                        if (from == 0) {
                            entrySize = Math.min(OPaginatedCluster.getEntryContentLength(content.length), OClusterPage.MAX_RECORD_SIZE);
                            to = entrySize - 14;
                        } else {
                            entrySize = Math.min(content.length - from + 1 + 8, OClusterPage.MAX_RECORD_SIZE);
                            to = from + entrySize - 9;
                        }
                        updateEntry = new byte[entrySize];
                        int entryPosition = 0;
                        if (from == 0) {
                            updateEntry[entryPosition] = recordType;
                            OIntegerSerializer.INSTANCE.serializeNative(content.length, updateEntry, ++entryPosition, new Object[0]);
                            entryPosition += 4;
                        }
                        System.arraycopy(content, from, updateEntry, entryPosition, to - from);
                        entryPosition += to - from;
                        if (nextPageIndex == positionEntry.getPageIndex()) {
                            updateEntry[entryPosition] = 1;
                        }
                        OLongSerializer.INSTANCE.serializeNative(-1L, updateEntry, ++entryPosition, new Object[0]);
                        if (to < content.length) assert (entrySize == OClusterPage.MAX_RECORD_SIZE);
                    } else {
                        entrySize = updateEntry.length;
                        to = from == 0 ? entrySize - 14 : from + entrySize - 9;
                    }
                    int freePageIndex = -1;
                    if (nextPageIndex < 0L) {
                        FindFreePageResult findFreePageResult = this.findFreePage(entrySize, atomicOperation);
                        nextPageIndex = findFreePageResult.pageIndex;
                        freePageIndex = findFreePageResult.freePageIndex;
                    }
                    boolean isNew = false;
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    if (cacheEntry == null) {
                        cacheEntry = this.addPage(atomicOperation, this.fileId);
                        isNew = true;
                    }
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, isNew);
                        int pageFreeSpace = localPage.getFreeSpace();
                        if (freePageIndex < 0) {
                            freePageIndex = this.calculateFreePageIndex(localPage);
                        } else assert (isNew || freePageIndex == this.calculateFreePageIndex(localPage));
                        if (nextRecordPosition >= 0) {
                            if (localPage.isDeleted(nextRecordPosition)) {
                                throw new OPaginatedClusterException("Record with rid " + new ORecordId(this.id, clusterPosition) + " was deleted", this);
                            }
                            int currentEntrySize = localPage.getRecordSize(nextRecordPosition);
                            nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, currentEntrySize - 8);
                            if (currentEntrySize == entrySize) {
                                localPage.replaceRecord(nextRecordPosition, updateEntry, recordVersion);
                                updatedEntryPosition = nextRecordPosition;
                            } else {
                                localPage.deleteRecord(nextRecordPosition);
                                if (localPage.getMaxRecordSize() >= entrySize) {
                                    updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry);
                                    if (updatedEntryPosition < 0) {
                                        localPage.dumpToLog();
                                        throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", updateEntry.length=" + updateEntry.length + ", content.length=" + content.length);
                                    }
                                } else {
                                    updatedEntryPosition = -1;
                                }
                            }
                            if (nextEntryPointer >= 0L) {
                                nextRecordPosition = OPaginatedCluster.getRecordPosition(nextEntryPointer);
                                nextPageIndex = OPaginatedCluster.getPageIndex(nextEntryPointer);
                            } else {
                                nextPageIndex = -1L;
                                nextRecordPosition = -1;
                            }
                        } else {
                            assert (localPage.getFreeSpace() >= entrySize);
                            updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry);
                            if (updatedEntryPosition < 0) {
                                localPage.dumpToLog();
                                throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", updateEntry.length=" + updateEntry.length + ", content.length=" + content.length);
                            }
                            nextPageIndex = -1L;
                            nextRecordPosition = -1;
                        }
                        sizeDiff += (long)(pageFreeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePageIndex, cacheEntry.getPageIndex(), atomicOperation);
                    if (updatedEntryPosition < 0) continue;
                    if (from == 0) {
                        newPageIndex = cacheEntry.getPageIndex();
                        newRecordPosition = updatedEntryPosition;
                    }
                    from = to;
                    if (prevPageIndex >= 0L) {
                        OCacheEntry prevCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                        try {
                            OClusterPage prevPage = new OClusterPage(prevCacheEntry, false);
                            prevPage.setRecordLongValue(prevRecordPosition, -8, OPaginatedCluster.createPagePointer(cacheEntry.getPageIndex(), updatedEntryPosition));
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, prevCacheEntry);
                        }
                    }
                    prevPageIndex = cacheEntry.getPageIndex();
                    prevRecordPosition = updatedEntryPosition;
                    updateEntry = null;
                } while (to < content.length || updateEntry != null);
                while (nextEntryPointer >= 0L) {
                    int freePagesIndex;
                    nextPageIndex = OPaginatedCluster.getPageIndex(nextEntryPointer);
                    nextRecordPosition = OPaginatedCluster.getRecordPosition(nextEntryPointer);
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, false);
                        int freeSpace = localPage.getFreeSpace();
                        freePagesIndex = this.calculateFreePageIndex(localPage);
                        nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, -8);
                        localPage.deleteRecord(nextRecordPosition);
                        sizeDiff += (long)(freeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePagesIndex, nextPageIndex, atomicOperation);
                }
                assert (newPageIndex >= 0L);
                assert (newRecordPosition >= 0);
                if (newPageIndex != positionEntry.getPageIndex() || newRecordPosition != positionEntry.getRecordPosition()) {
                    this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(newPageIndex, newRecordPosition));
                }
                this.updateClusterState(0L, sizeDiff, atomicOperation);
                this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (RuntimeException e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OPaginatedClusterException("Error during record update", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            if (statistic != null) {
                statistic.stopRecordUpdateTimer();
            }
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        block24: {
            this.startOperation();
            OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startRecordUpdateTimer();
            }
            try {
                OAtomicOperation atomicOperation = this.startAtomicOperation(true);
                this.acquireExclusiveLock();
                try {
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1);
                    if (positionEntry != null) {
                        throw new OPaginatedClusterException("Record with rid " + new ORecordId(this.id, clusterPosition) + " was not deleted", this);
                    }
                    content = this.compression.compress(content);
                    int entryContentLength = OPaginatedCluster.getEntryContentLength((content = this.encryption.encrypt(content)).length);
                    if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
                        try {
                            byte[] entryContent = new byte[entryContentLength];
                            int entryPosition = 0;
                            entryContent[entryPosition] = recordType;
                            OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                            System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                            entryContent[entryPosition += content.length] = 1;
                            OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                            AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                            this.updateClusterState(1L, addEntryResult.recordsSizeDiff, atomicOperation);
                            this.clusterPositionMap.resurrect(clusterPosition, new OClusterPositionMapBucket.PositionEntry(addEntryResult.pageIndex, addEntryResult.pagePosition));
                            this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                            this.endAtomicOperation(false, null);
                            break block24;
                        }
                        catch (Exception e) {
                            throw OException.wrapException(new OPaginatedClusterException("Error during record recycling", this), e);
                        }
                    }
                    try {
                        int entrySize = content.length + 4 + 1;
                        int fullEntryPosition = 0;
                        byte[] fullEntry = new byte[entrySize];
                        fullEntry[fullEntryPosition] = recordType;
                        OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
                        System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
                        long prevPageRecordPointer = -1L;
                        long firstPageIndex = -1L;
                        int firstPagePosition = -1;
                        int from = 0;
                        int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                        int recordsSizeDiff = 0;
                        do {
                            byte[] entryContent = new byte[to - from + 1 + 8];
                            System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                            entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                            OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                            AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                            recordsSizeDiff += addEntryResult.recordsSizeDiff;
                            if (firstPageIndex == -1L) {
                                firstPageIndex = addEntryResult.pageIndex;
                                firstPagePosition = addEntryResult.pagePosition;
                            }
                            long addedPagePointer = OPaginatedCluster.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                            if (prevPageRecordPointer >= 0L) {
                                long prevPageIndex = OPaginatedCluster.getPageIndex(prevPageRecordPointer);
                                int prevPageRecordPosition = OPaginatedCluster.getRecordPosition(prevPageRecordPointer);
                                OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                                try {
                                    OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false);
                                    prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                                }
                                finally {
                                    this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                                }
                            }
                            prevPageRecordPointer = addedPagePointer;
                            from = to;
                            if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                            to = fullEntry.length;
                        } while (from < to);
                        this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
                        this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(firstPageIndex, firstPagePosition));
                        this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                        this.endAtomicOperation(false, null);
                    }
                    catch (RuntimeException e) {
                        if (e instanceof OPaginatedClusterException) {
                            throw e;
                        }
                        throw OException.wrapException(new OPaginatedClusterException("Error during record recycling", this), e);
                    }
                }
                catch (RuntimeException e) {
                    this.endAtomicOperation(true, e);
                    if (e instanceof OPaginatedClusterException) {
                        throw e;
                    }
                    throw OException.wrapException(new OPaginatedClusterException("Error during record recycling", this), e);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            finally {
                if (statistic != null) {
                    statistic.stopRecordUpdateTimer();
                }
                this.completeOperation();
            }
        }
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                this.truncateFile(atomicOperation, this.fileId);
                this.clusterPositionMap.truncate();
                this.initCusterState(atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OPaginatedClusterException("Error during cluster truncate", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isDeleted(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getFirstPosition() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getLastPosition() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getNextPosition() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getFileName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    public void synch() throws IOException {
        this.startOperation();
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    this.writeCache.flush(this.fileId);
                    this.clusterPositionMap.flush();
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getRecordsSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OClusterEntryIterator oClusterEntryIterator;
            this.acquireSharedLock();
            try {
                oClusterEntryIterator = new OClusterEntryIterator(this);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oClusterEntryIterator;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    private void setRecordConflictStrategy(String stringValue) {
        this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(stringValue);
        this.config.conflictStrategy = stringValue;
        ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(long sizeDiff, long recordsSizeDiff, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry);
            paginatedClusterState.setSize(paginatedClusterState.getSize() + sizeDiff);
            paginatedClusterState.setRecordsSize(paginatedClusterState.getRecordsSize() + recordsSizeDiff);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private void init(OAbstractPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName(config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression, null);
        this.encryption = OEncryptionFactory.INSTANCE.getEncryption(this.config.encryption, this.config.encryptionKey);
        if (((OStoragePaginatedClusterConfiguration)config).conflictStrategy != null) {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(((OStoragePaginatedClusterConfiguration)config).conflictStrategy);
        }
        this.storageLocal = storage;
        this.id = config.getId();
        this.clusterPositionMap = new OClusterPositionMap(storage, this.getName(), this.getFullName());
    }

    private void setEncryptionInternal(String iMethod, String iKey) {
        try {
            this.encryption = OEncryptionFactory.INSTANCE.getEncryption(iMethod, iKey);
            this.config.encryption = iMethod;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (IllegalArgumentException e) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.ENCRYPTION) + " attribute", this), e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OPaginatedClusterException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " cannot be less than 1", this);
            }
            this.config.recordOverflowGrowFactor = growFactor;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (NumberFormatException nfe) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "]", this), nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OPaginatedClusterException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " cannot be less than 1", this);
            }
            this.config.recordGrowFactor = growFactor;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (NumberFormatException nfe) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "]", this), nfe);
        }
    }

    private void setNameInternal(String newName) throws IOException {
        this.writeCache.renameFile(this.fileId, newName + this.getExtension());
        this.clusterPositionMap.rename(newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.getName(), newName);
        this.setName(newName);
        ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
    }

    private OPhysicalPosition createPhysicalPosition(byte recordType, long clusterPosition, int version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private byte[] readFullEntry(long clusterPosition, long pageIndex, int recordPosition, OAtomicOperation atomicOperation, int pageCount) throws IOException {
        byte[] fullContent;
        long nextPagePointer;
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedCluster.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedCluster.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    private static long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    private static int getRecordPosition(long nextPagePointer) {
        return (int)(nextPagePointer & 0xFFFFL);
    }

    private static long getPageIndex(long nextPagePointer) {
        return nextPagePointer >>> 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(int recordVersion, byte[] entryContent, OAtomicOperation atomicOperation) throws IOException {
        int recordSizesDiff;
        int finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, atomicOperation);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= FREE_LIST_SIZE;
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
        if (cacheEntry == null) {
            cacheEntry = this.addPage(atomicOperation, this.fileId);
        }
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, newRecord);
            assert (newRecord || freePageIndex == this.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent);
            if (position < 0) {
                localPage.dumpToLog();
                throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", entryContent.length=" + entryContent.length);
            }
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex;
        int freePageIndex;
        while (true) {
            int realFreePageIndex;
            OCacheEntry pinnedStateEntry;
            freePageIndex = contentSize / 1024;
            if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                freePageIndex = 0;
            }
            if ((pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true)) == null) {
                this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
            }
            try {
                OPaginatedClusterState freePageLists = new OPaginatedClusterState(pinnedStateEntry);
                while ((pageIndex = freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
                }
            }
            finally {
                this.releasePageFromRead(atomicOperation, pinnedStateEntry);
            }
            if (pageIndex < 0L) {
                pageIndex = this.getFilledUpTo(atomicOperation, this.fileId);
            } else {
                --freePageIndex;
            }
            if (freePageIndex >= FREE_LIST_SIZE) break;
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
            if (cacheEntry == null) {
                this.updateFreePagesList(freePageIndex, -1L, atomicOperation);
                continue;
            }
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                realFreePageIndex = this.calculateFreePageIndex(localPage);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            if (realFreePageIndex == freePageIndex) break;
            OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically", this.getFullName(), pageIndex);
            this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        }
        return new FindFreePageResult(pageIndex, freePageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        block29: {
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
            try {
                long oldFreePage;
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                int newFreePageIndex = this.calculateFreePageIndex(localPage);
                if (prevFreePageIndex == newFreePageIndex) {
                    return;
                }
                long nextPageIndex = localPage.getNextPage();
                long prevPageIndex = localPage.getPrevPage();
                if (prevPageIndex >= 0L) {
                    OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false);
                        assert (this.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                        prevPage.setNextPage(nextPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                    }
                }
                if (nextPageIndex >= 0L) {
                    OCacheEntry nextPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    try {
                        OClusterPage nextPage = new OClusterPage(nextPageCacheEntry, false);
                        if (this.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                            this.calculateFreePageIndex(nextPage);
                        }
                        assert (this.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                        nextPage.setPrevPage(prevPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nextPageCacheEntry);
                    }
                }
                localPage.setNextPage(-1L);
                localPage.setPrevPage(-1L);
                if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                    return;
                }
                if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                    this.updateFreePagesList(prevFreePageIndex, nextPageIndex, atomicOperation);
                }
                if (newFreePageIndex < 0) break block29;
                OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
                try {
                    OPaginatedClusterState clusterFreeList = new OPaginatedClusterState(pinnedStateEntry);
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    this.releasePageFromRead(atomicOperation, pinnedStateEntry);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, oldFreePage, false);
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry, false);
                        assert (this.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, oldFreePageCacheEntry);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex, atomicOperation);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry);
            paginatedClusterState.setFreeListPage(freeListIndex, pageIndex);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(pinnedStateEntry);
            this.pinPage(atomicOperation, pinnedStateEntry);
            paginatedClusterState.setSize(0L);
            paginatedClusterState.setRecordsSize(0L);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1L);
            }
            this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private OPhysicalPosition[] convertToPhysicalPositions(long[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    @Override
    protected void startOperation() {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startComponentOperation(this.getFullName(), OSessionStoragePerformanceStatistic.ComponentType.CLUSTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPaginatedClusterDebug readDebug(long clusterPosition) throws IOException {
        this.startOperation();
        try {
            long nextPagePointer;
            OPaginatedClusterDebug debug = new OPaginatedClusterDebug();
            debug.clusterPosition = clusterPosition;
            debug.fileId = this.fileId;
            OAtomicOperation atomicOperation = this.storageLocal.getAtomicOperationsManager().getCurrentOperation();
            OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1);
            if (positionEntry == null) {
                debug.empty = true;
                OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                return oPaginatedClusterDebug;
            }
            long pageIndex = positionEntry.getPageIndex();
            int recordPosition = positionEntry.getRecordPosition();
            if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
                debug.empty = true;
                OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                return oPaginatedClusterDebug;
            }
            debug.pages = new ArrayList<OClusterPageDebug>();
            int contentSize = 0;
            boolean firstEntry = true;
            do {
                OClusterPageDebug debugPage = new OClusterPageDebug();
                debugPage.pageIndex = pageIndex;
                OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
                try {
                    OClusterPage localPage = new OClusterPage(cacheEntry, false);
                    if (localPage.isDeleted(recordPosition)) {
                        if (!debug.pages.isEmpty()) throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                        debug.empty = true;
                        OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                        return oPaginatedClusterDebug;
                    }
                    debugPage.inPagePosition = recordPosition;
                    debugPage.inPageSize = localPage.getRecordSize(recordPosition);
                    byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, debugPage.inPageSize);
                    debugPage.content = content;
                    if (firstEntry && content[content.length - 8 - 1] == 0) {
                        debug.empty = true;
                        OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                        return oPaginatedClusterDebug;
                    }
                    debug.pages.add(debugPage);
                    nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                    contentSize += content.length - 8 - 1;
                    firstEntry = false;
                }
                finally {
                    this.releasePageFromRead(atomicOperation, cacheEntry);
                }
                pageIndex = OPaginatedCluster.getPageIndex(nextPagePointer);
                recordPosition = OPaginatedCluster.getRecordPosition(nextPagePointer);
            } while (nextPagePointer >= 0L);
            debug.contentSize = contentSize;
            OPaginatedClusterDebug oPaginatedClusterDebug = debug;
            return oPaginatedClusterDebug;
        }
        finally {
            this.completeOperation();
        }
    }

    public RECORD_STATUS getRecordStatus(long clusterPosition) throws IOException {
        byte status = this.clusterPositionMap.getStatus(clusterPosition);
        switch (status) {
            case 0: {
                return RECORD_STATUS.NOT_EXISTENT;
            }
            case 4: {
                return RECORD_STATUS.ALLOCATED;
            }
            case 2: {
                return RECORD_STATUS.PRESENT;
            }
            case 1: {
                return RECORD_STATUS.REMOVED;
            }
        }
        return null;
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    public String toString() {
        return "plocal cluster: " + this.getName();
    }

    /*
     * Exception decompiling
     */
    @Override
    public OClusterBrowsePage nextPage(long lastPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final int recordVersion;
        private final int recordsSizeDiff;

        public AddEntryResult(long pageIndex, int pagePosition, int recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }

        static /* synthetic */ int access$300(AddEntryResult x0) {
            return x0.recordVersion;
        }
    }

    public static enum RECORD_STATUS {
        NOT_EXISTENT,
        PRESENT,
        ALLOCATED,
        REMOVED;

    }
}

