/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OStorageConfigurationSegment
extends OStorageConfigurationImpl {
    private static final String NAME = "database.ocf";
    private static final String BACKUP_NAME = "database.ocf2";
    private static final long ENCODING_FLAG_1 = 128975354756545L;
    private static final long ENCODING_FLAG_2 = 587138568122547L;
    private static final long ENCODING_FLAG_3 = 812587836547249L;
    private static final int CRC_32_OFFSET = 100;
    private static final byte FORMAT_VERSION = 42;
    private final String storageName;
    private final Path storagePath;

    public OStorageConfigurationSegment(OLocalPaginatedStorage storage) {
        super(storage, Charset.forName("UTF-8"));
        this.storageName = storage.getName();
        this.storagePath = storage.getStoragePath();
    }

    @Override
    public void delete() throws IOException {
        this.lock.acquireWriteLock();
        try {
            super.delete();
            this.clearConfigurationFiles();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void clearConfigurationFiles() throws IOException {
        Path file = this.storagePath.resolve(NAME);
        Files.deleteIfExists(file);
        Path backupFile = this.storagePath.resolve(BACKUP_NAME);
        Files.deleteIfExists(backupFile);
    }

    @Override
    public void create() throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.clearConfigurationFiles();
            super.create();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OStorageConfigurationImpl load(OContextConfiguration configuration) throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            this.initConfiguration(configuration);
            Path file = this.storagePath.resolve(NAME);
            Path backupFile = this.storagePath.resolve(BACKUP_NAME);
            if (Files.exists(file, new LinkOption[0])) {
                if (this.readData(file)) {
                    OStorageConfigurationSegment oStorageConfigurationSegment = this;
                    return oStorageConfigurationSegment;
                }
                OLogManager.instance().warnNoDb(this, "Main storage configuration file %s is broken in storage %s, try to read from backup file %s", file, this.storageName, backupFile);
                if (Files.exists(backupFile, new LinkOption[0])) {
                    if (this.readData(backupFile)) {
                        OStorageConfigurationSegment oStorageConfigurationSegment = this;
                        return oStorageConfigurationSegment;
                    }
                    OLogManager.instance().errorNoDb(this, "Backup configuration file %s is broken too", null, new Object[0]);
                    throw new OStorageException("Invalid format for configuration file " + file + " for storage" + this.storageName);
                }
                OLogManager.instance().errorNoDb(this, "Backup configuration file %s does not exist", null, backupFile);
                throw new OStorageException("Invalid format for configuration file " + file + " for storage" + this.storageName);
            }
            if (!Files.exists(backupFile, new LinkOption[0])) throw new OStorageException("Can not find configuration file for storage " + this.storageName);
            OLogManager.instance().warn((Object)this, "Seems like previous update to the storage '%s' configuration was finished incorrectly, main configuration file %s is absent, reading from backup", backupFile, file);
            if (this.readData(backupFile)) {
                OStorageConfigurationSegment oStorageConfigurationSegment = this;
                return oStorageConfigurationSegment;
            }
            try {
                OLogManager.instance().errorNoDb(this, "Backup configuration file %s is broken", null, backupFile);
                throw new OStorageException("Invalid format for configuration file " + backupFile + " for storage" + this.storageName);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSerializationException("Cannot load database configuration. The database seems corrupted"), e);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            Charset utf8 = Charset.forName("UTF-8");
            byte[] buffer = this.toStream(utf8);
            ByteBuffer byteBuffer = ByteBuffer.allocate(buffer.length + 4);
            byteBuffer.putInt(buffer.length);
            byteBuffer.put(buffer);
            try {
                if (!Files.exists(this.storagePath, new LinkOption[0])) {
                    Files.createDirectories(this.storagePath, new FileAttribute[0]);
                }
                Path backupFile = this.storagePath.resolve(BACKUP_NAME);
                Files.deleteIfExists(backupFile);
                try (FileChannel channel = FileChannel.open(backupFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
                    this.writeConfigFile(buffer, byteBuffer, channel);
                }
                Path file = this.storagePath.resolve(NAME);
                Files.deleteIfExists(file);
                try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
                    this.writeConfigFile(buffer, byteBuffer, channel);
                }
                Files.delete(backupFile);
            }
            catch (Exception e) {
                throw OException.wrapException(new OSerializationException("Error on update storage configuration"), e);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void writeConfigFile(byte[] buffer, ByteBuffer byteBuffer, FileChannel channel) throws IOException {
        ByteBuffer versionBuffer = ByteBuffer.allocate(1);
        versionBuffer.put((byte)42);
        versionBuffer.position(0);
        OIOUtils.writeByteBuffer(versionBuffer, channel, 48L);
        ByteBuffer crc32buffer = ByteBuffer.allocate(4);
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        crc32buffer.putInt((int)crc32.getValue());
        crc32buffer.position(0);
        OIOUtils.writeByteBuffer(crc32buffer, channel, 100L);
        channel.force(true);
        byteBuffer.position(0);
        OIOUtils.writeByteBuffer(byteBuffer, channel, 1024L);
        channel.force(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readData(Path file) throws IOException {
        ByteBuffer byteBuffer;
        int crc32content;
        byte fileVersion;
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
            if (channel.size() < 1029L) {
                boolean bl = false;
                return bl;
            }
            ByteBuffer versionBuffer = ByteBuffer.allocate(1);
            OIOUtils.readByteBuffer(versionBuffer, channel, 48L, true);
            versionBuffer.position(0);
            fileVersion = versionBuffer.get();
            if (fileVersion >= 42) {
                ByteBuffer crc32buffer = ByteBuffer.allocate(4);
                OIOUtils.readByteBuffer(crc32buffer, channel, 100L, true);
                crc32buffer.position(0);
                crc32content = crc32buffer.getInt();
            } else {
                crc32content = 0;
            }
            byteBuffer = ByteBuffer.allocate((int)channel.size() - 1024);
            OIOUtils.readByteBuffer(byteBuffer, channel, 1024L, true);
        }
        byteBuffer.position(0);
        int size = byteBuffer.getInt();
        byte[] buffer = new byte[size];
        byteBuffer.get(buffer);
        if (fileVersion < 42) {
            if (byteBuffer.limit() >= size + 8 + 24) {
                long encodingFagOne = byteBuffer.getLong();
                long encodingFagTwo = byteBuffer.getLong();
                long encodingFagThree = byteBuffer.getLong();
                if (encodingFagOne == 128975354756545L && encodingFagTwo == 587138568122547L && encodingFagThree == 812587836547249L) {
                    byte[] utf8Encoded = "UTF-8".getBytes(Charset.forName("UTF-8"));
                    int encodingNameLength = byteBuffer.getInt();
                    if (encodingNameLength != utf8Encoded.length) return false;
                    byte[] binaryEncodingName = new byte[encodingNameLength];
                    byteBuffer.get(binaryEncodingName);
                    String encodingName = new String(binaryEncodingName, "UTF-8");
                    if (!encodingName.equals("UTF-8")) {
                        return false;
                    }
                    Charset streamEncoding = Charset.forName("UTF-8");
                    try {
                        this.fromStream(buffer, 0, buffer.length, streamEncoding);
                        return true;
                    }
                    catch (Exception e) {
                        OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                        return false;
                    }
                } else {
                    try {
                        this.fromStream(buffer, 0, buffer.length, Charset.defaultCharset());
                        return true;
                    }
                    catch (Exception e) {
                        OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                        return false;
                    }
                }
            } else {
                try {
                    this.fromStream(buffer, 0, buffer.length, Charset.defaultCharset());
                    return true;
                }
                catch (Exception e) {
                    OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                    return false;
                }
            }
        }
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        if (crc32content != (int)crc32.getValue()) {
            return false;
        }
        try {
            this.fromStream(buffer, 0, buffer.length, Charset.forName("UTF-8"));
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
            return false;
        }
    }
}

