/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlanner;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OUpdateStatement
extends OStatement {
    public OFromClause target;
    protected List<OUpdateOperations> operations = new ArrayList<OUpdateOperations>();
    protected boolean upsert = false;
    protected boolean returnBefore = false;
    protected boolean returnAfter = false;
    protected boolean returnCount = false;
    protected OProjection returnProjection;
    public OWhereClause whereClause;
    public OStorage.LOCKING_STRATEGY lockRecord = null;
    public OLimit limit;
    public OTimeout timeout;

    public OUpdateStatement(int id) {
        super(id);
    }

    public OUpdateStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(this.getStatementType());
        if (this.target != null) {
            this.target.toString(params, builder);
        }
        for (OUpdateOperations ops : this.operations) {
            builder.append(" ");
            ops.toString(params, builder);
        }
        if (this.upsert) {
            builder.append(" UPSERT");
        }
        if (this.returnBefore || this.returnAfter || this.returnCount) {
            builder.append(" RETURN");
            if (this.returnBefore) {
                builder.append(" BEFORE");
            } else if (this.returnAfter) {
                builder.append(" AFTER");
            } else {
                builder.append(" COUNT");
            }
            if (this.returnProjection != null) {
                builder.append(" ");
                this.returnProjection.toString(params, builder);
            }
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.lockRecord != null) {
            builder.append(" LOCK ");
            switch (this.lockRecord) {
                case DEFAULT: {
                    builder.append("DEFAULT");
                    break;
                }
                case EXCLUSIVE_LOCK: {
                    builder.append("RECORD");
                    break;
                }
                case SHARED_LOCK: {
                    builder.append("SHARED");
                    break;
                }
                case NONE: {
                    builder.append("NONE");
                }
            }
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.timeout != null) {
            this.timeout.toString(params, builder);
        }
    }

    protected String getStatementType() {
        return "UPDATE ";
    }

    @Override
    public OUpdateStatement copy() {
        OUpdateStatement result = null;
        try {
            result = (OUpdateStatement)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.target = this.target == null ? null : this.target.copy();
        result.operations = this.operations == null ? null : this.operations.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.upsert = this.upsert;
        result.returnBefore = this.returnBefore;
        result.returnAfter = this.returnAfter;
        result.returnProjection = this.returnProjection == null ? null : this.returnProjection.copy();
        result.whereClause = this.whereClause == null ? null : this.whereClause.copy();
        result.lockRecord = this.lockRecord;
        result.limit = this.limit == null ? null : this.limit.copy();
        result.timeout = this.timeout == null ? null : this.timeout.copy();
        return result;
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OUpdateExecutionPlanner planner = new OUpdateExecutionPlanner(this);
        OUpdateExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUpdateStatement that = (OUpdateStatement)o;
        if (this.upsert != that.upsert) {
            return false;
        }
        if (this.returnBefore != that.returnBefore) {
            return false;
        }
        if (this.returnAfter != that.returnAfter) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.operations != null ? !this.operations.equals(that.operations) : that.operations != null) {
            return false;
        }
        if (this.returnProjection != null ? !this.returnProjection.equals(that.returnProjection) : that.returnProjection != null) {
            return false;
        }
        if (this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null) {
            return false;
        }
        if (this.lockRecord != that.lockRecord) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return !(this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.operations != null ? this.operations.hashCode() : 0);
        result = 31 * result + (this.upsert ? 1 : 0);
        result = 31 * result + (this.returnBefore ? 1 : 0);
        result = 31 * result + (this.returnAfter ? 1 : 0);
        result = 31 * result + (this.returnProjection != null ? this.returnProjection.hashCode() : 0);
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.lockRecord != null ? this.lockRecord.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        return result;
    }

    public OFromClause getTarget() {
        return this.target;
    }

    public List<OUpdateOperations> getOperations() {
        return this.operations;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isReturnBefore() {
        return this.returnBefore;
    }

    public boolean isReturnAfter() {
        return this.returnAfter;
    }

    public boolean isReturnCount() {
        return this.returnCount;
    }

    public OProjection getReturnProjection() {
        return this.returnProjection;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public OStorage.LOCKING_STRATEGY getLockRecord() {
        return this.lockRecord;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public OTimeout getTimeout() {
        return this.timeout;
    }
}

