/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class OTruncateClassStatement
extends ODDLStatement {
    protected OIdentifier className;
    protected boolean polymorphic = false;
    protected boolean unsafe = false;

    public OTruncateClassStatement(int id) {
        super(id);
    }

    public OTruncateClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        ODatabase db = ctx.getDatabase();
        OSchema schema = db.getMetadata().getSchema();
        OClass clazz = schema.getClass(this.className.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Schema Class not found: " + this.className);
        }
        long recs = clazz.count(this.polymorphic);
        if (recs > 0L && !this.unsafe) {
            if (clazz.isSubClassOf("V")) {
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty vertex classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
            if (clazz.isSubClassOf("E")) {
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty edge classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
        }
        OInternalResultSet rs = new OInternalResultSet();
        Collection<OClass> subclasses = clazz.getAllSubclasses();
        if (this.polymorphic && !this.unsafe) {
            for (OClass subclass : subclasses) {
                long subclassRecs = clazz.count();
                if (subclassRecs <= 0L) continue;
                if (subclass.isSubClassOf("V")) {
                    throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty vertex classes (" + subclass.getName() + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
                }
                if (!subclass.isSubClassOf("E")) continue;
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty edge classes (" + subclass.getName() + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
        }
        try {
            clazz.truncate();
            OResultInternal result = new OResultInternal();
            result.setProperty("operation", "truncate class");
            result.setProperty("className", this.className.getStringValue());
            rs.add(result);
            this.invalidateCommandCache(clazz, db);
            if (this.polymorphic) {
                for (OClass subclass : subclasses) {
                    subclass.truncate();
                    result = new OResultInternal();
                    result.setProperty("operation", "truncate class");
                    result.setProperty("className", this.className.getStringValue());
                    rs.add(result);
                    this.invalidateCommandCache(subclass, db);
                }
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OCommandExecutionException("Error on executing command"), e);
        }
        return rs;
    }

    private void invalidateCommandCache(OClass clazz, ODatabase db) {
        int[] clusterIds;
        if (clazz == null) {
            return;
        }
        OCommandCache commandCache = ((OMetadataInternal)db.getMetadata()).getCommandCache();
        if (commandCache != null && commandCache.isEnabled() && (clusterIds = clazz.getClusterIds()) != null) {
            for (int i : clusterIds) {
                String clusterName = OTruncateClassStatement.getDatabase().getClusterNameById(i);
                if (clusterName == null) continue;
                commandCache.invalidateResultsOfCluster(clusterName);
            }
        }
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("TRUNCATE CLASS " + this.className.toString());
        if (this.polymorphic) {
            builder.append(" POLYMORPHIC");
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public OTruncateClassStatement copy() {
        OTruncateClassStatement result = new OTruncateClassStatement(-1);
        result.className = this.className == null ? null : this.className.copy();
        result.polymorphic = this.polymorphic;
        result.unsafe = this.unsafe;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTruncateClassStatement that = (OTruncateClassStatement)o;
        if (this.polymorphic != that.polymorphic) {
            return false;
        }
        if (this.unsafe != that.unsafe) {
            return false;
        }
        return !(this.className != null ? !this.className.equals(that.className) : that.className != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.polymorphic ? 1 : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }
}

