/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Map;

public class OOrderByItem {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    protected String alias;
    protected OModifier modifier;
    protected String recordAttr;
    protected ORid rid;
    protected String type = "ASC";

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRecordAttr() {
        return this.recordAttr;
    }

    public void setRecordAttr(String recordAttr) {
        this.recordAttr = recordAttr;
    }

    public ORid getRid() {
        return this.rid;
    }

    public void setRid(ORid rid) {
        this.rid = rid;
    }

    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.alias != null) {
            builder.append(this.alias);
            if (this.modifier != null) {
                this.modifier.toString(params, builder);
            }
        } else if (this.recordAttr != null) {
            builder.append(this.recordAttr);
        } else if (this.rid != null) {
            this.rid.toString(params, builder);
        }
        if (this.type != null) {
            builder.append(" " + this.type);
        }
    }

    public int compare(OResult a, OResult b, OCommandContext ctx) {
        Object aVal = null;
        Object bVal = null;
        if (this.rid != null) {
            throw new UnsupportedOperationException("ORDER BY " + this.rid + " is not supported yet");
        }
        int result = 0;
        if (this.recordAttr != null) {
            aVal = a.getProperty(this.recordAttr);
            bVal = b.getProperty(this.recordAttr);
        } else if (this.alias != null) {
            aVal = a.getProperty(this.alias);
            bVal = b.getProperty(this.alias);
        }
        if (this.modifier != null) {
            aVal = this.modifier.execute(a, aVal, ctx);
            bVal = this.modifier.execute(b, bVal, ctx);
        }
        if (aVal == null) {
            result = bVal == null ? 0 : -1;
        } else if (bVal == null) {
            result = 1;
        } else if (aVal instanceof Comparable && bVal instanceof Comparable) {
            try {
                result = ((Comparable)aVal).compareTo(bVal);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during comparision", e, new Object[0]);
                result = 0;
            }
        }
        if (this.type == DESC) {
            result = -1 * result;
        }
        return result;
    }

    public OOrderByItem copy() {
        OOrderByItem result = new OOrderByItem();
        result.alias = this.alias;
        result.modifier = this.modifier == null ? null : this.modifier.copy();
        result.recordAttr = this.recordAttr;
        result.rid = this.rid == null ? null : this.rid.copy();
        result.type = this.type;
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.modifier != null) {
            this.modifier.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.alias != null && this.alias.equalsIgnoreCase("$parent")) {
            return true;
        }
        return this.modifier != null && this.modifier.refersToParent();
    }

    public OModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(OModifier modifier) {
        this.modifier = modifier;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("alias", this.alias);
        if (this.modifier != null) {
            result.setProperty("modifier", this.modifier.serialize());
        }
        result.setProperty("recordAttr", this.recordAttr);
        if (this.rid != null) {
            result.setProperty("rid", this.rid.serialize());
        }
        result.setProperty("type", this.type);
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.alias = (String)fromResult.getProperty("alias");
        if (fromResult.getProperty("modifier") != null) {
            this.modifier = new OModifier(-1);
            this.modifier.deserialize((OResult)fromResult.getProperty("modifier"));
        }
        this.recordAttr = (String)fromResult.getProperty("recordAttr");
        if (fromResult.getProperty("rid") != null) {
            this.rid = new ORid(-1);
            this.rid.deserialize((OResult)fromResult.getProperty("rid"));
        }
        this.type = DESC.equals(fromResult.getProperty("type")) ? DESC : ASC;
    }
}

