/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OOrderByItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OOrderBy
extends SimpleNode {
    protected List<OOrderByItem> items;

    public OOrderBy() {
        super(-1);
    }

    public OOrderBy(int id) {
        super(id);
    }

    public OOrderBy(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OOrderByItem> getItems() {
        return this.items;
    }

    public void setItems(List<OOrderByItem> items) {
        this.items = items;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.items != null && this.items.size() > 0) {
            builder.append("ORDER BY ");
            for (int i = 0; i < this.items.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.items.get(i).toString(params, builder);
            }
        }
    }

    public int compare(OResult a, OResult b, OCommandContext ctx) {
        for (OOrderByItem item : this.items) {
            int result = item.compare(a, b, ctx);
            if (result == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    @Override
    public OOrderBy copy() {
        OOrderBy result = new OOrderBy(-1);
        result.items = this.items == null ? null : this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OOrderBy oOrderBy = (OOrderBy)o;
        return !(this.items != null ? !this.items.equals(oOrderBy.items) : oOrderBy.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.items != null) {
            for (OOrderByItem item : this.items) {
                item.extractSubQueries(collector);
            }
        }
    }

    public boolean refersToParent() {
        if (this.items != null) {
            for (OOrderByItem item : this.items) {
                if (!item.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OOrderByItem>();
            for (OResult r : ser) {
                OOrderByItem exp = new OOrderByItem();
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }
}

