/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class OMatchesCondition
extends OBooleanExpression {
    protected OExpression expression;
    protected String right;
    protected OInputParameter rightParam;

    public OMatchesCondition(int id) {
        super(id);
    }

    public OMatchesCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        String regex = this.right;
        if (regex != null) {
            regex = regex.substring(1, regex.length() - 1);
        } else {
            Object paramVal = this.rightParam.getValue(ctx.getInputParameters());
            if (paramVal instanceof String) {
                regex = (String)paramVal;
            } else {
                return false;
            }
        }
        Object value = this.expression.execute(currentRecord, ctx);
        return this.matches(value, regex, ctx);
    }

    private boolean matches(Object value, String regex, OCommandContext ctx) {
        String key = "MATCHES_" + regex.hashCode();
        Pattern p = (Pattern)ctx.getVariable(key);
        if (p == null) {
            p = Pattern.compile(regex);
            ctx.setVariable(key, p);
        }
        if (value instanceof CharSequence) {
            return p.matcher((CharSequence)value).matches();
        }
        return false;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        String regex = this.right;
        if (regex != null) {
            regex = regex.substring(1, regex.length() - 1);
        } else {
            Object paramVal = this.rightParam.getValue(ctx.getInputParameters());
            if (paramVal instanceof String) {
                regex = (String)paramVal;
            } else {
                return false;
            }
        }
        Object value = this.expression.execute(currentRecord, ctx);
        return this.matches(value, regex, ctx);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.expression.toString(params, builder);
        builder.append(" MATCHES ");
        if (this.right != null) {
            builder.append(this.right);
        } else {
            this.rightParam.toString(params, builder);
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        return this.expression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            return Collections.singletonList(this.expression);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        return this.expression.needsAliases(aliases);
    }

    @Override
    public OMatchesCondition copy() {
        OMatchesCondition result = new OMatchesCondition(-1);
        result.expression = this.expression == null ? null : this.expression.copy();
        result.right = this.right;
        result.rightParam = this.rightParam == null ? null : this.rightParam.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.expression.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.expression != null && this.expression.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMatchesCondition that = (OMatchesCondition)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        return !(this.rightParam != null ? !this.rightParam.equals(that.rightParam) : that.rightParam != null);
    }

    public int hashCode() {
        int result = this.expression != null ? this.expression.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.rightParam != null ? this.rightParam.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.expression.getMatchPatternInvolvedAliases();
    }

    @Override
    public boolean isCacheable() {
        return this.expression.isCacheable();
    }
}

