/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OInteger
extends ONumber {
    protected Number value;

    public OInteger(int id) {
        super(id);
    }

    public OInteger(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public void setValue(int sign, String stringValue) {
        int radix = this.radix(stringValue);
        if ((stringValue = this.convertToJavaByRadix(stringValue, radix)).endsWith("L") || stringValue.endsWith("l")) {
            this.value = Long.parseLong(stringValue.substring(0, stringValue.length() - 1), radix) * (long)sign;
        } else {
            long longValue = Long.parseLong(sign > 0 ? stringValue : "-" + stringValue, radix);
            this.value = longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE ? (Number)longValue : (Number)((int)longValue);
        }
    }

    private String convertToJavaByRadix(String stringValue, int radix) {
        if (radix == 16) {
            if (stringValue.charAt(0) == '-') {
                return "-" + stringValue.substring(3);
            }
            return stringValue.substring(2);
        }
        return stringValue;
    }

    private int radix(String stringValue) {
        if (stringValue.startsWith("-")) {
            stringValue = stringValue.substring(1);
        }
        if (stringValue.length() > 2 && stringValue.substring(0, 2).equalsIgnoreCase("0x")) {
            return 16;
        }
        if (stringValue.length() > 1 && stringValue.charAt(0) == '0') {
            return 8;
        }
        return 10;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("" + this.value);
    }

    @Override
    public OInteger copy() {
        OInteger result = new OInteger(-1);
        result.value = this.value;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OInteger oInteger = (OInteger)o;
        return !(this.value != null ? !this.value.equals(oInteger.value) : oInteger.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("value", this.value);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        this.value = (Number)fromResult.getProperty("value");
    }
}

