/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OFuncitonAggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.functions.OIndexableSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.graph.OSQLFunctionMove;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLevelZeroIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OFunctionCall
extends SimpleNode {
    protected OIdentifier name;
    protected List<OExpression> params = new ArrayList<OExpression>();

    public OFunctionCall(int id) {
        super(id);
    }

    public OFunctionCall(OrientSql p, int id) {
        super(p, id);
    }

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isStar() {
        if (this.params.size() != 1) {
            return false;
        }
        OExpression param = this.params.get(0);
        if (param.mathExpression == null || !(param.mathExpression instanceof OBaseExpression)) {
            return false;
        }
        OBaseExpression base = (OBaseExpression)param.mathExpression;
        if (base.identifier == null || base.identifier.suffix == null) {
            return false;
        }
        return base.identifier.suffix.star;
    }

    public List<OExpression> getParams() {
        return this.params;
    }

    public void setParams(List<OExpression> params) {
        this.params = params;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.name.toString(params, builder);
        builder.append("(");
        boolean first = true;
        for (OExpression expr : this.params) {
            if (!first) {
                builder.append(", ");
            }
            expr.toString(params, builder);
            first = false;
        }
        builder.append(")");
    }

    public Object execute(Object targetObjects, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.name.getStringValue());
    }

    private Object execute(Object targetObjects, OCommandContext ctx, String name) {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        Object record = null;
        if (record == null) {
            record = targetObjects instanceof OIdentifiable ? (OIdentifiable)targetObjects : (targetObjects instanceof OResult ? ((OResult)targetObjects).toElement() : targetObjects);
        }
        if (record == null) {
            Iterator<OExpression> current;
            Iterator<OExpression> iterator = current = ctx == null ? null : ctx.getVariable("$current");
            if (current != null) {
                record = current instanceof OIdentifiable ? current : (current instanceof OResult ? ((OResult)((Object)current)).toElement() : current);
            }
        }
        for (OExpression expr : this.params) {
            if (record instanceof OIdentifiable) {
                paramValues.add(expr.execute((OIdentifiable)record, ctx));
                continue;
            }
            if (record instanceof OResult) {
                paramValues.add(expr.execute((OResult)record, ctx));
                continue;
            }
            if (record == null) {
                paramValues.add(expr.execute((OResult)record, ctx));
                continue;
            }
            throw new OCommandExecutionException("Invalid value for $current: " + record);
        }
        OSQLFunction function = OSQLEngine.getInstance().getFunction(name);
        function.config(this.params.toArray());
        if (function != null) {
            if (record instanceof OIdentifiable) {
                return function.execute(targetObjects, (OIdentifiable)record, null, paramValues.toArray(), ctx);
            }
            if (record instanceof OResult) {
                return function.execute(targetObjects, ((OResult)record).getElement().orElse(null), null, paramValues.toArray(), ctx);
            }
            if (record == null) {
                return function.execute(targetObjects, null, null, paramValues.toArray(), ctx);
            }
            throw new OCommandExecutionException("Invalid value for $current: " + record);
        }
        throw new OCommandExecutionException("Funciton not found: " + name);
    }

    public boolean isIndexedFunctionCall() {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        return function instanceof OIndexableSQLFunction;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext ctx, OBinaryCompareOperator operator, Object rightValue) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).searchFromTarget(target, operator, rightValue, ctx, this.getParams().toArray(new OExpression[0]));
        }
        return null;
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext ctx, OBinaryCompareOperator operator, Object rightValue) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).estimate(target, operator, rightValue, ctx, this.getParams().toArray(new OExpression[0]));
        }
        return -1L;
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).canExecuteInline(target, operator, right, context, this.getParams().toArray(new OExpression[0]));
        }
        return false;
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).allowsIndexedExecution(target, operator, right, context, this.getParams().toArray(new OExpression[0]));
        }
        return false;
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).shouldExecuteAfterSearch(target, operator, right, context, this.getParams().toArray(new OExpression[0]));
        }
        return false;
    }

    public boolean isExpand() {
        return this.name.getStringValue().equalsIgnoreCase("expand");
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OExpression param : this.params) {
            if (!param.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregate() {
        if (this.isAggregateFunction()) {
            return true;
        }
        for (OExpression exp : this.params) {
            if (!exp.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (this.isAggregate()) {
            OFunctionCall newFunct = new OFunctionCall(-1);
            newFunct.name = this.name;
            OIdentifier functionResultAlias = aggregateProj.getNextAlias();
            if (this.isAggregateFunction()) {
                if (this.isStar()) {
                    for (OExpression param : this.params) {
                        newFunct.getParams().add(param);
                    }
                } else {
                    for (OExpression param : this.params) {
                        if (param.isAggregate()) {
                            throw new OCommandExecutionException("Cannot calculate an aggregate function of another aggregate function " + this.toString());
                        }
                        OIdentifier nextAlias = aggregateProj.getNextAlias();
                        OProjectionItem paramItem = new OProjectionItem(-1);
                        paramItem.alias = nextAlias;
                        paramItem.expression = param;
                        aggregateProj.getPreAggregate().add(paramItem);
                        newFunct.params.add(new OExpression(nextAlias));
                    }
                }
                aggregateProj.getAggregate().add(this.createProjection(newFunct, functionResultAlias));
                return new OExpression(functionResultAlias);
            }
            if (this.isStar()) {
                for (OExpression param : this.params) {
                    newFunct.getParams().add(param);
                }
            } else {
                for (OExpression param : this.params) {
                    newFunct.getParams().add(param.splitForAggregation(aggregateProj, ctx));
                }
            }
            return newFunct;
        }
        return this;
    }

    private boolean isAggregateFunction() {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        function.config(this.params.toArray());
        return function.aggregateResults();
    }

    private OProjectionItem createProjection(OFunctionCall newFunct, OIdentifier alias) {
        OLevelZeroIdentifier l0 = new OLevelZeroIdentifier(-1);
        l0.functionCall = newFunct;
        OBaseIdentifier l1 = new OBaseIdentifier(-1);
        l1.levelZero = l0;
        OBaseExpression l2 = new OBaseExpression(-1);
        l2.identifier = l1;
        OExpression l3 = new OExpression(-1);
        l3.mathExpression = l2;
        OProjectionItem item = new OProjectionItem(-1);
        item.alias = alias;
        item.expression = l3;
        return item;
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        if (this.isTraverseFunction()) {
            return false;
        }
        for (OExpression param : this.params) {
            if (param.isEarlyCalculated(ctx)) continue;
            return false;
        }
        return true;
    }

    private boolean isTraverseFunction() {
        if (this.name == null) {
            return false;
        }
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.value);
        return function instanceof OSQLFunctionMove;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        function.config(this.params.toArray());
        OFuncitonAggregationContext result = new OFuncitonAggregationContext(function, this.params);
        return result;
    }

    @Override
    public OFunctionCall copy() {
        OFunctionCall result = new OFunctionCall(-1);
        result.name = this.name;
        result.params = this.params.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFunctionCall that = (OFunctionCall)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public boolean refersToParent() {
        if (this.params != null) {
            for (OExpression param : this.params) {
                if (param == null || !param.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public OIdentifier getName() {
        return this.name;
    }

    public OMethodCall toMethod() {
        OMethodCall result = new OMethodCall(-1);
        result.methodName = this.name.copy();
        result.params = this.params.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.name != null) {
            result.setProperty("name", this.name.serialize());
        }
        if (this.params != null) {
            result.setProperty("collection", this.params.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("name") != null) {
            this.name = OIdentifier.deserialize((OResult)fromResult.getProperty("name"));
        }
        if (fromResult.getProperty("params") != null) {
            this.params = new ArrayList<OExpression>();
            List ser = (List)fromResult.getProperty("params");
            for (OResult item : ser) {
                OExpression exp = new OExpression(-1);
                exp.deserialize(item);
                this.params.add(exp);
            }
        }
    }

    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        for (OExpression param : this.params) {
            param.extractSubQueries(letAlias, collector);
        }
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OExpression param : this.params) {
            param.extractSubQueries(collector);
        }
    }

    public boolean isCacheable() {
        return this.isGraphFunction();
    }

    private boolean isGraphFunction() {
        String string = this.name.getStringValue();
        if (string.equalsIgnoreCase("out")) {
            return true;
        }
        if (string.equalsIgnoreCase("outE")) {
            return true;
        }
        if (string.equalsIgnoreCase("outV")) {
            return true;
        }
        if (string.equalsIgnoreCase("in")) {
            return true;
        }
        if (string.equalsIgnoreCase("inE")) {
            return true;
        }
        if (string.equalsIgnoreCase("inV")) {
            return true;
        }
        if (string.equalsIgnoreCase("both")) {
            return true;
        }
        if (string.equalsIgnoreCase("bothE")) {
            return true;
        }
        return string.equalsIgnoreCase("bothV");
    }
}

