/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OCreateViewStatement
extends ODDLStatement {
    protected OIdentifier name;
    protected OStatement statement;
    protected boolean ifNotExists = false;
    protected OJson metadata;

    public OCreateViewStatement(int id) {
        super(id);
    }

    public OCreateViewStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OSchema schema = ctx.getDatabase().getMetadata().getSchema();
        if (schema.existsView(this.name.getStringValue())) {
            if (this.ifNotExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("View " + this.name + " already exists");
        }
        if (schema.existsClass(this.name.getStringValue())) {
            throw new OCommandExecutionException("Cannot create view " + this.name + ", a class with the same name already exists");
        }
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create view");
        result.setProperty("viewName", this.name.getStringValue());
        schema.createView((ODatabaseDocumentInternal)ctx.getDatabase(), this.name.getStringValue(), this.statement.toString(), this.metadata == null ? new HashMap<String, Object>() : this.metadata.toMap(new OResultInternal(), ctx));
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    public void checkMetadataSyntax() throws OCommandSQLParsingException {
        HashSet<String> validAttributes = new HashSet<String>();
        validAttributes.add("updatable");
        validAttributes.add("updateIntervalSeconds");
        validAttributes.add("updateStrategy");
        validAttributes.add("watchClasses");
        validAttributes.add("originRidField");
        validAttributes.add("nodes");
        validAttributes.add("indexes");
        if (this.metadata == null) {
            return;
        }
        Map<String, Object> metadataMap = this.metadata.toMap(new OResultInternal(), (OCommandContext)new OBasicCommandContext());
        block26: for (Map.Entry<String, Object> s : metadataMap.entrySet()) {
            String key = s.getKey();
            Object value = s.getValue();
            switch (key) {
                case "updatable": {
                    if (!(value instanceof Boolean)) {
                        throw new OCommandSQLParsingException("Invalid value for view metadata: updatable should be true or false, it is " + value);
                    }
                    if (!Boolean.TRUE.equals(value) || metadataMap.containsKey("originRidField")) continue block26;
                    throw new OCommandSQLParsingException("Updatable view needs a originRidField defined");
                }
                case "updateIntervalSeconds": {
                    if (value instanceof Number) continue block26;
                    throw new OCommandSQLParsingException("Invalid value for view metadata: updateIntervalSeconds should be a number, it is " + value);
                }
                case "updateStrategy": {
                    if (OViewConfig.UPDATE_STRATEGY_BATCH.equals(value) || OViewConfig.UPDATE_STRATEGY_LIVE.equals(value)) continue block26;
                    throw new OCommandSQLParsingException("Invalid value for view metadata: updateStrategy should be " + OViewConfig.UPDATE_STRATEGY_LIVE + " or " + OViewConfig.UPDATE_STRATEGY_BATCH + ", it is " + value);
                }
                case "watchClasses": {
                    if (!(value instanceof Collection)) {
                        throw new OCommandSQLParsingException("Invalid value for view metadata: watchClasses should be a list of class names as strings, it is " + value);
                    }
                    if (!((Collection)value).stream().anyMatch(x -> !(x instanceof String))) continue block26;
                    throw new OCommandSQLParsingException("Invalid value for view metadata: watchClasses should be a list of class names as strings, one value is null");
                }
                case "originRidField": {
                    if (value instanceof String) continue block26;
                    throw new OCommandSQLParsingException("Invalid value for view metadata: updateStrategy should be a string, it is " + value);
                }
                case "nodes": {
                    if (!(value instanceof Collection)) {
                        throw new OCommandSQLParsingException("Invalid value for view metadata: nodes should be a list of class names as strings, it is " + value);
                    }
                    if (!((Collection)value).stream().anyMatch(x -> !(x instanceof String))) continue block26;
                    throw new OCommandSQLParsingException("Invalid value for view metadata: nodes should be a list of class names as strings, one value is null");
                }
                case "indexes": {
                    if (!(value instanceof Collection)) {
                        throw new OCommandSQLParsingException("Invalid value for view metadata: indexes should be a list of class names as strings, it is " + value);
                    }
                    for (Object o : (Collection)value) {
                        if (!(o instanceof Map)) {
                            throw new OCommandSQLParsingException("Invalid value for view metadata: index configuration should be as follows: {type:'<index_type>', engine:'<engine_name>', properties:{propName1:'<type>', propNameN:'<type'>}}. Engine is optional");
                        }
                        Map valueMap = (Map)o;
                        Iterator iterator = valueMap.keySet().iterator();
                        block28: while (iterator.hasNext()) {
                            String idxKey;
                            switch (idxKey = (String)iterator.next()) {
                                case "type": 
                                case "engine": 
                                case "properties": {
                                    continue block28;
                                }
                            }
                            throw new OCommandSQLParsingException("Invalid key for view index metadata: " + idxKey + ". Valid keys are 'type', 'engine', 'properties'");
                        }
                    }
                    continue block26;
                }
                default: {
                    throw new OCommandSQLParsingException("Invalid metadata for view: " + key);
                }
            }
        }
    }

    @Override
    public OStatement copy() {
        OCreateViewStatement result = new OCreateViewStatement(-1);
        result.name = this.name.copy();
        result.statement = this.statement.copy();
        result.ifNotExists = this.ifNotExists;
        result.metadata = this.metadata == null ? null : this.metadata.copy();
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE VIEW ");
        this.name.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        builder.append(" FROM (");
        this.statement.toString(params, builder);
        builder.append(")");
        if (this.metadata != null) {
            builder.append(" METADATA ");
            this.metadata.toString(params, builder);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateViewStatement that = (OCreateViewStatement)o;
        if (this.ifNotExists != that.ifNotExists) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.statement != null ? !this.statement.equals(that.statement) : that.statement != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
        result = 31 * result + (this.ifNotExists ? 1 : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }
}

