/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OCollection
extends SimpleNode {
    protected List<OExpression> expressions = new ArrayList<OExpression>();

    public OCollection(int id) {
        super(id);
    }

    public OCollection(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("[");
        boolean first = true;
        for (OExpression expr : this.expressions) {
            if (!first) {
                builder.append(", ");
            }
            expr.toString(params, builder);
            first = false;
        }
        builder.append("]");
    }

    public void add(OExpression exp) {
        this.expressions.add(exp);
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OExpression exp : this.expressions) {
            result.add(exp.execute(iCurrentRecord, ctx));
        }
        return result;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OExpression exp : this.expressions) {
            result.add(this.convert(exp.execute(iCurrentRecord, ctx)));
        }
        return result;
    }

    private Object convert(Object item) {
        if (item instanceof OResultSet) {
            return ((OResultSet)item).stream().collect(Collectors.toList());
        }
        return item;
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OExpression expr : this.expressions) {
            if (!expr.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregate() {
        for (OExpression exp : this.expressions) {
            if (!exp.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public OCollection splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (this.isAggregate()) {
            OCollection result = new OCollection(-1);
            for (OExpression exp : this.expressions) {
                if (exp.isAggregate() || exp.isEarlyCalculated(ctx)) {
                    result.expressions.add(exp.splitForAggregation(aggregateProj, ctx));
                    continue;
                }
                throw new OCommandExecutionException("Cannot mix aggregate and non-aggregate operations in a collection: " + this.toString());
            }
            return result;
        }
        return this;
    }

    public boolean isEarlyCalculated(OCommandContext ctx) {
        for (OExpression exp : this.expressions) {
            if (exp.isEarlyCalculated(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public OCollection copy() {
        OCollection result = new OCollection(-1);
        result.expressions = this.expressions == null ? null : this.expressions.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCollection that = (OCollection)o;
        return !(this.expressions != null ? !this.expressions.equals(that.expressions) : that.expressions != null);
    }

    public int hashCode() {
        return this.expressions != null ? this.expressions.hashCode() : 0;
    }

    public boolean refersToParent() {
        if (this.expressions != null) {
            for (OExpression exp : this.expressions) {
                if (exp == null || !exp.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.expressions != null) {
            result.setProperty("expressions", this.expressions.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("expressions") != null) {
            this.expressions = new ArrayList<OExpression>();
            List ser = (List)fromResult.getProperty("expressions");
            for (OResult item : ser) {
                OExpression exp = new OExpression(-1);
                exp.deserialize(item);
                this.expressions.add(exp);
            }
        }
    }

    public boolean isCacheable() {
        for (OExpression exp : this.expressions) {
            if (exp.isCacheable()) continue;
            return false;
        }
        return true;
    }

    public List<OExpression> getExpressions() {
        return this.expressions;
    }
}

