/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OCluster
extends SimpleNode {
    protected String clusterName;
    protected Integer clusterNumber;

    public OCluster(String clusterName) {
        super(-1);
        this.clusterName = clusterName;
    }

    public OCluster(int id) {
        super(id);
    }

    public OCluster(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.clusterName != null) {
            builder.append("cluster:" + this.clusterName);
        } else {
            builder.append("cluster:" + this.clusterNumber);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getClusterNumber() {
        return this.clusterNumber;
    }

    @Override
    public OCluster copy() {
        OCluster result = new OCluster(-1);
        result.clusterName = this.clusterName;
        result.clusterNumber = this.clusterNumber;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCluster oCluster = (OCluster)o;
        if (this.clusterName != null ? !this.clusterName.equals(oCluster.clusterName) : oCluster.clusterName != null) {
            return false;
        }
        return !(this.clusterNumber != null ? !this.clusterNumber.equals(oCluster.clusterNumber) : oCluster.clusterNumber != null);
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.clusterNumber != null ? this.clusterNumber.hashCode() : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("clusterName", this.clusterName);
        result.setProperty("clusterNumber", this.clusterNumber);
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.clusterName = (String)fromResult.getProperty("clusterName");
        this.clusterNumber = (Integer)fromResult.getProperty("clusterNumber");
    }
}

