/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class OAlterPropertyStatement
extends ODDLStatement {
    OIdentifier className;
    OIdentifier propertyName;
    OIdentifier customPropertyName;
    OExpression customPropertyValue;
    OIdentifier settingName;
    public OExpression settingValue;

    public OAlterPropertyStatement(int id) {
        super(id);
    }

    public OAlterPropertyStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        ODatabase db = ctx.getDatabase();
        OClass clazz = db.getMetadata().getSchema().getClass(this.className.getStringValue());
        if (clazz == null) {
            throw new OCommandExecutionException("Invalid class name or class not found: " + clazz);
        }
        OProperty property = clazz.getProperty(this.propertyName.getStringValue());
        if (property == null) {
            throw new OCommandExecutionException("Property " + property + " not found on class " + clazz);
        }
        OResultInternal result = new OResultInternal();
        result.setProperty("class", this.className.getStringValue());
        result.setProperty("property", this.propertyName.getStringValue());
        if (this.customPropertyName != null) {
            String customName = this.customPropertyName.getStringValue();
            String oldValue = property.getCustom(customName);
            Object finalValue = this.customPropertyValue.execute((OIdentifiable)null, ctx);
            property.setCustom(customName, finalValue == null ? null : "" + finalValue);
            result.setProperty("operation", "alter property custom");
            result.setProperty("customAttribute", this.customPropertyName.getStringValue());
            result.setProperty("oldValue", oldValue != null ? oldValue.toString() : null);
            result.setProperty("newValue", finalValue != null ? finalValue.toString() : null);
        } else {
            OProperty.ATTRIBUTES attribute;
            String stringFinalValue;
            String setting = this.settingName.getStringValue();
            boolean isCollate = setting.equalsIgnoreCase("collate");
            Object finalValue = this.settingValue.execute((OIdentifiable)null, ctx);
            if (finalValue == null && (setting.equalsIgnoreCase("name") || setting.equalsIgnoreCase("shortname") || isCollate) && (stringFinalValue = (String)(finalValue = this.settingValue.toString())).startsWith("`") && stringFinalValue.endsWith("`") && stringFinalValue.length() > 2) {
                stringFinalValue = stringFinalValue.substring(1, stringFinalValue.length() - 1);
                finalValue = stringFinalValue;
            }
            try {
                attribute = OProperty.ATTRIBUTES.valueOf(setting.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new OCommandExecutionException("Unknown property attribute '" + setting + "'. Supported attributes are: " + Arrays.toString((Object[])OProperty.ATTRIBUTES.values())), e);
            }
            Object oldValue = property.get(attribute);
            property.set(attribute, finalValue);
            finalValue = property.get(attribute);
            result.setProperty("operation", "alter property");
            result.setProperty("attribute", setting);
            result.setProperty("oldValue", oldValue != null ? oldValue.toString() : null);
            result.setProperty("newValue", finalValue != null ? finalValue.toString() : null);
        }
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void validate() throws OCommandSQLParsingException {
        super.validate();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER PROPERTY ");
        this.className.toString(params, builder);
        builder.append(".");
        this.propertyName.toString(params, builder);
        if (this.customPropertyName != null) {
            builder.append(" CUSTOM ");
            this.customPropertyName.toString(params, builder);
            builder.append(" = ");
            this.customPropertyValue.toString(params, builder);
        } else {
            builder.append(" ");
            this.settingName.toString(params, builder);
            builder.append(" ");
            this.settingValue.toString(params, builder);
        }
    }

    @Override
    public OAlterPropertyStatement copy() {
        OAlterPropertyStatement result = new OAlterPropertyStatement(-1);
        result.className = this.className == null ? null : this.className.copy();
        result.propertyName = this.propertyName == null ? null : this.propertyName.copy();
        result.customPropertyName = this.customPropertyName == null ? null : this.customPropertyName.copy();
        result.customPropertyValue = this.customPropertyValue == null ? null : this.customPropertyValue.copy();
        result.settingName = this.settingName == null ? null : this.settingName.copy();
        result.settingValue = this.settingValue == null ? null : this.settingValue.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterPropertyStatement that = (OAlterPropertyStatement)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        if (this.customPropertyName != null ? !this.customPropertyName.equals(that.customPropertyName) : that.customPropertyName != null) {
            return false;
        }
        if (this.customPropertyValue != null ? !this.customPropertyValue.equals(that.customPropertyValue) : that.customPropertyValue != null) {
            return false;
        }
        if (this.settingName != null ? !this.settingName.equals(that.settingName) : that.settingName != null) {
            return false;
        }
        return !(this.settingValue != null ? !this.settingValue.equals(that.settingValue) : that.settingValue != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.customPropertyName != null ? this.customPropertyName.hashCode() : 0);
        result = 31 * result + (this.customPropertyValue != null ? this.customPropertyValue.hashCode() : 0);
        result = 31 * result + (this.settingName != null ? this.settingName.hashCode() : 0);
        result = 31 * result + (this.settingValue != null ? this.settingValue.hashCode() : 0);
        return result;
    }
}

