/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import java.util.ArrayList;
import java.util.List;

public abstract class OSQLFilterItemFieldMultiAbstract
extends OSQLFilterItemAbstract {
    private List<String> names;
    private final OClass clazz;
    private final List<OCollate> collates = new ArrayList<OCollate>();

    public OSQLFilterItemFieldMultiAbstract(OSQLPredicate iQueryCompiled, String iName, OClass iClass, List<String> iNames) {
        super(iQueryCompiled, iName);
        this.names = iNames;
        this.clazz = iClass;
        for (String n : iNames) {
            this.collates.add(this.getCollateForField(iClass, n));
        }
    }

    @Override
    public Object getValue(OIdentifiable iRecord, Object iCurrentResult, OCommandContext iContext) {
        int i;
        ODocument doc = (ODocument)iRecord;
        if (this.names.size() == 1) {
            return this.transformValue(iRecord, iContext, ODocumentHelper.getIdentifiableValue(iRecord, this.names.get(0)));
        }
        String[] fieldNames = doc.fieldNames();
        Object[] values = new Object[fieldNames.length];
        this.collates.clear();
        for (i = 0; i < values.length; ++i) {
            values[i] = doc.field(fieldNames[i]);
            this.collates.add(this.getCollateForField(this.clazz, fieldNames[i]));
        }
        if (this.hasChainOperators()) {
            for (i = 0; i < values.length; ++i) {
                values[i] = this.transformValue(iRecord, iContext, values[i]);
            }
        }
        return new OQueryRuntimeValueMulti(this, values, this.collates);
    }
}

