/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMatches;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class OSQLFilterCondition {
    private static final String NULL_VALUE = "null";
    protected Object left;
    protected OQueryOperator operator;
    protected Object right;
    protected boolean inBraces = false;

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator) {
        this.left = iLeft;
        this.operator = iOperator;
    }

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator, Object iRight) {
        this.left = iLeft;
        this.operator = iOperator;
        this.right = iRight;
    }

    public Object evaluate(OIdentifiable iCurrentRecord, ODocument iCurrentResult, OCommandContext iContext) {
        Object result;
        OCollate collate;
        Object[] convertedValues;
        OCollate collate2;
        BytesContainer bytes;
        OType type;
        boolean binaryEvaluation;
        boolean bl = binaryEvaluation = this.operator != null && this.operator.isSupportingBinaryEvaluate() && iCurrentRecord != null && iCurrentRecord.getIdentity().isPersistent();
        if (this.left instanceof OSQLQuery) {
            this.left = ((OSQLQuery)this.left).setContext(iContext).execute(new Object[0]);
        }
        Object l = this.evaluate(iCurrentRecord, iCurrentResult, this.left, iContext, binaryEvaluation);
        if (this.operator == null || this.operator.canShortCircuit(l)) {
            return l;
        }
        if (this.right instanceof OSQLQuery) {
            this.right = ((OSQLQuery)this.right).setContext(iContext).execute(new Object[0]);
        }
        Object r = this.evaluate(iCurrentRecord, iCurrentResult, this.right, iContext, binaryEvaluation);
        if (binaryEvaluation && l instanceof OBinaryField) {
            if (r != null && !(r instanceof OBinaryField)) {
                type = OType.getTypeByValue(r);
                if (ORecordSerializerBinary.INSTANCE.getCurrentSerializer().getComparator().isBinaryComparable(type)) {
                    bytes = new BytesContainer();
                    ORecordSerializerBinary.INSTANCE.getCurrentSerializer().serializeValue(bytes, r, type, null);
                    bytes.offset = 0;
                    collate2 = r instanceof OSQLFilterItemField ? ((OSQLFilterItemField)r).getCollate(iCurrentRecord) : null;
                    r = new OBinaryField(null, type, bytes, collate2);
                    if (!(this.right instanceof OSQLFilterItem) && !(this.right instanceof OSQLFilterCondition)) {
                        this.right = r;
                    }
                }
            } else if (r instanceof OBinaryField) {
                r = ((OBinaryField)r).copy();
            }
        }
        if (binaryEvaluation && r instanceof OBinaryField) {
            if (l != null && !(l instanceof OBinaryField)) {
                type = OType.getTypeByValue(l);
                if (ORecordSerializerBinary.INSTANCE.getCurrentSerializer().getComparator().isBinaryComparable(type)) {
                    bytes = new BytesContainer();
                    ORecordSerializerBinary.INSTANCE.getCurrentSerializer().serializeValue(bytes, l, type, null);
                    bytes.offset = 0;
                    collate2 = l instanceof OSQLFilterItemField ? ((OSQLFilterItemField)l).getCollate(iCurrentRecord) : null;
                    l = new OBinaryField(null, type, bytes, collate2);
                    if (!(this.left instanceof OSQLFilterItem) && !(this.left instanceof OSQLFilterCondition)) {
                        this.left = l;
                    }
                }
            } else if (l instanceof OBinaryField) {
                l = ((OBinaryField)l).copy();
            }
        }
        if (binaryEvaluation) {
            boolean bl2 = binaryEvaluation = l instanceof OBinaryField && r instanceof OBinaryField;
        }
        if (!binaryEvaluation && (convertedValues = this.checkForConversion(iCurrentRecord, l, r, collate = this.operator instanceof OQueryOperatorMatches ? null : this.getCollate(iCurrentRecord))) != null) {
            l = convertedValues[0];
            r = convertedValues[1];
        }
        try {
            result = this.operator.evaluateRecord(iCurrentRecord, iCurrentResult, this, l, r, iContext, ORecordSerializerBinary.INSTANCE.getCurrentSerializer());
        }
        catch (OCommandExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Error on evaluating expression (%s)", e, this.toString());
            }
            result = Boolean.FALSE;
        }
        return result;
    }

    @Deprecated
    public OCollate getCollate() {
        if (this.left instanceof OSQLFilterItemField) {
            return ((OSQLFilterItemField)this.left).getCollate();
        }
        if (this.right instanceof OSQLFilterItemField) {
            return ((OSQLFilterItemField)this.right).getCollate();
        }
        return null;
    }

    public OCollate getCollate(OIdentifiable doc) {
        if (this.left instanceof OSQLFilterItemField) {
            return ((OSQLFilterItemField)this.left).getCollate(doc);
        }
        if (this.right instanceof OSQLFilterItemField) {
            return ((OSQLFilterItemField)this.right).getCollate(doc);
        }
        return null;
    }

    public ORID getBeginRidRange() {
        if (this.operator == null) {
            if (this.left instanceof OSQLFilterCondition) {
                return ((OSQLFilterCondition)this.left).getBeginRidRange();
            }
            return null;
        }
        return this.operator.getBeginRidRange(this.left, this.right);
    }

    public ORID getEndRidRange() {
        if (this.operator == null) {
            if (this.left instanceof OSQLFilterCondition) {
                return ((OSQLFilterCondition)this.left).getEndRidRange();
            }
            return null;
        }
        return this.operator.getEndRidRange(this.left, this.right);
    }

    public List<String> getInvolvedFields(List<String> list) {
        this.extractInvolvedFields(this.getLeft(), list);
        this.extractInvolvedFields(this.getRight(), list);
        return list;
    }

    private void extractInvolvedFields(Object left, List<String> list) {
        if (left != null) {
            if (left instanceof OSQLFilterItemField) {
                if (((OSQLFilterItemField)left).isFieldChain()) {
                    list.add(((OSQLFilterItemField)left).getFieldChain().getItemName(((OSQLFilterItemField)left).getFieldChain().getItemCount() - 1));
                }
            } else if (left instanceof OSQLFilterCondition) {
                ((OSQLFilterCondition)left).getInvolvedFields(list);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('(');
        buffer.append(this.left);
        if (this.operator != null) {
            buffer.append(' ');
            buffer.append(this.operator);
            buffer.append(' ');
            if (this.right instanceof String) {
                buffer.append('\'');
            }
            buffer.append(this.right);
            if (this.right instanceof String) {
                buffer.append('\'');
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    public Object getLeft() {
        return this.left;
    }

    public void setLeft(Object iValue) {
        this.left = iValue;
    }

    public Object getRight() {
        return this.right;
    }

    public void setRight(Object iValue) {
        this.right = iValue;
    }

    public OQueryOperator getOperator() {
        return this.operator;
    }

    protected Integer getInteger(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if ("_DEFINED_".equals(stringValue)) {
            return null;
        }
        if (OStringSerializerHelper.contains(stringValue, '.') || OStringSerializerHelper.contains(stringValue, ',')) {
            return (int)Float.parseFloat(stringValue);
        }
        return stringValue.length() > 0 ? new Integer(stringValue) : new Integer(0);
    }

    protected Float getFloat(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        return stringValue.length() > 0 ? new Float(stringValue) : new Float(0.0f);
    }

    protected Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        OStorageConfiguration config = ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration();
        if (value instanceof Long) {
            Calendar calendar = Calendar.getInstance(config.getTimeZone());
            calendar.setTimeInMillis((Long)value);
            return calendar.getTime();
        }
        String stringValue = value.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if (stringValue.length() <= 0) {
            return null;
        }
        if (Pattern.matches("^\\d+$", stringValue)) {
            return new Date(Long.valueOf(stringValue));
        }
        SimpleDateFormat formatter = config.getDateFormatInstance();
        if (stringValue.length() > config.getDateFormat().length()) {
            formatter = config.getDateTimeFormatInstance();
        }
        try {
            return formatter.parse(stringValue);
        }
        catch (ParseException ignore) {
            try {
                return new Date(new Double(stringValue).longValue());
            }
            catch (Exception pe2) {
                throw OException.wrapException(new OQueryParsingException("Error on conversion of date '" + stringValue + "' using the format: " + formatter.toPattern()), pe2);
            }
        }
    }

    protected Object evaluate(OIdentifiable iCurrentRecord, ODocument iCurrentResult, Object iValue, OCommandContext iContext, boolean binaryEvaluation) {
        OBinaryField bField;
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof BytesContainer) {
            return iValue;
        }
        if (iCurrentRecord != null && (iCurrentRecord = iCurrentRecord.getRecord()) != null && ((ORecord)iCurrentRecord).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                iCurrentRecord = iCurrentRecord.getRecord().load();
            }
            catch (ORecordNotFoundException ignore) {
                return null;
            }
        }
        if (binaryEvaluation && iValue instanceof OSQLFilterItemField && iCurrentRecord != null && !((ODocument)iCurrentRecord).isDirty() && !iCurrentRecord.getIdentity().isTemporary() && (bField = ((OSQLFilterItemField)iValue).getBinaryField(iCurrentRecord)) != null) {
            return bField;
        }
        if (iValue instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iValue).getValue(iCurrentRecord, iCurrentResult, iContext);
        }
        if (iValue instanceof OSQLFilterCondition) {
            return ((OSQLFilterCondition)iValue).evaluate(iCurrentRecord, iCurrentResult, iContext);
        }
        if (iValue instanceof OSQLFunctionRuntime) {
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)iValue;
            return f.execute(iCurrentRecord, iCurrentRecord, iCurrentResult, iContext);
        }
        if (OMultiValue.isMultiValue(iValue) && !Map.class.isAssignableFrom(iValue.getClass())) {
            Iterable<Object> multiValue = OMultiValue.getMultiValueIterable(iValue, false);
            ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize(iValue));
            for (Object value : multiValue) {
                if (value instanceof OSQLFilterItem) {
                    result.add(((OSQLFilterItem)value).getValue(iCurrentRecord, iCurrentResult, iContext));
                    continue;
                }
                result.add(value);
            }
            return result;
        }
        return iValue;
    }

    private Object[] checkForConversion(OIdentifiable o, Object l, Object r, OCollate collate) {
        Object[] result = null;
        Object oldL = l;
        Object oldR = r;
        if (collate != null) {
            l = collate.transform(l);
            r = collate.transform(r);
            if (l != oldL || r != oldR) {
                result = new Object[]{l, r};
            }
        }
        try {
            if (oldR instanceof String && oldR.equals("_DEFINED_") || oldL instanceof String && oldL.equals("_DEFINED_")) {
                result = new Object[]{((OSQLFilterItemAbstract)this.left).getRoot(), r};
            } else if (oldR instanceof String && oldR.equals("_NOT_NULL_") || oldL instanceof String && oldL.equals("_NOT_NULL_")) {
                result = null;
            } else if (l != null && r != null && !l.getClass().isAssignableFrom(r.getClass()) && !r.getClass().isAssignableFrom(l.getClass())) {
                if (r instanceof Integer && !(l instanceof Number) && !(l instanceof Collection)) {
                    if (l instanceof String && ((String)l).indexOf(46) > -1) {
                        result = new Object[]{new Float((String)l).intValue(), r};
                    } else if (l instanceof Date) {
                        result = new Object[]{((Date)l).getTime(), r};
                    } else if (!(l instanceof OQueryRuntimeValueMulti || l instanceof Collection || l.getClass().isArray() || l instanceof Map)) {
                        result = new Object[]{this.getInteger(l), r};
                    }
                } else if (l instanceof Integer && !(r instanceof Number) && !(r instanceof Collection)) {
                    if (r instanceof String && ((String)r).indexOf(46) > -1) {
                        result = new Object[]{l, new Float((String)r).intValue()};
                    } else if (r instanceof Date) {
                        result = new Object[]{l, ((Date)r).getTime()};
                    } else if (!(r instanceof OQueryRuntimeValueMulti || r instanceof Collection || r.getClass().isArray() || r instanceof Map)) {
                        result = new Object[]{l, this.getInteger(r)};
                    }
                } else if (r instanceof Date && !(l instanceof Collection) && !(l instanceof Date)) {
                    result = new Object[]{this.getDate(l), r};
                } else if (l instanceof Date && !(r instanceof Collection) && !(r instanceof Date)) {
                    result = new Object[]{l, this.getDate(r)};
                } else if (r instanceof Float && !(l instanceof Float) && !(l instanceof Collection)) {
                    result = new Object[]{this.getFloat(l), r};
                } else if (l instanceof Float && !(r instanceof Float) && !(r instanceof Collection)) {
                    result = new Object[]{l, this.getFloat(r)};
                } else if (r instanceof ORID && l instanceof String && !oldL.equals("_NOT_NULL_")) {
                    result = new Object[]{new ORecordId((String)l), r};
                } else if (l instanceof ORID && r instanceof String && !oldR.equals("_NOT_NULL_")) {
                    result = new Object[]{l, new ORecordId((String)r)};
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

