/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractUnrollStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayList;
import java.util.Collection;

public class WhileMatchStep
extends AbstractUnrollStep {
    private final OInternalExecutionPlan body;
    private final OWhereClause condition;

    public WhileMatchStep(OCommandContext ctx, OWhereClause condition, OInternalExecutionPlan body, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.body = body;
        this.condition = condition;
    }

    @Override
    protected Collection<OResult> unroll(OResult doc, OCommandContext iContext) {
        this.body.reset(iContext);
        ArrayList<OResult> result = new ArrayList<OResult>();
        OResultSet block = this.body.fetchNext(100);
        while (block.hasNext()) {
            while (block.hasNext()) {
                result.add(block.next());
            }
            block = this.body.fetchNext(100);
        }
        return result;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String indentStep = OExecutionStepInternal.getIndent(1, indent);
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ WHILE\n");
        result.append(spaces);
        result.append(indentStep);
        result.append(this.condition.toString());
        result.append("\n");
        result.append(spaces);
        result.append("  DO\n");
        result.append(this.body.prettyPrint(depth + 1, indent));
        result.append("\n");
        result.append(spaces);
        result.append("  END\n");
        return result.toString();
    }
}

