/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateSetStep
extends AbstractExecutionStep {
    private final List<OUpdateItem> items;

    public UpdateSetStep(List<OUpdateItem> updateItems, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.items = updateItems;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                OResult result = upstream.next();
                if (result instanceof OResultInternal) {
                    for (OUpdateItem item : UpdateSetStep.this.items) {
                        Object clazz;
                        OClass type = result.getElement().flatMap(x -> x.getSchemaType()).orElse(null);
                        if (type == null && (clazz = result.getProperty("@view")) instanceof String) {
                            type = ctx.getDatabase().getMetadata().getSchema().getView((String)clazz);
                        }
                        item.applyUpdate((OResultInternal)result, ctx);
                    }
                }
                return result;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ UPDATE SET");
        for (int i = 0; i < this.items.size(); ++i) {
            OUpdateItem item = this.items.get(i);
            if (i < this.items.size()) {
                result.append("\n");
            }
            result.append(spaces);
            result.append("  ");
            result.append(item.toString());
        }
        return result.toString();
    }
}

