/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OJson;
import java.util.Map;
import java.util.Optional;

public class UpdateMergeStep
extends AbstractExecutionStep {
    private final OJson json;

    public UpdateMergeStep(OJson json, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.json = json;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                OResult result = upstream.next();
                if (result instanceof OResultInternal) {
                    if (!(result.getElement().orElse(null) instanceof ODocument)) {
                        ((OResultInternal)result).setElement((OIdentifiable)result.getElement().get().getRecord());
                    }
                    if (!(result.getElement().orElse(null) instanceof ODocument)) {
                        return result;
                    }
                    UpdateMergeStep.this.handleMerge(result.getElement().orElse(null), ctx);
                }
                return result;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void handleMerge(ODocument record, OCommandContext ctx) {
        record.merge(this.json.toDocument(record, ctx), true, false);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ UPDATE MERGE\n");
        result.append(spaces);
        result.append("  ");
        result.append(this.json);
        return result.toString();
    }
}

