/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.AbstractUnrollStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import java.util.ArrayList;
import java.util.Collection;

public class ReturnMatchElementsStep
extends AbstractUnrollStep {
    public ReturnMatchElementsStep(OCommandContext context, boolean profilingEnabled) {
        super(context, profilingEnabled);
    }

    @Override
    protected Collection<OResult> unroll(OResult doc, OCommandContext iContext) {
        ArrayList<OResult> result = new ArrayList<OResult>();
        for (String s : doc.getPropertyNames()) {
            if (s.startsWith("$ORIENT_DEFAULT_ALIAS_")) continue;
            Object elem = doc.getProperty(s);
            if (elem instanceof OIdentifiable) {
                OResultInternal newelem = new OResultInternal();
                newelem.setElement((OIdentifiable)elem);
                elem = newelem;
            }
            if (!(elem instanceof OResult)) continue;
            result.add((OResult)elem);
        }
        return result;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ UNROLL $elements";
    }
}

