/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.MatchEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.MatchStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OptionalMatchEdgeTraverser;

public class OptionalMatchStep
extends MatchStep {
    public OptionalMatchStep(OCommandContext context, EdgeTraversal edge, boolean profilingEnabled) {
        super(context, edge, profilingEnabled);
    }

    @Override
    protected MatchEdgeTraverser createTraverser(OResult lastUpstreamRecord) {
        return new OptionalMatchEdgeTraverser(lastUpstreamRecord, this.edge);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ OPTIONAL MATCH ");
        if (this.edge.out) {
            result.append(" ---->\n");
        } else {
            result.append("     <----\n");
        }
        result.append(spaces);
        result.append("  ");
        result.append("{" + this.edge.edge.out.alias + "}");
        result.append(this.edge.edge.item.getMethod());
        result.append("{" + this.edge.edge.in.alias + "}");
        return result.toString();
    }
}

