/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.ReturnStep;
import com.orientechnologies.orient.core.sql.executor.ScriptLineStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OScriptExecutionPlan
implements OInternalExecutionPlan {
    private String location;
    private final OCommandContext ctx;
    boolean executed = false;
    protected List<ScriptLineStep> steps = new ArrayList<ScriptLineStep>();
    OExecutionStepInternal lastStep = null;
    OResultSet finalResult = null;

    public OScriptExecutionPlan(OCommandContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void reset(OCommandContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.lastStep.close();
    }

    @Override
    public OResultSet fetchNext(final int n) {
        this.doExecute(n);
        return new OResultSet(){
            int totalFetched = 0;

            @Override
            public boolean hasNext() {
                return OScriptExecutionPlan.this.finalResult.hasNext() && this.totalFetched < n;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return OScriptExecutionPlan.this.finalResult.next();
            }

            @Override
            public void close() {
                OScriptExecutionPlan.this.finalResult.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return OScriptExecutionPlan.this.finalResult == null ? Optional.empty() : OScriptExecutionPlan.this.finalResult.getExecutionPlan();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void doExecute(int n) {
        if (!this.executed) {
            this.executeUntilReturn();
            this.executed = true;
            this.finalResult = new OInternalResultSet();
            OResultSet partial = this.lastStep.syncPull(this.ctx, n);
            while (partial.hasNext()) {
                while (partial.hasNext()) {
                    ((OInternalResultSet)this.finalResult).add(partial.next());
                }
                partial = this.lastStep.syncPull(this.ctx, n);
            }
            if (this.lastStep instanceof ScriptLineStep) {
                ((OInternalResultSet)this.finalResult).setPlan(((ScriptLineStep)this.lastStep).plan);
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.steps.size(); ++i) {
            OExecutionStepInternal step = this.steps.get(i);
            result.append(step.prettyPrint(depth, indent));
            if (i >= this.steps.size() - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public void chain(OInternalExecutionPlan nextPlan, boolean profilingEnabled) {
        ScriptLineStep lastStep = this.steps.size() == 0 ? null : this.steps.get(this.steps.size() - 1);
        ScriptLineStep nextStep = new ScriptLineStep(nextPlan, this.ctx, profilingEnabled);
        if (lastStep != null) {
            lastStep.setNext(nextStep);
            nextStep.setPrevious(lastStep);
        }
        this.steps.add(nextStep);
        this.lastStep = nextStep;
    }

    @Override
    public List<OExecutionStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<OExecutionStepInternal> steps) {
        this.steps = steps;
    }

    @Override
    public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "ScriptExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        result.setProperty("steps", this.steps == null ? null : this.steps.stream().map(x -> x.toResult()).collect(Collectors.toList()));
        return result;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    public boolean containsReturn() {
        for (OExecutionStepInternal oExecutionStepInternal : this.steps) {
            if (oExecutionStepInternal instanceof ReturnStep) {
                return true;
            }
            if (!(oExecutionStepInternal instanceof ScriptLineStep)) continue;
            return ((ScriptLineStep)oExecutionStepInternal).containsReturn();
        }
        return false;
    }

    public OExecutionStepInternal executeUntilReturn() {
        if (this.steps.size() > 0) {
            this.lastStep = this.steps.get(this.steps.size() - 1);
        }
        for (int i = 0; i < this.steps.size() - 1; ++i) {
            OExecutionStepInternal returnStep;
            ScriptLineStep step = this.steps.get(i);
            if (step.containsReturn() && (returnStep = step.executeUntilReturn(this.ctx)) != null) {
                this.lastStep = returnStep;
                return this.lastStep;
            }
            OResultSet lastResult = step.syncPull(this.ctx, 100);
            while (lastResult.hasNext()) {
                while (lastResult.hasNext()) {
                    lastResult.next();
                }
                lastResult = step.syncPull(this.ctx, 100);
            }
        }
        this.lastStep = this.steps.get(this.steps.size() - 1);
        return this.lastStep;
    }

    public OExecutionStepInternal executeFull() {
        for (int i = 0; i < this.steps.size(); ++i) {
            OExecutionStepInternal returnStep;
            ScriptLineStep step = this.steps.get(i);
            if (step.containsReturn() && (returnStep = step.executeUntilReturn(this.ctx)) != null) {
                return returnStep;
            }
            OResultSet lastResult = step.syncPull(this.ctx, 100);
            while (lastResult.hasNext()) {
                while (lastResult.hasNext()) {
                    lastResult.next();
                }
                lastResult = step.syncPull(this.ctx, 100);
            }
        }
        return null;
    }
}

