/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface OResult {
    public <T> T getProperty(String var1);

    public OElement getElementProperty(String var1);

    public OVertex getVertexProperty(String var1);

    public OEdge getEdgeProperty(String var1);

    public OBlob getBlobProperty(String var1);

    public Set<String> getPropertyNames();

    public Optional<ORID> getIdentity();

    public boolean isElement();

    public Optional<OElement> getElement();

    public OElement toElement();

    default public boolean isVertex() {
        return this.getElement().map(x -> x.isVertex()).orElse(false);
    }

    default public Optional<OVertex> getVertex() {
        return this.getElement().flatMap(x -> x.asVertex());
    }

    default public boolean isEdge() {
        return this.getElement().map(x -> x.isEdge()).orElse(false);
    }

    default public Optional<OEdge> getEdge() {
        return this.getElement().flatMap(x -> x.asEdge());
    }

    public boolean isBlob();

    public Optional<OBlob> getBlob();

    public Optional<ORecord> getRecord();

    default public boolean isRecord() {
        return !this.isProjection();
    }

    public boolean isProjection();

    public Object getMetadata(String var1);

    public Set<String> getMetadataKeys();

    default public String toJSON() {
        if (this.isElement()) {
            return this.getElement().get().toJSON();
        }
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        for (String prop : this.getPropertyNames()) {
            if (!first) {
                result.append(", ");
            }
            result.append(this.toJson(prop));
            result.append(": ");
            result.append(this.toJson(this.getProperty(prop)));
            first = false;
        }
        result.append("}");
        return result.toString();
    }

    default public String toJson(Object val) {
        String jsonVal = null;
        if (val == null) {
            jsonVal = "null";
        } else if (val instanceof String) {
            jsonVal = "\"" + this.encode(val.toString()) + "\"";
        } else if (val instanceof Number || val instanceof Boolean) {
            jsonVal = val.toString();
        } else if (val instanceof OResult) {
            jsonVal = ((OResult)val).toJSON();
        } else if (val instanceof OElement) {
            ORID id = ((OElement)val).getIdentity();
            jsonVal = id.isPersistent() ? "\"" + id + "\"" : ((OElement)val).toJSON();
        } else if (val instanceof ORID) {
            jsonVal = "\"" + val + "\"";
        } else if (val instanceof Iterable) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            Iterator iterator = ((Iterable)val).iterator();
            while (iterator.hasNext()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(this.toJson(iterator.next()));
                first = false;
            }
            builder.append("]");
            jsonVal = builder.toString();
        } else if (val instanceof Iterator) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            Iterator iterator = (Iterator)val;
            while (iterator.hasNext()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(this.toJson(iterator.next()));
                first = false;
            }
            builder.append("]");
            jsonVal = builder.toString();
        } else if (val instanceof Map) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            boolean first = true;
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(this.toJson(entry.getKey()));
                builder.append(": ");
                builder.append(this.toJson(entry.getValue()));
                first = false;
            }
            builder.append("}");
            jsonVal = builder.toString();
        } else if (val instanceof byte[]) {
            jsonVal = "\"" + Base64.getEncoder().encodeToString((byte[])val) + "\"";
        } else if (val instanceof Date) {
            jsonVal = "\"" + ODateHelper.getDateTimeFormatInstance().format(val) + "\"";
        } else {
            throw new UnsupportedOperationException("Cannot convert " + val + " - " + val.getClass() + " to JSON");
        }
        return jsonVal;
    }

    default public String encode(String s) {
        String result = s.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\"", "\\\\\"");
        result = result.replaceAll("\n", "\\\\n");
        result = result.replaceAll("\t", "\\\\t");
        result = result.replaceAll("\r", "\\\\r");
        return result;
    }

    public boolean hasProperty(String var1);
}

