/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OQueryStats {
    public Map<String, Long> stats = new ConcurrentHashMap<String, Long>();

    public static OQueryStats get(ODatabaseDocumentInternal db) {
        return db.getSharedContext().getQueryStats();
    }

    public long getIndexStats(String indexName, int params, boolean range, boolean additionalRange) {
        String key = this.generateKey("INDEX", indexName, String.valueOf(params), String.valueOf(range), String.valueOf(additionalRange));
        Long val = this.stats.get(key);
        if (val != null) {
            return val;
        }
        return -1L;
    }

    public void pushIndexStats(String indexName, int params, boolean range, boolean additionalRange, Long value) {
        String key = this.generateKey("INDEX", indexName, String.valueOf(params), String.valueOf(range), String.valueOf(additionalRange));
        this.pushValue(key, value);
    }

    public long getAverageOutEdgeSpan(String vertexClass, String edgeClass) {
        String key = this.generateKey(vertexClass, "-", edgeClass, "->");
        Long val = this.stats.get(key);
        if (val != null) {
            return val;
        }
        return -1L;
    }

    public long getAverageInEdgeSpan(String vertexClass, String edgeClass) {
        String key = this.generateKey(vertexClass, "<-", edgeClass, "-");
        Long val = this.stats.get(key);
        if (val != null) {
            return val;
        }
        return -1L;
    }

    public long getAverageBothEdgeSpan(String vertexClass, String edgeClass) {
        String key = this.generateKey(vertexClass, "-", edgeClass, "-");
        Long val = this.stats.get(key);
        if (val != null) {
            return val;
        }
        return -1L;
    }

    public void pushAverageOutEdgeSpan(String vertexClass, String edgeClass, Long value) {
        String key = this.generateKey(vertexClass, "-", edgeClass, "->");
        this.pushValue(key, value);
    }

    public void pushAverageInEdgeSpan(String vertexClass, String edgeClass, Long value) {
        String key = this.generateKey(vertexClass, "<-", edgeClass, "-");
        this.pushValue(key, value);
    }

    public void pushAverageBothEdgeSpan(String vertexClass, String edgeClass, Long value) {
        String key = this.generateKey(vertexClass, "-", edgeClass, "-");
        this.pushValue(key, value);
    }

    private void pushValue(String key, Long value) {
        if (value == null) {
            return;
        }
        Long val = this.stats.get(key);
        if (val == null) {
            val = value;
        } else {
            val = Double.valueOf((double)val.longValue() * 0.9 + (double)value.longValue() * 0.1).longValue();
            if (value > 0L && val == 0L) {
                val = 1L;
            }
        }
        this.stats.put(key, val);
    }

    protected String generateKey(String ... keys) {
        StringBuilder result = new StringBuilder();
        for (String s : keys) {
            result.append(".->");
            result.append(s);
        }
        return result.toString();
    }
}

