/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.CopyDocumentStep;
import com.orientechnologies.orient.core.sql.executor.CreateRecordStep;
import com.orientechnologies.orient.core.sql.executor.InsertIntoIndexStep;
import com.orientechnologies.orient.core.sql.executor.InsertValuesStep;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.RemoveEdgePointersStep;
import com.orientechnologies.orient.core.sql.executor.SaveElementStep;
import com.orientechnologies.orient.core.sql.executor.SetDocumentClassStep;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.executor.UpdateContentStep;
import com.orientechnologies.orient.core.sql.executor.UpdateSetStep;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OInsertSetExpression;
import com.orientechnologies.orient.core.sql.parser.OInsertStatement;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import java.util.ArrayList;

public class OInsertExecutionPlanner {
    protected OIdentifier targetClass;
    protected OIdentifier targetClusterName;
    protected OCluster targetCluster;
    protected OIndexIdentifier targetIndex;
    protected OInsertBody insertBody;
    protected OProjection returnStatement;
    protected OSelectStatement selectStatement;

    public OInsertExecutionPlanner() {
    }

    public OInsertExecutionPlanner(OInsertStatement statement) {
        this.targetClass = statement.getTargetClass() == null ? null : statement.getTargetClass().copy();
        this.targetClusterName = statement.getTargetClusterName() == null ? null : statement.getTargetClusterName().copy();
        this.targetCluster = statement.getTargetCluster() == null ? null : statement.getTargetCluster().copy();
        this.targetIndex = statement.getTargetIndex() == null ? null : statement.getTargetIndex().copy();
        this.insertBody = statement.getInsertBody() == null ? null : statement.getInsertBody().copy();
        this.returnStatement = statement.getReturnStatement() == null ? null : statement.getReturnStatement().copy();
        this.selectStatement = statement.getSelectStatement() == null ? null : statement.getSelectStatement().copy();
    }

    public OInsertExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OInsertExecutionPlan result = new OInsertExecutionPlan(ctx);
        if (this.targetIndex != null) {
            result.chain(new InsertIntoIndexStep(this.targetIndex, this.insertBody, ctx, enableProfiling));
        } else {
            if (this.selectStatement != null) {
                this.handleInsertSelect(result, this.selectStatement, ctx, enableProfiling);
            } else {
                this.handleCreateRecord(result, this.insertBody, ctx, enableProfiling);
            }
            this.handleTargetClass(result, this.targetClass, ctx, enableProfiling);
            this.handleSetFields(result, this.insertBody, ctx, enableProfiling);
            if (this.targetCluster != null) {
                String name = this.targetCluster.getClusterName();
                if (name == null) {
                    name = ctx.getDatabase().getClusterNameById(this.targetCluster.getClusterNumber());
                }
                this.handleSave(result, new OIdentifier(name), ctx, enableProfiling);
            } else {
                this.handleSave(result, this.targetClusterName, ctx, enableProfiling);
            }
            this.handleReturn(result, this.returnStatement, ctx, enableProfiling);
        }
        return result;
    }

    private void handleSave(OInsertExecutionPlan result, OIdentifier targetClusterName, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new SaveElementStep(ctx, targetClusterName, profilingEnabled));
    }

    private void handleReturn(OInsertExecutionPlan result, OProjection returnStatement, OCommandContext ctx, boolean profilingEnabled) {
        if (returnStatement != null) {
            result.chain(new ProjectionCalculationStep(returnStatement, ctx, profilingEnabled));
        }
    }

    private void handleSetFields(OInsertExecutionPlan result, OInsertBody insertBody, OCommandContext ctx, boolean profilingEnabled) {
        if (insertBody == null) {
            return;
        }
        if (insertBody.getIdentifierList() != null) {
            result.chain(new InsertValuesStep(insertBody.getIdentifierList(), insertBody.getValueExpressions(), ctx, profilingEnabled));
        } else if (insertBody.getContent() != null) {
            result.chain(new UpdateContentStep(insertBody.getContent(), ctx, profilingEnabled));
        } else if (insertBody.getSetExpressions() != null) {
            ArrayList<OUpdateItem> items = new ArrayList<OUpdateItem>();
            for (OInsertSetExpression exp : insertBody.getSetExpressions()) {
                OUpdateItem item = new OUpdateItem(-1);
                item.setOperator(0);
                item.setLeft(exp.getLeft().copy());
                item.setRight(exp.getRight().copy());
                items.add(item);
            }
            result.chain(new UpdateSetStep(items, ctx, profilingEnabled));
        }
    }

    private void handleTargetClass(OInsertExecutionPlan result, OIdentifier targetClass, OCommandContext ctx, boolean profilingEnabled) {
        if (targetClass != null) {
            result.chain(new SetDocumentClassStep(targetClass, ctx, profilingEnabled));
        }
    }

    private void handleCreateRecord(OInsertExecutionPlan result, OInsertBody body, OCommandContext ctx, boolean profilingEnabled) {
        int tot = 1;
        if (body != null && body.getValueExpressions() != null && body.getValueExpressions().size() > 0) {
            tot = body.getValueExpressions().size();
        }
        result.chain(new CreateRecordStep(ctx, tot, profilingEnabled));
    }

    private void handleInsertSelect(OInsertExecutionPlan result, OSelectStatement selectStatement, OCommandContext ctx, boolean profilingEnabled) {
        OInternalExecutionPlan subPlan = selectStatement.createExecutionPlan(ctx, profilingEnabled);
        result.chain(new SubQueryStep(subPlan, ctx, ctx, profilingEnabled));
        result.chain(new CopyDocumentStep(ctx, profilingEnabled));
        result.chain(new RemoveEdgePointersStep(ctx, profilingEnabled));
    }
}

