/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.CheckClassTypeStep;
import com.orientechnologies.orient.core.sql.executor.CreateEdgesStep;
import com.orientechnologies.orient.core.sql.executor.GlobalLetExpressionStep;
import com.orientechnologies.orient.core.sql.executor.InsertValuesStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.SaveElementStep;
import com.orientechnologies.orient.core.sql.executor.UpdateContentStep;
import com.orientechnologies.orient.core.sql.executor.UpdateSetStep;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OCreateEdgeStatement;
import com.orientechnologies.orient.core.sql.parser.OExecutionPlanCache;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OInsertSetExpression;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import java.util.ArrayList;

public class OCreateEdgeExecutionPlanner {
    private final OCreateEdgeStatement statement;
    protected OIdentifier targetClass;
    protected OIdentifier targetClusterName;
    protected OExpression leftExpression;
    protected OExpression rightExpression;
    protected boolean upsert = false;
    protected OInsertBody body;
    protected Number retry;
    protected Number wait;
    protected OBatch batch;

    public OCreateEdgeExecutionPlanner(OCreateEdgeStatement statement) {
        this.statement = statement;
        this.targetClass = statement.getTargetClass() == null ? null : statement.getTargetClass().copy();
        this.targetClusterName = statement.getTargetClusterName() == null ? null : statement.getTargetClusterName().copy();
        this.leftExpression = statement.getLeftExpression() == null ? null : statement.getLeftExpression().copy();
        this.rightExpression = statement.getRightExpression() == null ? null : statement.getRightExpression().copy();
        this.upsert = statement.isUpsert();
        this.body = statement.getBody() == null ? null : statement.getBody().copy();
        this.retry = statement.getRetry();
        this.wait = statement.getWait();
        this.batch = statement.getBatch() == null ? null : statement.getBatch().copy();
    }

    public OInsertExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling, boolean useCache) {
        OExecutionPlan plan;
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        if (useCache && !enableProfiling && this.statement.executinPlanCanBeCached() && (plan = OExecutionPlanCache.get(this.statement.getOriginalStatement(), ctx, db)) != null) {
            return (OInsertExecutionPlan)plan;
        }
        long planningStart = System.currentTimeMillis();
        if (this.targetClass == null) {
            OClass clazz;
            this.targetClass = this.targetClusterName == null ? new OIdentifier("E") : ((clazz = db.getMetadata().getSchema().getClassByClusterId(db.getClusterIdByName(this.targetClusterName.getStringValue()))) != null ? new OIdentifier(clazz.getName()) : new OIdentifier("E"));
        }
        OInsertExecutionPlan result = new OInsertExecutionPlan(ctx);
        this.handleCheckType(result, ctx, enableProfiling);
        this.handleGlobalLet(result, new OIdentifier("$__ORIENT_CREATE_EDGE_fromV"), this.leftExpression, ctx, enableProfiling);
        this.handleGlobalLet(result, new OIdentifier("$__ORIENT_CREATE_EDGE_toV"), this.rightExpression, ctx, enableProfiling);
        String uniqueIndexName = null;
        if (this.upsert) {
            OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(this.targetClass.getStringValue());
            if (clazz == null) {
                throw new OCommandExecutionException("Class " + this.targetClass + " not found in the db schema");
            }
            uniqueIndexName = clazz.getIndexes().stream().filter(x -> x.isUnique()).filter(x -> x.getDefinition().getFields().size() == 2 && x.getDefinition().getFields().contains("out") && x.getDefinition().getFields().contains("in")).map(x -> x.getName()).findFirst().orElse(null);
            if (uniqueIndexName == null) {
                throw new OCommandExecutionException("Cannot perform an UPSERT on " + this.targetClass + " edge class: no unique index present on out/in");
            }
        }
        result.chain(new CreateEdgesStep(this.targetClass, this.targetClusterName, uniqueIndexName, new OIdentifier("$__ORIENT_CREATE_EDGE_fromV"), new OIdentifier("$__ORIENT_CREATE_EDGE_toV"), this.wait, this.retry, this.batch, ctx, enableProfiling));
        this.handleSetFields(result, this.body, ctx, enableProfiling);
        this.handleSave(result, this.targetClusterName, ctx, enableProfiling);
        if (useCache && !enableProfiling && this.statement.executinPlanCanBeCached() && result.canBeCached() && OExecutionPlanCache.getLastInvalidation(db) < planningStart) {
            OExecutionPlanCache.put(this.statement.getOriginalStatement(), result, (ODatabaseDocumentInternal)ctx.getDatabase());
        }
        return result;
    }

    private void handleGlobalLet(OInsertExecutionPlan result, OIdentifier name, OExpression expression, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new GlobalLetExpressionStep(name, expression, ctx, profilingEnabled));
    }

    private void handleCheckType(OInsertExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        if (this.targetClass != null) {
            result.chain(new CheckClassTypeStep(this.targetClass.getStringValue(), "E", ctx, profilingEnabled));
        }
    }

    private void handleSave(OInsertExecutionPlan result, OIdentifier targetClusterName, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new SaveElementStep(ctx, targetClusterName, profilingEnabled));
    }

    private void handleSetFields(OInsertExecutionPlan result, OInsertBody insertBody, OCommandContext ctx, boolean profilingEnabled) {
        if (insertBody == null) {
            return;
        }
        if (insertBody.getIdentifierList() != null) {
            result.chain(new InsertValuesStep(insertBody.getIdentifierList(), insertBody.getValueExpressions(), ctx, profilingEnabled));
        } else if (insertBody.getContent() != null) {
            result.chain(new UpdateContentStep(insertBody.getContent(), ctx, profilingEnabled));
        } else if (insertBody.getSetExpressions() != null) {
            ArrayList<OUpdateItem> items = new ArrayList<OUpdateItem>();
            for (OInsertSetExpression exp : insertBody.getSetExpressions()) {
                OUpdateItem item = new OUpdateItem(-1);
                item.setOperator(0);
                item.setLeft(exp.getLeft().copy());
                item.setRight(exp.getRight().copy());
                items.add(item);
            }
            result.chain(new UpdateSetStep(items, ctx, profilingEnabled));
        }
    }
}

