/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.MatchEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItemFirst;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OMultiMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class MatchMultiEdgeTraverser
extends MatchEdgeTraverser {
    public MatchMultiEdgeTraverser(OResult lastUpstreamRecord, EdgeTraversal edge) {
        super(lastUpstreamRecord, edge);
    }

    @Override
    protected Iterable<OResultInternal> traversePatternEdge(OIdentifiable startingPoint, OCommandContext iCommandContext) {
        Iterable<OIdentifiable> possibleResults = null;
        OMultiMatchPathItem item = (OMultiMatchPathItem)this.item;
        ArrayList<OResultInternal> result = new ArrayList<OResultInternal>();
        ArrayList<OIdentifiable> nextStep = new ArrayList<OIdentifiable>();
        nextStep.add(startingPoint);
        Object oldCurrent = iCommandContext.getVariable("$current");
        for (OMatchPathItem sub : item.getItems()) {
            ArrayList<OResultInternal> rightSide = new ArrayList<OResultInternal>();
            for (Object e : nextStep) {
                OWhereClause whileCond = sub.getFilter() == null ? null : sub.getFilter().getWhileCondition();
                OMethodCall method = sub.getMethod();
                if (sub instanceof OMatchPathItemFirst) {
                    method = ((OMatchPathItemFirst)sub).getFunction().toMethod();
                }
                if (whileCond != null) {
                    Object current = e;
                    if (current instanceof OResult) {
                        current = ((OResult)current).getElement().orElse(null);
                    }
                    MatchEdgeTraverser subtraverser = new MatchEdgeTraverser(null, sub);
                    subtraverser.executeTraversal(iCommandContext, sub, (OIdentifiable)current, 0, null).forEach(x -> rightSide.add((OResultInternal)x));
                    continue;
                }
                iCommandContext.setVariable("$current", e);
                Object nextSteps = method.execute(e, possibleResults, iCommandContext);
                if (nextSteps instanceof Collection) {
                    ((Collection)nextSteps).stream().map(x -> this.toOResultInternal(x)).filter(Objects::nonNull).forEach(i -> rightSide.add((OResultInternal)i));
                    continue;
                }
                if (nextSteps instanceof OIdentifiable) {
                    rightSide.add(new OResultInternal((OIdentifiable)nextSteps));
                    continue;
                }
                if (nextSteps instanceof OResultInternal) {
                    rightSide.add((OResultInternal)nextSteps);
                    continue;
                }
                if (nextSteps instanceof Iterable) {
                    for (Object step : (Iterable)nextSteps) {
                        OResultInternal converted = this.toOResultInternal(step);
                        if (converted == null) continue;
                        rightSide.add(converted);
                    }
                    continue;
                }
                if (!(nextSteps instanceof Iterator)) continue;
                Iterator iterator = (Iterator)nextSteps;
                while (iterator.hasNext()) {
                    OResultInternal converted = this.toOResultInternal(iterator.next());
                    if (converted == null) continue;
                    rightSide.add(converted);
                }
            }
            nextStep = rightSide;
            result = rightSide;
        }
        iCommandContext.setVariable("$current", oldCurrent);
        return result;
    }

    private OResultInternal toOResultInternal(Object x) {
        if (x instanceof OResultInternal) {
            return (OResultInternal)x;
        }
        if (x instanceof OIdentifiable) {
            return new OResultInternal((OIdentifiable)x);
        }
        throw new OCommandExecutionException("Cannot execute traversal on " + x);
    }
}

