/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import java.util.Map;
import java.util.Optional;

public class GuaranteeEmptyCountStep
extends AbstractExecutionStep {
    private final OProjectionItem item;
    boolean executed = false;

    public GuaranteeEmptyCountStep(OProjectionItem oProjectionItem, OCommandContext ctx, boolean enableProfiling) {
        super(ctx, enableProfiling);
        this.item = oProjectionItem;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OResultSet upstream = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                if (!GuaranteeEmptyCountStep.this.executed) {
                    return true;
                }
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                try {
                    if (upstream.hasNext()) {
                        OResult oResult = upstream.next();
                        return oResult;
                    }
                    OResultInternal result = new OResultInternal();
                    result.setProperty(GuaranteeEmptyCountStep.this.item.getProjectionAliasAsString(), 0L);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    GuaranteeEmptyCountStep.this.executed = true;
                }
            }

            @Override
            public void close() {
                ((OExecutionStepInternal)GuaranteeEmptyCountStep.this.prev.get()).close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new GuaranteeEmptyCountStep(this.item.copy(), ctx, this.profilingEnabled);
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        result.append(OExecutionStepInternal.getIndent(depth, indent) + "+ GUARANTEE FOR ZERO COUNT ");
        return result.toString();
    }
}

